/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.converter.Converter;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.util.Util;

public abstract class ARGBARGBColorConverter<R>
implements ColorConverter,
Converter<R, ARGBType> {
    protected double min = 0.0;
    protected double max = 1.0;
    protected final ARGBType color = new ARGBType(ARGBType.rgba((int)255, (int)255, (int)255, (int)255));
    protected int A;
    protected double scaleR;
    protected double scaleG;
    protected double scaleB;
    protected int black = 0;

    public ARGBARGBColorConverter(double min, double max) {
        this.min = min;
        this.max = max;
        this.update();
    }

    @Override
    public ARGBType getColor() {
        return this.color.copy();
    }

    @Override
    public void setColor(ARGBType c) {
        this.color.set(c);
        this.update();
    }

    @Override
    public boolean supportsColor() {
        return true;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.update();
    }

    public void setMin(double min) {
        this.min = min;
        this.update();
    }

    private void update() {
        double scale = 1.0 / (this.max - this.min);
        int value = this.color.get();
        this.A = ARGBType.alpha((int)value);
        this.scaleR = (double)ARGBType.red((int)value) * scale;
        this.scaleG = (double)ARGBType.green((int)value) * scale;
        this.scaleB = (double)ARGBType.blue((int)value) * scale;
        this.black = 0;
    }

    int convertColor(int color) {
        int a = ARGBType.alpha((int)color);
        int r = ARGBType.red((int)color);
        int g = ARGBType.green((int)color);
        int b = ARGBType.blue((int)color);
        int v = Math.min(255, Math.max(0, (r + g + b) / 3));
        int newR = (int)Math.min(255L, Util.round((double)(this.scaleR * (double)v)));
        int newG = (int)Math.min(255L, Util.round((double)(this.scaleG * (double)v)));
        int newB = (int)Math.min(255L, Util.round((double)(this.scaleB * (double)v)));
        return ARGBType.rgba((int)newR, (int)newG, (int)newB, (int)a);
    }

    public static class VolatileToGray
    extends ARGBARGBColorConverter<VolatileARGBType> {
        public VolatileToGray(double min, double max) {
            super(min, max);
        }

        public void convert(VolatileARGBType input, ARGBType output) {
            output.set(this.convertColor(((ARGBType)input.get()).get()));
        }
    }

    public static class ToGray
    extends ARGBARGBColorConverter<ARGBType> {
        public ToGray(double min, double max) {
            super(min, max);
        }

        public void convert(ARGBType input, ARGBType output) {
            output.set(this.convertColor(input.get()));
        }
    }
}

