/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.ARGBType;

class RenderStorage {
    private final byte[][] renderMaskArrays;
    private final int[][] renderImageArrays;

    public RenderStorage(int screenW, int screenH, int numVisibleSources) {
        int size = screenW * screenH;
        this.renderMaskArrays = new byte[numVisibleSources][size];
        this.renderImageArrays = new int[numVisibleSources][size];
    }

    public byte[] getMaskArray(int index) {
        return this.renderMaskArrays[index];
    }

    public RandomAccessibleInterval<ARGBType> getRenderImage(int width, int height, int index) {
        return ArrayImgs.argbs((int[])this.renderImageArrays[index], (long[])new long[]{width, height});
    }
}

