/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.Interpolation;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccess;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;

public class Prefetcher {
    private final double[] xStep = new double[3];
    private final double[] offsetNeg = new double[3];
    private final double[] offsetPos = new double[3];
    private static final double eps = 1.0E-7;

    public static void fetchCells(AffineTransform3D sourceToScreen, int[] cellDimensions, long[] dimensions, Dimensions screenInterval, Interpolation interpolation, RandomAccess<?> cellsRandomAccess) {
        new Prefetcher().scan(sourceToScreen, cellDimensions, dimensions, screenInterval, interpolation, cellsRandomAccess);
    }

    private Prefetcher() {
    }

    private void scan(AffineTransform3D sourceToScreen, int[] cellDimensions, long[] dimensions, Dimensions screenInterval, Interpolation interpolation, RandomAccess<?> cellsRandomAccess) {
        RealPoint pSource = new RealPoint(3);
        RealPoint pScreen = new RealPoint(3);
        int[] minCell = new int[3];
        int[] maxCell = new int[3];
        int w = (int)screenInterval.dimension(0);
        int h = (int)screenInterval.dimension(1);
        for (int d = 0; d < 3; ++d) {
            maxCell[d] = (int)((dimensions[d] - 1L) / (long)cellDimensions[d]);
        }
        RealPoint[] screenCorners = new RealPoint[]{new RealPoint(new double[]{0.0, 0.0, 0.0}), new RealPoint(new double[]{w, 0.0, 0.0}), new RealPoint(new double[]{w, h, 0.0}), new RealPoint(new double[]{0.0, h, 0.0})};
        RealPoint sourceCorner = new RealPoint(3);
        double[] bbMin = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] bbMax = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < 4; ++i) {
            sourceToScreen.applyInverse((RealPositionable)sourceCorner, (RealLocalizable)screenCorners[i]);
            for (int d = 0; d < 3; ++d) {
                double p = sourceCorner.getDoublePosition(d);
                if (p < bbMin[d]) {
                    bbMin[d] = p;
                }
                if (!(p > bbMax[d])) continue;
                bbMax[d] = p;
            }
        }
        for (int d = 0; d < 3; ++d) {
            minCell[d] = Math.min(maxCell[d], Math.max((int)bbMin[d] / cellDimensions[d] - 1, 0));
            maxCell[d] = Math.max(0, Math.min((int)bbMax[d] / cellDimensions[d] + 1, maxCell[d]));
        }
        this.checkProtoCell(cellDimensions, sourceToScreen, interpolation);
        this.getXStep(cellDimensions, sourceToScreen);
        pSource.setPosition((minCell[2] - 1) * cellDimensions[2], 2);
        cellsRandomAccess.setPosition(minCell[2], 2);
        while (cellsRandomAccess.getIntPosition(2) <= maxCell[2]) {
            pSource.move(cellDimensions[2], 2);
            pSource.setPosition((minCell[1] - 1) * cellDimensions[1], 1);
            cellsRandomAccess.setPosition(minCell[1], 1);
            while (cellsRandomAccess.getIntPosition(1) <= maxCell[1]) {
                block14: {
                    int nStop;
                    int nStart;
                    block13: {
                        double z0;
                        block15: {
                            block12: {
                                pSource.move(cellDimensions[1], 1);
                                pSource.setPosition(minCell[0] * cellDimensions[0], 0);
                                sourceToScreen.apply((RealLocalizable)pSource, (RealPositionable)pScreen);
                                z0 = pScreen.getDoublePosition(2);
                                nStart = 0;
                                nStop = 0;
                                if (!(this.xStep[2] > 1.0E-7)) break block12;
                                nStart = minCell[0] + Math.max(0, (int)Math.ceil(-(z0 + this.offsetPos[2]) / this.xStep[2]));
                                if (nStart <= maxCell[0] && (nStop = Math.min(maxCell[0], minCell[0] + (int)Math.floor(-(z0 + this.offsetNeg[2]) / this.xStep[2]))) >= minCell[0]) break block13;
                                break block14;
                            }
                            if (!(this.xStep[2] < -1.0E-7)) break block15;
                            nStart = minCell[0] + Math.max(0, (int)Math.ceil(-(z0 + this.offsetNeg[2]) / this.xStep[2]));
                            if (nStart <= maxCell[0] && (nStop = Math.min(maxCell[0], minCell[0] + (int)Math.floor(-(z0 + this.offsetPos[2]) / this.xStep[2]))) >= minCell[0]) break block13;
                            break block14;
                        }
                        if (z0 + this.offsetNeg[2] > 0.0 || z0 + this.offsetPos[2] < 0.0) break block14;
                        nStart = minCell[0];
                        nStop = maxCell[0];
                    }
                    pSource.setPosition(nStart * cellDimensions[0], 0);
                    cellsRandomAccess.setPosition(nStart, 0);
                    while (cellsRandomAccess.getIntPosition(0) <= nStop) {
                        sourceToScreen.apply((RealLocalizable)pSource, (RealPositionable)pScreen);
                        double x = pScreen.getDoublePosition(0);
                        double y = pScreen.getDoublePosition(1);
                        if (x + this.offsetPos[0] >= 0.0 && x + this.offsetNeg[0] < (double)w && y + this.offsetPos[1] >= 0.0 && y + this.offsetNeg[1] < (double)h) {
                            cellsRandomAccess.get();
                        }
                        pSource.move(cellDimensions[0], 0);
                        cellsRandomAccess.fwd(0);
                    }
                }
                cellsRandomAccess.fwd(1);
            }
            cellsRandomAccess.fwd(2);
        }
    }

    private void getXStep(int[] cellStep, AffineTransform3D sourceToScreen) {
        RealPoint p0 = new RealPoint(3);
        RealPoint p1 = new RealPoint(3);
        p1.setPosition(cellStep[0], 0);
        RealPoint s0 = new RealPoint(3);
        RealPoint s1 = new RealPoint(3);
        sourceToScreen.apply((RealLocalizable)p0, (RealPositionable)s0);
        sourceToScreen.apply((RealLocalizable)p1, (RealPositionable)s1);
        for (int d = 0; d < 3; ++d) {
            this.xStep[d] = s1.getDoublePosition(d) - s0.getDoublePosition(d);
        }
    }

    private void checkProtoCell(int[] cellDims, AffineTransform3D sourceToScreen, Interpolation interpolation) {
        int d;
        RealPoint pSource = new RealPoint(3);
        RealPoint pScreenAnchor = new RealPoint(3);
        sourceToScreen.apply((RealLocalizable)pSource, (RealPositionable)pScreenAnchor);
        RealPoint[] pScreen = new RealPoint[8];
        double[] cellMin = new double[3];
        double[] cellSize = new double[]{cellDims[0], cellDims[1], cellDims[2]};
        if (interpolation == Interpolation.NEARESTNEIGHBOR) {
            d = 0;
            while (d < 3) {
                int n = d;
                cellMin[n] = cellMin[n] - 0.5;
                int n2 = d++;
                cellSize[n2] = cellSize[n2] - 0.5;
            }
        } else {
            d = 0;
            while (d < 3) {
                int n = d++;
                cellMin[n] = cellMin[n] - 1.0;
            }
        }
        int i = 0;
        for (int z = 0; z < 2; ++z) {
            pSource.setPosition(z == 0 ? cellMin[2] : cellSize[2], 2);
            for (int y = 0; y < 2; ++y) {
                pSource.setPosition(y == 0 ? cellMin[1] : cellSize[1], 1);
                for (int x = 0; x < 2; ++x) {
                    pSource.setPosition(x == 0 ? cellMin[0] : cellSize[0], 0);
                    pScreen[i] = new RealPoint(3);
                    sourceToScreen.apply((RealLocalizable)pSource, (RealPositionable)pScreen[i++]);
                }
            }
        }
        for (int d2 = 0; d2 < 3; ++d2) {
            double min = pScreen[0].getDoublePosition(d2);
            double max = pScreen[0].getDoublePosition(d2);
            for (i = 1; i < 8; ++i) {
                double p = pScreen[i].getDoublePosition(d2);
                if (p < min) {
                    min = p;
                }
                if (!(p > max)) continue;
                max = p;
            }
            this.offsetNeg[d2] = min - pScreenAnchor.getDoublePosition(d2);
            this.offsetPos[d2] = max - pScreenAnchor.getDoublePosition(d2);
        }
    }
}

