/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.SourceAndConverter;
import bdv.viewer.render.AccumulateProjector;
import bdv.viewer.render.AccumulateProjectorFactory;
import bdv.viewer.render.ProjectorUtils;
import bdv.viewer.render.Tiling;
import bdv.viewer.render.VolatileProjector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.util.Intervals;
import net.imglib2.util.StopWatch;

public class AccumulateProjectorARGB {
    public static AccumulateProjectorFactory<ARGBType> factory = new Factory();

    private static ProjectorData getProjectorData(List<? extends RandomAccessible<? extends ARGBType>> sources, RandomAccessibleInterval<ARGBType> target) {
        ProjectorUtils.ArrayData targetData = ProjectorUtils.getARGBArrayData(target);
        if (targetData == null) {
            return null;
        }
        int numSources = sources.size();
        ArrayList<int[]> sourceData = new ArrayList<int[]>(numSources);
        for (int i = 0; i < numSources; ++i) {
            RandomAccessible<? extends ARGBType> source = sources.get(i);
            if (!(source instanceof RandomAccessibleInterval)) {
                return null;
            }
            if (!Intervals.equals(target, (Interval)((Interval)source))) {
                return null;
            }
            int[] data = ProjectorUtils.getARGBArrayImgData(source);
            if (data == null) {
                return null;
            }
            sourceData.add(data);
        }
        return new ProjectorData(targetData, sourceData);
    }

    private static class AccumulateProjectorARGBGeneric
    extends AccumulateProjector<ARGBType, ARGBType> {
        public AccumulateProjectorARGBGeneric(List<VolatileProjector> sourceProjectors, List<? extends RandomAccessible<? extends ARGBType>> sources, RandomAccessibleInterval<ARGBType> target) {
            super(sourceProjectors, sources, target);
        }

        @Override
        protected void accumulate(Cursor<? extends ARGBType>[] accesses, ARGBType target) {
            int aSum = 0;
            int rSum = 0;
            int gSum = 0;
            int bSum = 0;
            for (Cursor<? extends ARGBType> access : accesses) {
                int value = ((ARGBType)access.get()).get();
                int a = ARGBType.alpha((int)value);
                int r = ARGBType.red((int)value);
                int g = ARGBType.green((int)value);
                int b = ARGBType.blue((int)value);
                aSum += a;
                rSum += r;
                gSum += g;
                bSum += b;
            }
            if (aSum > 255) {
                aSum = 255;
            }
            if (rSum > 255) {
                rSum = 255;
            }
            if (gSum > 255) {
                gSum = 255;
            }
            if (bSum > 255) {
                bSum = 255;
            }
            target.set(ARGBType.rgba((int)rSum, (int)gSum, (int)bSum, (int)aSum));
        }
    }

    private static class AccumulateProjectorARGBArrayData
    implements VolatileProjector {
        private List<VolatileProjector> sourceProjectors;
        private final List<int[]> sources;
        private final ProjectorUtils.ArrayData target;
        private long lastFrameRenderNanoTime;
        private volatile boolean canceled = false;
        private volatile boolean valid = false;

        public AccumulateProjectorARGBArrayData(List<VolatileProjector> sourceProjectors, ProjectorData projectorData) {
            this.sourceProjectors = sourceProjectors;
            this.target = projectorData.targetData();
            this.sources = projectorData.sourceData();
        }

        @Override
        public boolean map(boolean clearUntouchedTargetPixels) {
            if (this.canceled) {
                return false;
            }
            if (this.isValid()) {
                return true;
            }
            StopWatch stopWatch = StopWatch.createAndStart();
            if (this.target.size() < Tiling.MIN_ACCUMULATE_FORK_SIZE) {
                this.sourceProjectors.forEach(p -> p.map(clearUntouchedTargetPixels));
            } else {
                ForkJoinTask.invokeAll(this.sourceProjectors.stream().map(p -> ForkJoinTask.adapt(() -> p.map(clearUntouchedTargetPixels))).collect(Collectors.toList()));
            }
            if (this.canceled) {
                return false;
            }
            this.mapAccumulate();
            this.sourceProjectors = this.sourceProjectors.stream().filter(p -> !p.isValid()).collect(Collectors.toList());
            this.lastFrameRenderNanoTime = stopWatch.nanoTime();
            this.valid = this.sourceProjectors.isEmpty();
            return !this.canceled;
        }

        private void mapAccumulate() {
            if (this.canceled) {
                return;
            }
            int numSources = this.sources.size();
            int[] acc = new int[this.target.width() << 2];
            for (int y = 0; y < this.target.height(); ++y) {
                int oTarget = (y + this.target.oy()) * this.target.stride() + this.target.ox();
                int oSource = y * this.target.width();
                Arrays.fill(acc, 0);
                for (int s = 0; s < numSources; ++s) {
                    int[] source = this.sources.get(s);
                    for (int x = 0; x < this.target.width(); ++x) {
                        int value = source[oSource + x];
                        int n = x << 2;
                        acc[n] = acc[n] + ARGBType.alpha((int)value);
                        int n2 = (x << 2) + 1;
                        acc[n2] = acc[n2] + ARGBType.red((int)value);
                        int n3 = (x << 2) + 2;
                        acc[n3] = acc[n3] + ARGBType.green((int)value);
                        int n4 = (x << 2) + 3;
                        acc[n4] = acc[n4] + ARGBType.blue((int)value);
                    }
                }
                for (int x = 0; x < this.target.width(); ++x) {
                    int aSum = Math.min(255, acc[x << 2]);
                    int rSum = Math.min(255, acc[(x << 2) + 1]);
                    int gSum = Math.min(255, acc[(x << 2) + 2]);
                    int bSum = Math.min(255, acc[(x << 2) + 3]);
                    this.target.data()[oTarget + x] = ARGBType.rgba((int)rSum, (int)gSum, (int)bSum, (int)aSum);
                }
            }
        }

        @Override
        public void cancel() {
            this.canceled = true;
            for (VolatileProjector p : this.sourceProjectors) {
                p.cancel();
            }
        }

        @Override
        public long getLastFrameRenderNanoTime() {
            return this.lastFrameRenderNanoTime;
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }
    }

    private static class ProjectorData {
        private final ProjectorUtils.ArrayData targetData;
        private final List<int[]> sourceData;

        ProjectorData(ProjectorUtils.ArrayData targetData, List<int[]> sourceData) {
            this.targetData = targetData;
            this.sourceData = sourceData;
        }

        ProjectorUtils.ArrayData targetData() {
            return this.targetData;
        }

        List<int[]> sourceData() {
            return this.sourceData;
        }
    }

    public static class Factory
    implements AccumulateProjectorFactory<ARGBType> {
        @Override
        public VolatileProjector createProjector(List<VolatileProjector> sourceProjectors, List<SourceAndConverter<?>> sources, List<? extends RandomAccessible<? extends ARGBType>> sourceScreenImages, RandomAccessibleInterval<ARGBType> targetScreenImage, int numThreads, ExecutorService executorService) {
            ProjectorData projectorData = AccumulateProjectorARGB.getProjectorData(sourceScreenImages, (RandomAccessibleInterval<ARGBType>)targetScreenImage);
            if (projectorData == null) {
                return new AccumulateProjectorARGBGeneric(sourceProjectors, sourceScreenImages, targetScreenImage);
            }
            return new AccumulateProjectorARGBArrayData(sourceProjectors, projectorData);
        }
    }
}

