/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.util.Affine3DHelpers;
import bdv.util.WrappedList;
import bdv.viewer.DisplayMode;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.UnmodifiableViewerState;
import bdv.viewer.ViewerState;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.listeners.Listeners;

public class BasicViewerState
implements ViewerState {
    private final Listeners.List<ViewerStateChangeListener> listeners = new Listeners.List();
    private int numTimepoints;
    private int currentTimepoint;
    private final AffineTransform3D viewerTransform;
    private Interpolation interpolation;
    private DisplayMode displayMode;
    private final List<SourceAndConverter<?>> sources;
    private final List<SourceAndConverter<?>> unmodifiableSources;
    private final Set<SourceAndConverter<?>> activeSources;
    private final Set<SourceAndConverter<?>> unmodifiableActiveSources;
    private SourceAndConverter<?> currentSource;
    private final TObjectIntMap<SourceAndConverter<?>> sourceIndices;
    private final Set<SourceAndConverter<?>> previousVisibleSources;
    private final List<SourceGroup> groups;
    private final List<SourceGroup> unmodifiableGroups;
    private final Map<SourceGroup, GroupData> groupData;
    private final Set<SourceGroup> activeGroups;
    private final Set<SourceGroup> unmodifiableActiveGroups;
    private SourceGroup currentGroup;
    private final TObjectIntMap<SourceGroup> groupIndices;
    private static final int NO_ENTRY_VALUE = -1;

    public BasicViewerState() {
        this.numTimepoints = 0;
        this.currentTimepoint = 0;
        this.viewerTransform = new AffineTransform3D();
        this.interpolation = Interpolation.NEARESTNEIGHBOR;
        this.displayMode = DisplayMode.SINGLE;
        this.sources = new ArrayList();
        this.unmodifiableSources = new UnmodifiableSources();
        this.activeSources = new HashSet();
        this.unmodifiableActiveSources = Collections.unmodifiableSet(this.activeSources);
        this.sourceIndices = new TObjectIntHashMap(10, 0.5f, -1);
        this.previousVisibleSources = new HashSet();
        this.groups = new ArrayList<SourceGroup>();
        this.unmodifiableGroups = new UnmodifiableGroups();
        this.groupData = new HashMap<SourceGroup, GroupData>();
        this.activeGroups = new HashSet<SourceGroup>();
        this.unmodifiableActiveGroups = Collections.unmodifiableSet(this.activeGroups);
        this.groupIndices = new TObjectIntHashMap(10, 0.5f, -1);
    }

    public BasicViewerState(ViewerState other) {
        int i;
        this.numTimepoints = other.getNumTimepoints();
        this.currentTimepoint = other.getCurrentTimepoint();
        this.viewerTransform = other.getViewerTransform();
        this.interpolation = other.getInterpolation();
        this.displayMode = other.getDisplayMode();
        this.sources = new ArrayList(other.getSources());
        this.unmodifiableSources = new UnmodifiableSources();
        this.activeSources = new HashSet(other.getActiveSources());
        this.unmodifiableActiveSources = Collections.unmodifiableSet(this.activeSources);
        this.currentSource = other.getCurrentSource();
        this.sourceIndices = new TObjectIntHashMap(10, 0.5f, -1);
        for (i = 0; i < this.sources.size(); ++i) {
            this.sourceIndices.put(this.sources.get(i), i);
        }
        this.previousVisibleSources = new HashSet(other.getVisibleSources());
        this.groups = new ArrayList<SourceGroup>(other.getGroups());
        this.unmodifiableGroups = new UnmodifiableGroups();
        this.groupData = new HashMap<SourceGroup, GroupData>();
        other.getGroups().forEach(group -> {
            GroupData data = new GroupData();
            data.name = other.getGroupName((SourceGroup)group);
            data.sources.addAll(other.getSourcesInGroup((SourceGroup)group));
            this.groupData.put((SourceGroup)group, data);
        });
        this.activeGroups = new HashSet<SourceGroup>(other.getActiveGroups());
        this.unmodifiableActiveGroups = Collections.unmodifiableSet(this.activeGroups);
        this.currentGroup = other.getCurrentGroup();
        this.groupIndices = new TObjectIntHashMap(10, 0.5f, -1);
        for (i = 0; i < this.groups.size(); ++i) {
            this.groupIndices.put((Object)this.groups.get(i), i);
        }
    }

    public void set(ViewerState other) {
        int i;
        this.numTimepoints = other.getNumTimepoints();
        this.currentTimepoint = other.getCurrentTimepoint();
        this.viewerTransform.set(other.getViewerTransform());
        this.interpolation = other.getInterpolation();
        this.displayMode = other.getDisplayMode();
        this.sources.clear();
        this.sources.addAll(other.getSources());
        this.activeSources.clear();
        this.activeSources.addAll(other.getActiveSources());
        this.currentSource = other.getCurrentSource();
        this.sourceIndices.clear();
        for (i = 0; i < this.sources.size(); ++i) {
            this.sourceIndices.put(this.sources.get(i), i);
        }
        this.previousVisibleSources.clear();
        this.previousVisibleSources.addAll(other.getVisibleSources());
        this.groups.clear();
        this.groups.addAll(other.getGroups());
        this.groupData.clear();
        other.getGroups().forEach(group -> {
            GroupData data = new GroupData();
            data.name = other.getGroupName((SourceGroup)group);
            data.sources.addAll(other.getSourcesInGroup((SourceGroup)group));
            this.groupData.put((SourceGroup)group, data);
        });
        this.activeGroups.clear();
        this.activeGroups.addAll(other.getActiveGroups());
        this.currentGroup = other.getCurrentGroup();
        this.groupIndices.clear();
        for (i = 0; i < this.groups.size(); ++i) {
            this.groupIndices.put((Object)this.groups.get(i), i);
        }
    }

    @Override
    public Listeners<ViewerStateChangeListener> changeListeners() {
        return this.listeners;
    }

    @Override
    public ViewerState snapshot() {
        return new UnmodifiableViewerState(new BasicViewerState(this));
    }

    @Override
    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    @Override
    public void setInterpolation(Interpolation i) {
        if (this.interpolation != i) {
            this.interpolation = i;
            this.notifyListeners(ViewerStateChange.INTERPOLATION_CHANGED);
        }
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void setDisplayMode(DisplayMode mode) {
        if (this.displayMode != mode) {
            this.displayMode = mode;
            this.notifyListeners(ViewerStateChange.DISPLAY_MODE_CHANGED);
            this.checkVisibilityChanged();
        }
    }

    @Override
    public int getNumTimepoints() {
        return this.numTimepoints;
    }

    @Override
    public void setNumTimepoints(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("numTimepoints must be >= 1");
        }
        if (this.numTimepoints != n) {
            this.numTimepoints = n;
            this.notifyListeners(ViewerStateChange.NUM_TIMEPOINTS_CHANGED);
            if (this.currentTimepoint > n - 1) {
                this.setCurrentTimepoint(n - 1);
            }
        }
    }

    @Override
    public int getCurrentTimepoint() {
        return this.currentTimepoint;
    }

    @Override
    public void setCurrentTimepoint(int t) {
        if (t >= this.numTimepoints || t < 0) {
            throw new IllegalArgumentException("currentTimepoint must be < numTimepoints and >= 0");
        }
        if (this.currentTimepoint != t) {
            this.currentTimepoint = t;
            this.notifyListeners(ViewerStateChange.CURRENT_TIMEPOINT_CHANGED);
        }
    }

    @Override
    public void getViewerTransform(AffineTransform3D t) {
        t.set(this.viewerTransform);
    }

    @Override
    public void setViewerTransform(AffineTransform3D t) {
        if (!Affine3DHelpers.equals(this.viewerTransform, t)) {
            this.viewerTransform.set(t);
            this.notifyListeners(ViewerStateChange.VIEWER_TRANSFORM_CHANGED);
        }
    }

    @Override
    public List<SourceAndConverter<?>> getSources() {
        return this.unmodifiableSources;
    }

    @Override
    public SourceAndConverter<?> getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public boolean isCurrentSource(SourceAndConverter<?> source) {
        return Objects.equals(source, this.currentSource);
    }

    @Override
    public boolean setCurrentSource(SourceAndConverter<?> source) {
        this.checkSourcePresentAllowNull(source);
        boolean modified = !Objects.equals(this.currentSource, source);
        this.currentSource = source;
        if (modified) {
            this.notifyListeners(ViewerStateChange.CURRENT_SOURCE_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public Set<SourceAndConverter<?>> getActiveSources() {
        return this.unmodifiableActiveSources;
    }

    @Override
    public boolean isSourceActive(SourceAndConverter<?> source) {
        this.checkSourcePresent(source);
        return this.activeSources.contains(source);
    }

    @Override
    public boolean setSourceActive(SourceAndConverter<?> source, boolean active) {
        boolean modified;
        this.checkSourcePresent(source);
        boolean bl = modified = active ? this.activeSources.add(source) : this.activeSources.remove(source);
        if (modified) {
            this.notifyListeners(ViewerStateChange.SOURCE_ACTIVITY_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean setSourcesActive(Collection<? extends SourceAndConverter<?>> collection, boolean active) {
        boolean modified;
        this.checkSourcesPresent(collection);
        boolean bl = modified = active ? this.activeSources.addAll(collection) : this.activeSources.removeAll(collection);
        if (modified) {
            this.notifyListeners(ViewerStateChange.SOURCE_ACTIVITY_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean isSourceVisible(SourceAndConverter<?> source) {
        this.checkSourcePresent(source);
        switch (this.displayMode) {
            default: {
                return Objects.equals(this.currentSource, source);
            }
            case GROUP: {
                return this.currentGroup != null && this.groupData.get((Object)this.currentGroup).sources.contains(source);
            }
            case FUSED: {
                return this.isSourceActive(source);
            }
            case FUSEDGROUP: 
        }
        for (SourceGroup group : this.activeGroups) {
            if (!this.groupData.get((Object)group).sources.contains(source)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSourceVisibleAndPresent(SourceAndConverter<?> source) {
        return this.isSourceVisible(source) && source.getSpimSource().isPresent(this.currentTimepoint);
    }

    @Override
    public Set<SourceAndConverter<?>> getVisibleSources() {
        HashSet visible = new HashSet();
        switch (this.displayMode) {
            case SINGLE: {
                if (this.currentSource == null) break;
                visible.add(this.currentSource);
                break;
            }
            case GROUP: {
                if (this.currentGroup == null) break;
                visible.addAll(this.groupData.get((Object)this.currentGroup).sources);
                break;
            }
            case FUSED: {
                visible.addAll(this.activeSources);
                break;
            }
            case FUSEDGROUP: {
                for (SourceGroup group : this.activeGroups) {
                    visible.addAll(this.groupData.get((Object)group).sources);
                }
                break;
            }
        }
        return visible;
    }

    @Override
    public Set<SourceAndConverter<?>> getVisibleAndPresentSources() {
        Set<SourceAndConverter<?>> visible = this.getVisibleSources();
        visible.removeIf(source -> !source.getSpimSource().isPresent(this.currentTimepoint));
        return visible;
    }

    @Override
    public boolean containsSource(SourceAndConverter<?> source) {
        if (source == null) {
            throw new NullPointerException();
        }
        return this.sourceIndices.containsKey(source);
    }

    @Override
    public boolean addSource(SourceAndConverter<?> source) {
        boolean modified;
        if (source == null) {
            throw new NullPointerException();
        }
        boolean bl = modified = !this.sourceIndices.containsKey(source);
        if (modified) {
            boolean currentSourceChanged;
            int nextIndex = this.sources.size();
            this.sources.add(source);
            this.sourceIndices.put(source, nextIndex);
            boolean bl2 = currentSourceChanged = this.currentSource == null;
            if (currentSourceChanged) {
                this.currentSource = source;
            }
            this.notifyListeners(ViewerStateChange.NUM_SOURCES_CHANGED);
            if (currentSourceChanged) {
                this.notifyListeners(ViewerStateChange.CURRENT_SOURCE_CHANGED);
            }
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean addSources(Collection<? extends SourceAndConverter<?>> collection) {
        this.checkAllNonNull(collection);
        boolean modified = false;
        boolean currentSourceChanged = false;
        for (SourceAndConverter<?> source : collection) {
            if (this.sourceIndices.containsKey(source)) continue;
            modified = true;
            int nextIndex = this.sources.size();
            this.sources.add(source);
            this.sourceIndices.put(source, nextIndex);
            if (this.currentSource != null) continue;
            currentSourceChanged = true;
            this.currentSource = source;
        }
        if (modified) {
            this.notifyListeners(ViewerStateChange.NUM_SOURCES_CHANGED);
            if (currentSourceChanged) {
                this.notifyListeners(ViewerStateChange.CURRENT_SOURCE_CHANGED);
            }
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean removeSource(SourceAndConverter<?> source) {
        boolean modified;
        if (source == null) {
            throw new NullPointerException();
        }
        int removedIndex = this.sourceIndices.remove(source);
        boolean bl = modified = removedIndex != -1;
        if (modified) {
            this.sources.remove(removedIndex);
            for (int i = removedIndex; i < this.sources.size(); ++i) {
                this.sourceIndices.put(this.sources.get(i), i);
            }
            this.activeSources.remove(source);
            boolean currentSourceChanged = source.equals(this.currentSource);
            if (currentSourceChanged) {
                this.currentSource = this.sources.isEmpty() ? null : this.sources.get(0);
            }
            boolean sourceToGroupAssignmentChanged = false;
            for (GroupData groupData : this.groupData.values()) {
                sourceToGroupAssignmentChanged |= groupData.sources.remove(source);
            }
            this.notifyListeners(ViewerStateChange.NUM_SOURCES_CHANGED);
            if (currentSourceChanged) {
                this.notifyListeners(ViewerStateChange.CURRENT_SOURCE_CHANGED);
            }
            if (sourceToGroupAssignmentChanged) {
                this.notifyListeners(ViewerStateChange.SOURCE_TO_GROUP_ASSIGNMENT_CHANGED);
            }
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean removeSources(Collection<? extends SourceAndConverter<?>> collection) {
        this.checkAllNonNull(collection);
        boolean modified = this.sources.removeAll(collection);
        boolean currentSourceChanged = collection.contains(this.currentSource);
        if (modified) {
            this.sourceIndices.clear();
            for (int i = 0; i < this.sources.size(); ++i) {
                this.sourceIndices.put(this.sources.get(i), i);
            }
            this.activeSources.removeAll(collection);
            boolean sourceToGroupAssignmentChanged = false;
            for (GroupData groupData : this.groupData.values()) {
                sourceToGroupAssignmentChanged |= groupData.sources.removeAll(this.sources);
            }
            if (currentSourceChanged) {
                this.currentSource = this.sources.isEmpty() ? null : this.sources.get(0);
            }
            this.notifyListeners(ViewerStateChange.NUM_SOURCES_CHANGED);
            if (currentSourceChanged) {
                this.notifyListeners(ViewerStateChange.CURRENT_SOURCE_CHANGED);
            }
            if (sourceToGroupAssignmentChanged) {
                this.notifyListeners(ViewerStateChange.SOURCE_TO_GROUP_ASSIGNMENT_CHANGED);
            }
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public void clearSources() {
        if (this.sources.isEmpty()) {
            return;
        }
        this.sources.clear();
        this.sourceIndices.clear();
        this.activeSources.clear();
        boolean sourceToGroupAssignmentChanged = false;
        for (GroupData groupData : this.groupData.values()) {
            sourceToGroupAssignmentChanged |= !groupData.sources.isEmpty();
            groupData.sources.clear();
        }
        boolean currentSourceChanged = this.currentSource != null;
        this.currentSource = null;
        this.notifyListeners(ViewerStateChange.NUM_SOURCES_CHANGED);
        if (currentSourceChanged) {
            this.notifyListeners(ViewerStateChange.CURRENT_SOURCE_CHANGED);
        }
        if (sourceToGroupAssignmentChanged) {
            this.notifyListeners(ViewerStateChange.SOURCE_TO_GROUP_ASSIGNMENT_CHANGED);
        }
        this.checkVisibilityChanged();
    }

    @Override
    public Comparator<SourceAndConverter<?>> sourceOrder() {
        return Comparator.comparingInt(arg_0 -> this.sourceIndices.get(arg_0));
    }

    @Override
    public List<SourceGroup> getGroups() {
        return this.unmodifiableGroups;
    }

    @Override
    public SourceGroup getCurrentGroup() {
        return this.currentGroup;
    }

    @Override
    public boolean isCurrentGroup(SourceGroup group) {
        return Objects.equals(group, this.currentGroup);
    }

    @Override
    public boolean setCurrentGroup(SourceGroup group) {
        this.checkGroupPresentAllowNull(group);
        boolean modified = !Objects.equals(this.currentGroup, group);
        this.currentGroup = group;
        if (modified) {
            this.notifyListeners(ViewerStateChange.CURRENT_GROUP_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public Set<SourceGroup> getActiveGroups() {
        return this.unmodifiableActiveGroups;
    }

    @Override
    public boolean isGroupActive(SourceGroup group) {
        this.checkGroupPresent(group);
        return this.activeGroups.contains(group);
    }

    @Override
    public boolean setGroupActive(SourceGroup group, boolean active) {
        boolean modified;
        this.checkGroupPresent(group);
        boolean bl = modified = active ? this.activeGroups.add(group) : this.activeGroups.remove(group);
        if (modified) {
            this.notifyListeners(ViewerStateChange.GROUP_ACTIVITY_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean setGroupsActive(Collection<? extends SourceGroup> collection, boolean active) {
        boolean modified;
        this.checkGroupsPresent(collection);
        boolean bl = modified = active ? this.activeGroups.addAll(collection) : this.activeGroups.removeAll(collection);
        if (modified) {
            this.notifyListeners(ViewerStateChange.GROUP_ACTIVITY_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public String getGroupName(SourceGroup group) {
        this.checkGroupPresent(group);
        return this.groupData.get((Object)group).name;
    }

    @Override
    public void setGroupName(SourceGroup group, String name) {
        this.checkGroupPresent(group);
        GroupData data = this.groupData.get(group);
        if (!Objects.equals(data.name, name)) {
            data.name = name;
            this.notifyListeners(ViewerStateChange.GROUP_NAME_CHANGED);
        }
    }

    @Override
    public boolean containsGroup(SourceGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        return this.groupIndices.containsKey((Object)group);
    }

    @Override
    public boolean addGroup(SourceGroup group) {
        boolean modified;
        if (group == null) {
            throw new NullPointerException();
        }
        boolean bl = modified = !this.groupIndices.containsKey((Object)group);
        if (modified) {
            boolean currentGroupChanged;
            int nextIndex = this.groups.size();
            this.groups.add(group);
            this.groupData.put(group, new GroupData());
            this.groupIndices.put((Object)group, nextIndex);
            boolean bl2 = currentGroupChanged = this.currentGroup == null;
            if (currentGroupChanged) {
                this.currentGroup = group;
            }
            this.notifyListeners(ViewerStateChange.NUM_GROUPS_CHANGED);
            if (currentGroupChanged) {
                this.notifyListeners(ViewerStateChange.CURRENT_GROUP_CHANGED);
            }
        }
        return modified;
    }

    @Override
    public boolean addGroups(Collection<? extends SourceGroup> collection) {
        this.checkAllNonNull(collection);
        boolean modified = false;
        boolean currentGroupChanged = false;
        for (SourceGroup sourceGroup : collection) {
            if (this.groupIndices.containsKey((Object)sourceGroup)) continue;
            modified = true;
            int nextIndex = this.groups.size();
            this.groups.add(sourceGroup);
            this.groupData.put(sourceGroup, new GroupData());
            this.groupIndices.put((Object)sourceGroup, nextIndex);
            if (this.currentGroup != null) continue;
            currentGroupChanged = true;
            this.currentGroup = sourceGroup;
        }
        if (modified) {
            this.notifyListeners(ViewerStateChange.NUM_GROUPS_CHANGED);
            if (currentGroupChanged) {
                this.notifyListeners(ViewerStateChange.CURRENT_GROUP_CHANGED);
            }
        }
        return modified;
    }

    @Override
    public boolean removeGroup(SourceGroup group) {
        boolean modified;
        if (group == null) {
            throw new NullPointerException();
        }
        int removedIndex = this.groupIndices.remove((Object)group);
        boolean bl = modified = removedIndex != -1;
        if (modified) {
            this.groups.remove(group);
            for (int i = removedIndex; i < this.groups.size(); ++i) {
                this.groupIndices.put((Object)this.groups.get(i), i);
            }
            this.groupData.remove(group);
            this.activeGroups.remove(group);
            boolean currentGroupChanged = group.equals(this.currentGroup);
            if (currentGroupChanged) {
                this.currentGroup = this.groups.isEmpty() ? null : this.groups.get(0);
            }
            this.notifyListeners(ViewerStateChange.NUM_GROUPS_CHANGED);
            if (currentGroupChanged) {
                this.notifyListeners(ViewerStateChange.CURRENT_GROUP_CHANGED);
            }
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean removeGroups(Collection<? extends SourceGroup> collection) {
        this.checkAllNonNull(collection);
        boolean modified = this.groups.removeAll(collection);
        boolean currentGroupChanged = collection.contains(this.currentGroup);
        if (modified) {
            this.groupIndices.clear();
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groupIndices.put((Object)this.groups.get(i), i);
            }
            this.groupData.keySet().removeAll(collection);
            this.activeGroups.removeAll(collection);
            if (currentGroupChanged) {
                this.currentGroup = this.groups.isEmpty() ? null : this.groups.get(0);
            }
            this.notifyListeners(ViewerStateChange.NUM_GROUPS_CHANGED);
            if (currentGroupChanged) {
                this.notifyListeners(ViewerStateChange.CURRENT_GROUP_CHANGED);
            }
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean addSourceToGroup(SourceAndConverter<?> source, SourceGroup group) {
        this.checkSourcePresent(source);
        this.checkGroupPresent(group);
        boolean modified = this.groupData.get((Object)group).sources.add(source);
        if (modified) {
            this.notifyListeners(ViewerStateChange.SOURCE_TO_GROUP_ASSIGNMENT_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean addSourcesToGroup(Collection<? extends SourceAndConverter<?>> collection, SourceGroup group) {
        this.checkSourcesPresent(collection);
        this.checkGroupPresent(group);
        boolean modified = this.groupData.get((Object)group).sources.addAll(collection);
        if (modified) {
            this.notifyListeners(ViewerStateChange.SOURCE_TO_GROUP_ASSIGNMENT_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean removeSourceFromGroup(SourceAndConverter<?> source, SourceGroup group) {
        this.checkSourcePresent(source);
        this.checkGroupPresent(group);
        boolean modified = this.groupData.get((Object)group).sources.remove(source);
        if (modified) {
            this.notifyListeners(ViewerStateChange.SOURCE_TO_GROUP_ASSIGNMENT_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public boolean removeSourcesFromGroup(Collection<? extends SourceAndConverter<?>> collection, SourceGroup group) {
        this.checkSourcesPresent(collection);
        this.checkGroupPresent(group);
        boolean modified = this.groupData.get((Object)group).sources.removeAll(collection);
        if (modified) {
            this.notifyListeners(ViewerStateChange.SOURCE_TO_GROUP_ASSIGNMENT_CHANGED);
            this.checkVisibilityChanged();
        }
        return modified;
    }

    @Override
    public Set<SourceAndConverter<?>> getSourcesInGroup(SourceGroup group) {
        this.checkGroupPresent(group);
        return this.groupData.get((Object)group).unmodifiableSources;
    }

    @Override
    public void clearGroups() {
        if (this.groups.isEmpty()) {
            return;
        }
        this.groups.clear();
        this.groupIndices.clear();
        this.activeGroups.clear();
        boolean currentGroupChanged = this.currentGroup != null;
        this.currentGroup = null;
        this.notifyListeners(ViewerStateChange.NUM_GROUPS_CHANGED);
        if (currentGroupChanged) {
            this.notifyListeners(ViewerStateChange.CURRENT_GROUP_CHANGED);
        }
        this.notifyListeners(ViewerStateChange.SOURCE_TO_GROUP_ASSIGNMENT_CHANGED);
        this.checkVisibilityChanged();
    }

    @Override
    public Comparator<SourceGroup> groupOrder() {
        return Comparator.comparingInt(arg_0 -> this.groupIndices.get(arg_0));
    }

    private void checkSourcePresent(SourceAndConverter<?> source) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (!this.sources.contains(source)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkSourcePresentAllowNull(SourceAndConverter<?> source) {
        if (source != null && !this.sources.contains(source)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkSourcesPresent(Collection<? extends SourceAndConverter<?>> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        for (SourceAndConverter<?> source : collection) {
            this.checkSourcePresent(source);
        }
    }

    private void checkGroupPresent(SourceGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        if (!this.groups.contains(group)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkGroupPresentAllowNull(SourceGroup group) {
        if (group != null && !this.groups.contains(group)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkGroupsPresent(Collection<? extends SourceGroup> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        for (SourceGroup sourceGroup : collection) {
            this.checkGroupPresent(sourceGroup);
        }
    }

    private void checkAllNonNull(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        for (Object e : collection) {
            if (e != null) continue;
            throw new NullPointerException();
        }
    }

    private void notifyListeners(ViewerStateChange change) {
        this.listeners.list.forEach(l -> l.viewerStateChanged(change));
    }

    private void checkVisibilityChanged() {
        Set<SourceAndConverter<?>> visible = this.getVisibleSources();
        if (!visible.equals(this.previousVisibleSources)) {
            this.previousVisibleSources.clear();
            this.previousVisibleSources.addAll(visible);
            this.notifyListeners(ViewerStateChange.VISIBILITY_CHANGED);
        }
    }

    private class UnmodifiableGroups
    extends WrappedList<SourceGroup> {
        public UnmodifiableGroups() {
            super(Collections.unmodifiableList(BasicViewerState.this.groups));
        }

        @Override
        public boolean contains(Object o) {
            return BasicViewerState.this.groupIndices.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return BasicViewerState.this.groupIndices.keySet().containsAll(c);
        }

        @Override
        public int indexOf(Object o) {
            return BasicViewerState.this.groupIndices.get(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return BasicViewerState.this.groupIndices.get(o);
        }
    }

    private class UnmodifiableSources
    extends WrappedList<SourceAndConverter<?>> {
        public UnmodifiableSources() {
            super(Collections.unmodifiableList(BasicViewerState.this.sources));
        }

        @Override
        public boolean contains(Object o) {
            return BasicViewerState.this.sourceIndices.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return BasicViewerState.this.sourceIndices.keySet().containsAll(c);
        }

        @Override
        public int indexOf(Object o) {
            return BasicViewerState.this.sourceIndices.get(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return BasicViewerState.this.sourceIndices.get(o);
        }
    }

    private class GroupData {
        String name = null;
        final Set<SourceAndConverter<?>> sources = new HashSet();
        final Set<SourceAndConverter<?>> unmodifiableSources = Collections.unmodifiableSet(this.sources);

        GroupData() {
        }
    }
}

