/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.export.ProposeMipmaps;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.MipmapInfo;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bdv.util.Affine3DHelpers;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.sequence.TimePoint;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Util;

public class PrintSequenceMipmapInfo {
    public static void printSequenceMipmapInfo(String xmlFilename) throws SpimDataException {
        System.out.println("mipmap setup for " + xmlFilename);
        SpimDataMinimal spimData = (SpimDataMinimal)new XmlIoSpimDataMinimal().load(xmlFilename);
        SequenceDescriptionMinimal seq = (SequenceDescriptionMinimal)spimData.getSequenceDescription();
        if (seq.getImgLoader() instanceof Hdf5ImageLoader) {
            Hdf5ImageLoader imgLoader = (Hdf5ImageLoader)seq.getImgLoader();
            imgLoader.printMipmapInfo();
            int timepointId = ((TimePoint)seq.getTimePoints().getTimePointsOrdered().get(0)).getId();
            for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
                int setupId = setup.getId();
                System.out.println("setup " + setupId);
                int numLevels = ((Hdf5ImageLoader.SetupImgLoader)imgLoader.getSetupImgLoader(setupId)).numMipmapLevels();
                ViewRegistration reg = spimData.getViewRegistrations().getViewRegistration(timepointId, setupId);
                AffineTransform3D model = reg.getModel();
                double[] scale = new double[3];
                for (int d = 0; d < 3; ++d) {
                    scale[d] = Affine3DHelpers.extractScale(model, d);
                }
                System.out.println("    normalized voxel scale:");
                for (int level = 0; level < numLevels; ++level) {
                    MipmapInfo mipmapInfo = ((Hdf5ImageLoader.SetupImgLoader)imgLoader.getSetupImgLoader(setupId)).getMipmapInfo();
                    double[] res = mipmapInfo.getResolutions()[level];
                    double[] voxelScale = new double[3];
                    for (int d = 0; d < 3; ++d) {
                        voxelScale[d] = scale[d] * res[d];
                    }
                    ProposeMipmaps.normalizeVoxelSize(voxelScale);
                    System.out.println("    " + level + ": " + Util.printCoordinates((double[])voxelScale));
                }
            }
        } else {
            System.err.println("not a hdf5 dataset");
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                for (String fn : args) {
                    PrintSequenceMipmapInfo.printSequenceMipmapInfo(fn);
                }
            } else {
                PrintSequenceMipmapInfo.printSequenceMipmapInfo("/Users/pietzsch/Desktop/data/BDV130418A325-re-tiled-16/rewrite.xml");
            }
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
    }
}

