/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class Affine3DHelpers {
    public static void extractRotation(AffineTransform3D transform, double[] q) {
        double[][] m = new double[3][4];
        transform.toMatrix(m);
        double x = m[0][0];
        double y = m[0][1];
        double z = m[0][2];
        double s = 1.0 / Math.sqrt(x * x + y * y + z * z);
        for (int r = 0; r < 3; ++r) {
            int c = 0;
            while (c < 3) {
                double[] dArray = m[r];
                int n = c++;
                dArray[n] = dArray[n] * s;
            }
        }
        LinAlgHelpers.quaternionFromR((double[][])m, (double[])q);
    }

    public static void extractRotationAnisotropic(AffineTransform3D transform, double[] q) {
        double[][] m = new double[3][4];
        transform.toMatrix(m);
        for (int c = 0; c < 3; ++c) {
            double sqSum = 0.0;
            for (int r = 0; r < 3; ++r) {
                sqSum += m[r][c] * m[r][c];
            }
            double s = 1.0 / Math.sqrt(sqSum);
            for (int r = 0; r < 3; ++r) {
                double[] dArray = m[r];
                int n = c;
                dArray[n] = dArray[n] * s;
            }
        }
        LinAlgHelpers.quaternionFromR((double[][])m, (double[])q);
    }

    public static void extractApproximateRotationAffine(AffineTransform3D transform, double[] q, int coerceAffineDimension) {
        double[][] m = new double[3][4];
        transform.toMatrix(m);
        for (int c = 0; c < 3; ++c) {
            double sqSum = 0.0;
            for (int r = 0; r < 3; ++r) {
                sqSum += m[r][c] * m[r][c];
            }
            double s = 1.0 / Math.sqrt(sqSum);
            for (int r = 0; r < 3; ++r) {
                double[] dArray = m[r];
                int n = c;
                dArray[n] = dArray[n] * s;
            }
        }
        double[] x = new double[3];
        double[] y = new double[3];
        double[] z = new double[3];
        LinAlgHelpers.getCol((int)0, (double[][])m, (double[])x);
        LinAlgHelpers.getCol((int)1, (double[][])m, (double[])y);
        LinAlgHelpers.getCol((int)2, (double[][])m, (double[])z);
        switch (coerceAffineDimension) {
            case 0: {
                LinAlgHelpers.cross((double[])y, (double[])z, (double[])x);
                LinAlgHelpers.normalize((double[])x);
                LinAlgHelpers.cross((double[])x, (double[])y, (double[])z);
                break;
            }
            case 1: {
                LinAlgHelpers.cross((double[])z, (double[])x, (double[])y);
                LinAlgHelpers.normalize((double[])y);
                LinAlgHelpers.cross((double[])y, (double[])z, (double[])x);
                break;
            }
            case 2: {
                LinAlgHelpers.cross((double[])x, (double[])y, (double[])z);
                LinAlgHelpers.normalize((double[])z);
                LinAlgHelpers.cross((double[])z, (double[])x, (double[])y);
            }
        }
        LinAlgHelpers.setCol((int)0, (double[])x, (double[][])m);
        LinAlgHelpers.setCol((int)1, (double[])y, (double[][])m);
        LinAlgHelpers.setCol((int)2, (double[])z, (double[][])m);
        LinAlgHelpers.quaternionFromR((double[][])m, (double[])q);
    }

    public static double extractScale(AffineTransform3D transform, int axis) {
        double sqSum = 0.0;
        int c = axis;
        for (int r = 0; r < 3; ++r) {
            double x = transform.get(r, c);
            sqSum += x * x;
        }
        return Math.sqrt(sqSum);
    }

    public static boolean equals(AffineTransform3D t1, AffineTransform3D t2) {
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 4; ++c) {
                if (t1.get(r, c) == t2.get(r, c)) continue;
                return false;
            }
        }
        return true;
    }

    public static final String toString(AffineTransform3D transform) {
        return String.format("(% 7.2f, % 7.2f, % 7.2f, % 7.2f\n % 7.2f, % 7.2f, % 7.2f, % 7.2f\n % 7.2f, % 7.2f, % 7.2f, % 7.2f)", transform.get(0, 0), transform.get(0, 1), transform.get(0, 2), transform.get(0, 3), transform.get(1, 0), transform.get(1, 1), transform.get(1, 2), transform.get(1, 3), transform.get(2, 0), transform.get(2, 1), transform.get(2, 2), transform.get(2, 3));
    }
}

