/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.convertersetupeditor;

import bdv.tools.brightness.ConverterSetup;
import bdv.ui.convertersetupeditor.ColorPanel;
import bdv.ui.sourcegrouptree.SourceGroupTree;
import bdv.ui.sourcetable.SourceTable;
import bdv.viewer.ConverterSetups;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import net.imglib2.type.numeric.ARGBType;

class ColorEditor {
    private final Supplier<List<ConverterSetup>> selectedConverterSetups;
    private final ColorPanel colorPanel;
    private boolean blockUpdates = false;
    private List<ConverterSetup> converterSetups;

    public ColorEditor(SourceTable table, ConverterSetups converterSetups, ColorPanel colorPanel) {
        this(table::getSelectedConverterSetups, converterSetups, colorPanel);
        table.getSelectionModel().addListSelectionListener(e -> this.updateSelection());
    }

    public ColorEditor(SourceGroupTree tree, ConverterSetups converterSetups, ColorPanel colorPanel) {
        this(() -> converterSetups.getConverterSetups(tree.getSelectedSources()), converterSetups, colorPanel);
        tree.getSelectionModel().addTreeSelectionListener(e -> this.updateSelection());
        tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                ColorEditor.this.updateSelection();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                ColorEditor.this.updateSelection();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                ColorEditor.this.updateSelection();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                ColorEditor.this.updateSelection();
            }
        });
    }

    private ColorEditor(Supplier<List<ConverterSetup>> selectedConverterSetups, ConverterSetups converterSetups, ColorPanel colorPanel) {
        this.selectedConverterSetups = selectedConverterSetups;
        this.colorPanel = colorPanel;
        colorPanel.changeListeners().add(this::updateConverterSetupColors);
        converterSetups.listeners().add(s -> this.updateColorPanel());
    }

    private synchronized void updateConverterSetupColors() {
        if (this.blockUpdates || this.converterSetups == null || this.converterSetups.isEmpty()) {
            return;
        }
        ARGBType color = this.colorPanel.getColor();
        for (ConverterSetup converterSetup : this.converterSetups) {
            if (!converterSetup.supportsColor()) continue;
            converterSetup.setColor(color);
        }
        this.updateColorPanel();
    }

    private synchronized void updateSelection() {
        this.converterSetups = this.selectedConverterSetups.get();
        this.updateColorPanel();
    }

    private synchronized void updateColorPanel() {
        if (this.converterSetups == null || this.converterSetups.isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                this.colorPanel.setEnabled(false);
                this.colorPanel.setColor(null);
                this.colorPanel.setConsistent(true);
            });
        } else {
            ARGBType color = null;
            boolean allColorsEqual = true;
            for (ConverterSetup converterSetup : this.converterSetups) {
                if (!converterSetup.supportsColor()) continue;
                if (color == null) {
                    color = converterSetup.getColor();
                    continue;
                }
                allColorsEqual &= color.equals((Object)converterSetup.getColor());
            }
            ARGBType finalColor = color;
            boolean isConsistent = allColorsEqual;
            SwingUtilities.invokeLater(() -> {
                ColorEditor colorEditor = this;
                synchronized (colorEditor) {
                    this.blockUpdates = true;
                    this.colorPanel.setEnabled(finalColor != null);
                    this.colorPanel.setColor(finalColor);
                    this.colorPanel.setConsistent(isConsistent);
                    this.blockUpdates = false;
                }
            });
        }
    }
}

