/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.brightness;

import bdv.util.BoundedValueDouble;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanelDouble
extends JPanel
implements BoundedValueDouble.UpdateListener {
    private static final long serialVersionUID = 6444334522127424416L;
    private static final int sliderLength = 10000;
    private final JSlider slider;
    private final JSpinner spinner;
    private final BoundedValueDouble model;
    private double dmin;
    private double dmax;
    private boolean userDefinedNumberFormat = false;
    private RangeListener rangeListener;

    public SliderPanelDouble(String name, final BoundedValueDouble model, double spinnerStepSize) {
        this.setLayout(new BorderLayout(10, 10));
        this.dmin = model.getRangeMin();
        this.dmax = model.getRangeMax();
        this.slider = new JSlider(0, 0, 10000, this.toSlider(model.getCurrentValue()));
        this.spinner = new JSpinner();
        this.spinner.setModel(new SpinnerNumberModel(model.getCurrentValue(), this.dmin, this.dmax, spinnerStepSize));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = SliderPanelDouble.this.slider.getValue();
                model.setCurrentValue(SliderPanelDouble.this.fromSlider(value));
            }
        });
        this.slider.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SliderPanelDouble.this.updateNumberFormat();
            }
        });
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double value = (Double)SliderPanelDouble.this.spinner.getValue();
                model.setCurrentValue(value);
            }
        });
        if (name != null) {
            JLabel label = new JLabel(name, 0);
            label.setAlignmentX(0.5f);
            this.add((Component)label, "West");
        }
        this.add((Component)this.slider, "Center");
        this.add((Component)this.spinner, "East");
        this.model = model;
        model.setUpdateListener(this);
    }

    public void setDecimalFormat(String pattern) {
        if (pattern == null) {
            this.userDefinedNumberFormat = false;
            this.updateNumberFormat();
        } else {
            this.userDefinedNumberFormat = true;
            ((JSpinner.NumberEditor)this.spinner.getEditor()).getFormat().applyPattern(pattern);
        }
    }

    public void setNumColummns(int cols) {
        ((JSpinner.NumberEditor)this.spinner.getEditor()).getTextField().setColumns(cols);
    }

    @Override
    public void update() {
        boolean rangeChanged;
        double value = this.model.getCurrentValue();
        double min = this.model.getRangeMin();
        double max = this.model.getRangeMax();
        boolean bl = rangeChanged = this.dmax != max || this.dmin != min;
        if (rangeChanged) {
            this.dmin = min;
            this.dmax = max;
            SpinnerNumberModel spinnerModel = (SpinnerNumberModel)this.spinner.getModel();
            spinnerModel.setMinimum(Double.valueOf(min));
            spinnerModel.setMaximum(Double.valueOf(max));
        }
        this.slider.setValue(this.toSlider(value));
        this.spinner.setValue(value);
        if (rangeChanged) {
            this.updateNumberFormat();
        }
        if (rangeChanged && this.rangeListener != null) {
            this.rangeListener.rangeChanged();
        }
    }

    public void setRangeListener(RangeListener listener) {
        this.rangeListener = listener;
    }

    private void updateNumberFormat() {
        if (this.userDefinedNumberFormat) {
            return;
        }
        int sw = this.slider.getWidth();
        if (sw > 0) {
            double range = this.dmax - this.dmin;
            int digits = (int)Math.ceil(Math.log10((double)sw / range));
            JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.spinner.getEditor();
            numberEditor.getFormat().setMaximumFractionDigits(digits);
            numberEditor.stateChanged(new ChangeEvent(this.spinner));
        }
    }

    private int toSlider(double value) {
        return (int)Math.round((value - this.dmin) * 10000.0 / (this.dmax - this.dmin));
    }

    private double fromSlider(int value) {
        return (double)value * (this.dmax - this.dmin) / 10000.0 + this.dmin;
    }

    public static interface RangeListener {
        public void rangeChanged();
    }
}

