/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.TransformedBox;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.listeners.Listeners;

public abstract class AbstractTransformedBoxModel
implements TransformedBox {
    private final AffineTransform3D transform;
    private final Listeners.List<IntervalChangedListener> listeners;

    public AbstractTransformedBoxModel(AffineTransform3D transform) {
        this.transform = transform;
        this.listeners = new Listeners.SynchronizedList();
    }

    @Override
    public void getTransform(AffineTransform3D t) {
        t.set(this.transform);
    }

    public Listeners<IntervalChangedListener> intervalChangedListeners() {
        return this.listeners;
    }

    public abstract void setInterval(RealInterval var1);

    protected void notifyIntervalChanged() {
        this.listeners.list.forEach(IntervalChangedListener::intervalChanged);
    }

    public static interface IntervalChangedListener {
        public void intervalChanged();
    }
}

