/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.bookmarks;

import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.animate.AbstractAnimator;
import bdv.viewer.animate.OverlayAnimator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class BookmarkTextOverlayAnimator
implements OverlayAnimator {
    private final Font font;
    private String text;
    private AbstractAnimator animator;
    private boolean fadeIn;
    private boolean complete = false;
    private final AbstractViewerPanel viewer;

    public BookmarkTextOverlayAnimator(AbstractViewerPanel viewer) {
        this(viewer, new Font("SansSerif", 1, 20));
    }

    public BookmarkTextOverlayAnimator(AbstractViewerPanel viewer, Font font) {
        this.viewer = viewer;
        this.font = font;
    }

    public final void fadeIn(String message, long fadeInDuration) {
        this.text = message;
        this.animator = fadeInDuration > 0L ? new AbstractAnimator(fadeInDuration) : null;
        this.fadeIn = true;
        this.viewer.getDisplayComponent().repaint();
    }

    public final void fadeOut(String message, long fadeOutDuration) {
        this.text = message;
        this.animator = new AbstractAnimator(fadeOutDuration);
        this.fadeIn = false;
        this.viewer.getDisplayComponent().repaint();
    }

    public final void clear() {
        this.text = null;
        this.animator = null;
        this.complete = true;
        this.viewer.getDisplayComponent().repaint();
    }

    @Override
    public void paint(Graphics2D g, long time) {
        float alpha;
        if (this.text == null) {
            return;
        }
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(this.text, this.font, frc);
        Rectangle2D bounds = layout.getBounds();
        float x = (float)(g.getClipBounds().getWidth() - bounds.getWidth() - 10.0);
        float y = (float)(g.getClipBounds().getHeight() - 10.0);
        if (this.animator != null) {
            this.animator.setTime(time);
            double t = this.animator.ratioComplete();
            alpha = this.fadeIn ? (float)Math.sin(1.5707963267948966 * t) : (float)Math.sin(1.5707963267948966 * (1.0 - t));
            if (this.animator.isComplete()) {
                this.animator = null;
                if (!this.fadeIn) {
                    this.complete = true;
                }
            }
        } else {
            alpha = 1.0f;
        }
        g.setColor(new Color(1.0f, 1.0f, 1.0f, alpha));
        layout.draw(g, x, y);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean requiresRepaint() {
        return this.animator != null && this.text != null;
    }
}

