/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools;

import bdv.cache.CacheControl;
import bdv.export.ProgressWriter;
import bdv.util.DelayedPackDialog;
import bdv.util.Prefs;
import bdv.viewer.BasicViewerState;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.ViewerPanel;
import bdv.viewer.overlay.ScaleBarOverlayRenderer;
import bdv.viewer.render.MultiResolutionRenderer;
import bdv.viewer.render.RenderTarget;
import bdv.viewer.render.awt.BufferedImageRenderResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.imglib2.Cursor;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.util.LinAlgHelpers;

public class RecordMaxProjectionDialog
extends DelayedPackDialog
implements OverlayRenderer {
    private static final long serialVersionUID = 1L;
    private final ViewerPanel viewer;
    private final int maxTimepoint;
    private final ProgressWriter progressWriter;
    private final JTextField pathTextField;
    private final JSpinner spinnerMinTimepoint;
    private final JSpinner spinnerMaxTimepoint;
    private final JSpinner spinnerWidth;
    private final JSpinner spinnerHeight;
    private final JSpinner spinnerStepSize;
    private final JSpinner spinnerNumSteps;

    public RecordMaxProjectionDialog(Frame owner, ViewerPanel viewer, ProgressWriter progressWriter) {
        super(owner, "record max projection movie", false);
        this.viewer = viewer;
        this.maxTimepoint = viewer.state().getNumTimepoints() - 1;
        this.progressWriter = progressWriter;
        JPanel boxes = new JPanel();
        this.getContentPane().add((Component)boxes, "North");
        boxes.setLayout(new BoxLayout(boxes, 3));
        JPanel saveAsPanel = new JPanel();
        saveAsPanel.setLayout(new BorderLayout(0, 0));
        boxes.add(saveAsPanel);
        saveAsPanel.add((Component)new JLabel("save to"), "West");
        this.pathTextField = new JTextField("./record/");
        saveAsPanel.add((Component)this.pathTextField, "Center");
        this.pathTextField.setColumns(20);
        JButton browseButton = new JButton("Browse");
        saveAsPanel.add((Component)browseButton, "East");
        JPanel timepointsPanel = new JPanel();
        boxes.add(timepointsPanel);
        timepointsPanel.add(new JLabel("timepoints from"));
        this.spinnerMinTimepoint = new JSpinner();
        this.spinnerMinTimepoint.setModel(new SpinnerNumberModel(0, 0, this.maxTimepoint, 1));
        timepointsPanel.add(this.spinnerMinTimepoint);
        timepointsPanel.add(new JLabel("to"));
        this.spinnerMaxTimepoint = new JSpinner();
        this.spinnerMaxTimepoint.setModel(new SpinnerNumberModel(this.maxTimepoint, 0, this.maxTimepoint, 1));
        timepointsPanel.add(this.spinnerMaxTimepoint);
        JPanel widthPanel = new JPanel();
        boxes.add(widthPanel);
        widthPanel.add(new JLabel("width"));
        this.spinnerWidth = new JSpinner();
        this.spinnerWidth.setModel(new SpinnerNumberModel(800, 10, 5000, 1));
        widthPanel.add(this.spinnerWidth);
        JPanel heightPanel = new JPanel();
        boxes.add(heightPanel);
        heightPanel.add(new JLabel("height"));
        this.spinnerHeight = new JSpinner();
        this.spinnerHeight.setModel(new SpinnerNumberModel(600, 10, 5000, 1));
        heightPanel.add(this.spinnerHeight);
        JPanel stepSizePanel = new JPanel();
        boxes.add(stepSizePanel);
        stepSizePanel.add(new JLabel("slice step size"));
        this.spinnerStepSize = new JSpinner();
        this.spinnerStepSize.setModel(new SpinnerNumberModel(1.0, 0.001, 20.0, 0.1));
        stepSizePanel.add(this.spinnerStepSize);
        JPanel numStepsPanel = new JPanel();
        boxes.add(numStepsPanel);
        numStepsPanel.add(new JLabel("number of slices"));
        this.spinnerNumSteps = new JSpinner();
        this.spinnerNumSteps.setModel(new SpinnerNumberModel(10, 1, 10000, 1));
        numStepsPanel.add(this.spinnerNumSteps);
        JPanel buttonsPanel = new JPanel();
        boxes.add(buttonsPanel);
        buttonsPanel.setLayout(new BorderLayout(0, 0));
        final JButton recordButton = new JButton("Record");
        buttonsPanel.add((Component)recordButton, "East");
        this.spinnerMinTimepoint.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int min = (Integer)RecordMaxProjectionDialog.this.spinnerMinTimepoint.getValue();
                int max = (Integer)RecordMaxProjectionDialog.this.spinnerMaxTimepoint.getValue();
                if (max < min) {
                    RecordMaxProjectionDialog.this.spinnerMaxTimepoint.setValue(min);
                }
            }
        });
        this.spinnerMaxTimepoint.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int max;
                int min = (Integer)RecordMaxProjectionDialog.this.spinnerMinTimepoint.getValue();
                if (min > (max = ((Integer)RecordMaxProjectionDialog.this.spinnerMaxTimepoint.getValue()).intValue())) {
                    RecordMaxProjectionDialog.this.spinnerMinTimepoint.setValue(max);
                }
            }
        });
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileChooser.setSelectedFile(new File(RecordMaxProjectionDialog.this.pathTextField.getText()));
                int returnVal = fileChooser.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = fileChooser.getSelectedFile();
                    RecordMaxProjectionDialog.this.pathTextField.setText(file.getAbsolutePath());
                }
            }
        });
        recordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dirname = RecordMaxProjectionDialog.this.pathTextField.getText();
                final File dir = new File(dirname);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!dir.exists() || !dir.isDirectory()) {
                    System.err.println("Invalid export directory " + dirname);
                    return;
                }
                final int minTimepointIndex = (Integer)RecordMaxProjectionDialog.this.spinnerMinTimepoint.getValue();
                final int maxTimepointIndex = (Integer)RecordMaxProjectionDialog.this.spinnerMaxTimepoint.getValue();
                final int width = (Integer)RecordMaxProjectionDialog.this.spinnerWidth.getValue();
                final int height = (Integer)RecordMaxProjectionDialog.this.spinnerHeight.getValue();
                final double stepSize = (Double)RecordMaxProjectionDialog.this.spinnerStepSize.getValue();
                final int numSteps = (Integer)RecordMaxProjectionDialog.this.spinnerNumSteps.getValue();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            recordButton.setEnabled(false);
                            RecordMaxProjectionDialog.this.recordMovie(width, height, minTimepointIndex, maxTimepointIndex, stepSize, numSteps, dir);
                            recordButton.setEnabled(true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }.start();
            }
        });
        ActionMap am = this.getRootPane().getActionMap();
        InputMap im = this.getRootPane().getInputMap(1);
        Object hideKey = new Object();
        AbstractAction hideAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordMaxProjectionDialog.this.setVisible(false);
            }
        };
        im.put(KeyStroke.getKeyStroke(27, 0), hideKey);
        am.put(hideKey, hideAction);
        this.pack();
    }

    public void recordMovie(final int width, final int height, int minTimepointIndex, int maxTimepointIndex, double stepSize, int numSteps, File dir) throws IOException {
        BasicViewerState renderState = new BasicViewerState(this.viewer.state().snapshot());
        int canvasW = this.viewer.getDisplay().getWidth();
        int canvasH = this.viewer.getDisplay().getHeight();
        AffineTransform3D tGV = new AffineTransform3D();
        renderState.getViewerTransform(tGV);
        tGV.set(tGV.get(0, 3) - (double)(canvasW / 2), 0, 3);
        tGV.set(tGV.get(1, 3) - (double)(canvasH / 2), 1, 3);
        tGV.scale((double)width / (double)canvasW);
        tGV.set(tGV.get(0, 3) + (double)(width / 2), 0, 3);
        tGV.set(tGV.get(1, 3) + (double)(height / 2), 1, 3);
        AffineTransform3D affine = new AffineTransform3D();
        AffineTransform3D tSV = new AffineTransform3D();
        renderState.getSources().get(0).getSpimSource().getSourceTransform(0, 0, tSV);
        tSV.preConcatenate(tGV);
        double[] sO = new double[]{0.0, 0.0, 0.0};
        double[] sX = new double[]{1.0, 0.0, 0.0};
        double[] vO = new double[3];
        double[] vX = new double[3];
        tSV.apply(sO, vO);
        tSV.apply(sX, vX);
        LinAlgHelpers.subtract((double[])vO, (double[])vX, (double[])vO);
        double dd = LinAlgHelpers.length((double[])vO);
        ScaleBarOverlayRenderer scalebar = Prefs.showScaleBarInMovie() ? new ScaleBarOverlayRenderer() : null;
        class MyTarget
        implements RenderTarget<BufferedImageRenderResult> {
            final ARGBScreenImage accumulated;
            final BufferedImageRenderResult renderResult;

            MyTarget() {
                this.accumulated = new ARGBScreenImage(width, height);
                this.renderResult = new BufferedImageRenderResult();
            }

            public void clear() {
                for (ARGBType acc : this.accumulated) {
                    acc.setZero();
                }
            }

            @Override
            public BufferedImageRenderResult getReusableRenderResult() {
                return this.renderResult;
            }

            @Override
            public BufferedImageRenderResult createRenderResult() {
                return new BufferedImageRenderResult();
            }

            @Override
            public void setRenderResult(BufferedImageRenderResult renderResult) {
                BufferedImage bufferedImage = renderResult.getBufferedImage();
                ArrayImg argbs = ArrayImgs.argbs((int[])((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData(), (long[])new long[]{width, height});
                Cursor c = argbs.cursor();
                for (ARGBType acc : this.accumulated) {
                    int current = acc.get();
                    int in = ((ARGBType)c.next()).get();
                    acc.set(ARGBType.rgba((int)Math.max(ARGBType.red((int)in), ARGBType.red((int)current)), (int)Math.max(ARGBType.green((int)in), ARGBType.green((int)current)), (int)Math.max(ARGBType.blue((int)in), ARGBType.blue((int)current)), (int)Math.max(ARGBType.alpha((int)in), ARGBType.alpha((int)current))));
                }
            }

            @Override
            public final int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }
        }
        MyTarget target = new MyTarget();
        MultiResolutionRenderer renderer = new MultiResolutionRenderer(target, () -> {}, new double[]{1.0}, 0L, 1, null, false, this.viewer.getOptionValues().getAccumulateProjectorFactory(), new CacheControl.Dummy());
        this.progressWriter.setProgress(0.0);
        for (int timepoint = minTimepointIndex; timepoint <= maxTimepointIndex; ++timepoint) {
            target.clear();
            renderState.setCurrentTimepoint(timepoint);
            for (int step = 0; step < numSteps; ++step) {
                affine.set(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, -dd * stepSize * (double)step);
                affine.concatenate(tGV);
                renderState.setViewerTransform(affine);
                renderer.requestRepaint();
                renderer.paint(renderState);
            }
            BufferedImage bi = target.accumulated.image();
            if (Prefs.showScaleBarInMovie()) {
                Graphics2D g2 = bi.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setClip(0, 0, width, height);
                scalebar.setViewerState(renderState);
                scalebar.paint(g2);
            }
            ImageIO.write((RenderedImage)bi, "png", new File(String.format("%s/img-%03d.png", dir, timepoint)));
            this.progressWriter.setProgress((double)(timepoint - minTimepointIndex + 1) / (double)(maxTimepointIndex - minTimepointIndex + 1));
        }
    }

    @Override
    public void drawOverlays(Graphics g) {
    }

    @Override
    public void setCanvasSize(int width, int height) {
        this.spinnerWidth.setValue(width);
        this.spinnerHeight.setValue(height);
    }
}

