/*
 * Decompiled with CFR 0.152.
 */
package bdv.spimdata.legacy;

import bdv.img.catmaid.XmlIoCatmaidImageLoader;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.img.openconnectome.XmlIoOpenConnectomeImageLoader;
import bdv.img.remote.XmlIoRemoteImageLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Element;

public class XmlIoSpimDataMinimalLegacy {
    public static SpimDataMinimal fromXml(Element root, File xmlFile) {
        File basePath = XmlIoSpimDataMinimalLegacy.loadBasePath(root, xmlFile);
        TimePoints timepoints = XmlIoSpimDataMinimalLegacy.createTimepointsFromXml(root);
        Map<Integer, ? extends BasicViewSetup> setups = XmlIoSpimDataMinimalLegacy.createViewSetupsFromXml(root);
        MissingViews missingViews = null;
        SequenceDescriptionMinimal sequenceDescription = new SequenceDescriptionMinimal(timepoints, setups, null, missingViews);
        BasicImgLoader imgLoader = XmlIoSpimDataMinimalLegacy.createImgLoaderFromXml(root, basePath, sequenceDescription);
        sequenceDescription.setImgLoader(imgLoader);
        ViewRegistrations viewRegistrations = XmlIoSpimDataMinimalLegacy.createRegistrationsFromXml(root);
        return new SpimDataMinimal(basePath, sequenceDescription, viewRegistrations);
    }

    private static File loadBasePath(Element root, File xmlFile) {
        File xmlFileParentDirectory = xmlFile.getParentFile();
        if (xmlFileParentDirectory == null) {
            xmlFileParentDirectory = new File(".");
        }
        return XmlHelpers.loadPath((Element)root, (String)"BasePath", (String)".", (File)xmlFileParentDirectory);
    }

    private static TimePoints createTimepointsFromXml(Element sequenceDescription) {
        Element timepoints = sequenceDescription.getChild("Timepoints");
        String type = timepoints.getAttributeValue("type");
        if (type.equals("range")) {
            int first = Integer.parseInt(timepoints.getChildText("first"));
            int last = Integer.parseInt(timepoints.getChildText("last"));
            ArrayList<TimePoint> tps = new ArrayList<TimePoint>();
            int i = first;
            int t = 0;
            while (i <= last) {
                tps.add(new TimePoint(t));
                ++i;
                ++t;
            }
            return new TimePoints(tps);
        }
        throw new RuntimeException("unknown <Timepoints> type: " + type);
    }

    private static Map<Integer, ? extends BasicViewSetup> createViewSetupsFromXml(Element sequenceDescription) {
        HashMap<Integer, ViewSetup> setups = new HashMap<Integer, ViewSetup>();
        HashMap<Integer, Angle> angles = new HashMap<Integer, Angle>();
        HashMap<Integer, Channel> channels = new HashMap<Integer, Channel>();
        HashMap<Integer, Illumination> illuminations = new HashMap<Integer, Illumination>();
        for (Element elem : sequenceDescription.getChildren("ViewSetup")) {
            int channelId;
            Channel channel;
            int illuminationId;
            Illumination illumination;
            int id = XmlHelpers.getInt((Element)elem, (String)"id");
            int angleId = XmlHelpers.getInt((Element)elem, (String)"angle");
            Angle angle = (Angle)angles.get(angleId);
            if (angle == null) {
                angle = new Angle(angleId);
                angles.put(angleId, angle);
            }
            if ((illumination = (Illumination)illuminations.get(illuminationId = XmlHelpers.getInt((Element)elem, (String)"illumination"))) == null) {
                illumination = new Illumination(illuminationId);
                illuminations.put(illuminationId, illumination);
            }
            if ((channel = (Channel)channels.get(channelId = XmlHelpers.getInt((Element)elem, (String)"channel"))) == null) {
                channel = new Channel(channelId);
                channels.put(channelId, channel);
            }
            long w = XmlHelpers.getInt((Element)elem, (String)"width");
            long h = XmlHelpers.getInt((Element)elem, (String)"height");
            long d = XmlHelpers.getInt((Element)elem, (String)"depth");
            FinalDimensions size = new FinalDimensions(new long[]{w, h, d});
            double pw = XmlHelpers.getDouble((Element)elem, (String)"pixelWidth");
            double ph = XmlHelpers.getDouble((Element)elem, (String)"pixelHeight");
            double pd = XmlHelpers.getDouble((Element)elem, (String)"pixelDepth");
            FinalVoxelDimensions voxelSize = new FinalVoxelDimensions("px", new double[]{pw, ph, pd});
            ViewSetup setup = new ViewSetup(id, null, (Dimensions)size, (VoxelDimensions)voxelSize, channel, angle, illumination);
            setups.put(id, setup);
        }
        return setups;
    }

    private static BasicImgLoader createImgLoaderFromXml(Element sequenceDescriptionElem, File basePath, SequenceDescriptionMinimal sequenceDescription) {
        Element elem = sequenceDescriptionElem.getChild("ImageLoader");
        String classn = elem.getAttributeValue("class");
        if (classn.equals("viewer.hdf5.Hdf5ImageLoader") || classn.equals("bdv.img.hdf5.Hdf5ImageLoader")) {
            String path = XmlHelpers.loadPath((Element)elem, (String)"hdf5", (File)basePath).toString();
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            for (Element p : elem.getChildren("partition")) {
                partitions.add(XmlIoSpimDataMinimalLegacy.partitionFromXml(p, basePath));
            }
            return new Hdf5ImageLoader(new File(path), partitions, sequenceDescription);
        }
        if (classn.equals("bdv.img.catmaid.CatmaidImageLoader")) {
            return new XmlIoCatmaidImageLoader().fromXml(elem, basePath, sequenceDescription);
        }
        if (classn.equals("bdv.img.openconnectome.OpenConnectomeImageLoader")) {
            return new XmlIoOpenConnectomeImageLoader().fromXml(elem, basePath, sequenceDescription);
        }
        if (classn.equals("bdv.img.remote.RemoteImageLoader")) {
            return new XmlIoRemoteImageLoader().fromXml(elem, basePath, sequenceDescription);
        }
        throw new RuntimeException("unknown ImageLoader class");
    }

    private static Partition partitionFromXml(Element elem, File basePath) {
        String path;
        try {
            path = XmlHelpers.loadPath((Element)elem, (String)"path", (File)basePath).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int timepointOffset = Integer.parseInt(elem.getChildText("timepointOffset"));
        int timepointStart = Integer.parseInt(elem.getChildText("timepointStart"));
        int timepointLength = Integer.parseInt(elem.getChildText("timepointLength"));
        int setupOffset = Integer.parseInt(elem.getChildText("setupOffset"));
        int setupStart = Integer.parseInt(elem.getChildText("setupStart"));
        int setupLength = Integer.parseInt(elem.getChildText("setupLength"));
        HashMap<Integer, Integer> timepointIdSequenceToPartition = new HashMap<Integer, Integer>();
        for (int tPartition = timepointStart; tPartition < timepointStart + timepointLength; ++tPartition) {
            int tSequence = tPartition + timepointOffset;
            timepointIdSequenceToPartition.put(tSequence, tPartition);
        }
        HashMap<Integer, Integer> setupIdSequenceToPartition = new HashMap<Integer, Integer>();
        for (int sPartition = setupStart; sPartition < setupStart + setupLength; ++sPartition) {
            int sSequence = sPartition + setupOffset;
            setupIdSequenceToPartition.put(sSequence, sPartition);
        }
        return new Partition(path, timepointIdSequenceToPartition, setupIdSequenceToPartition);
    }

    protected static ViewRegistrations createRegistrationsFromXml(Element sequenceDescriptionElem) {
        Element elem = sequenceDescriptionElem.getChild("ViewRegistrations");
        ArrayList<ViewRegistration> regs = new ArrayList<ViewRegistration>();
        for (Element vr : elem.getChildren("ViewRegistration")) {
            int timepointId = XmlHelpers.getInt((Element)vr, (String)"timepoint");
            int setupId = XmlHelpers.getInt((Element)vr, (String)"setup");
            AffineTransform3D transform = XmlHelpers.getAffineTransform3D((Element)vr, (String)"affine");
            regs.add(new ViewRegistration(timepointId, setupId, transform));
        }
        return new ViewRegistrations(regs);
    }
}

