/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.n5;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.cache.SharedQueue;
import bdv.img.cache.SimpleCacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.n5.BdvN5Format;
import bdv.img.n5.DataTypeProperties;
import bdv.util.ConstantRandomAccessible;
import bdv.util.MipmapTransforms;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import mpicbg.spim.data.sequence.MultiResolutionSetupImgLoader;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5FSReader;
import org.janelia.saalfeldlab.n5.N5Reader;

public class N5ImageLoader
implements ViewerImgLoader,
MultiResolutionImgLoader {
    private final File n5File;
    private final AbstractSequenceDescription<?, ?, ?> seq;
    private final Map<Integer, SetupImgLoader> setupImgLoaders = new HashMap<Integer, SetupImgLoader>();
    private volatile boolean isOpen = false;
    private SharedQueue createdSharedQueue;
    private VolatileGlobalCellCache cache;
    private N5Reader n5;
    private int requestedNumFetcherThreads = -1;
    private SharedQueue requestedSharedQueue;

    public N5ImageLoader(File n5File, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this.n5File = n5File;
        this.seq = sequenceDescription;
    }

    public File getN5File() {
        return this.n5File;
    }

    @Override
    public synchronized void setNumFetcherThreads(int n) {
        this.requestedNumFetcherThreads = n;
    }

    @Override
    public void setCreatedSharedQueue(SharedQueue createdSharedQueue) {
        this.requestedSharedQueue = createdSharedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() {
        if (!this.isOpen) {
            N5ImageLoader n5ImageLoader = this;
            synchronized (n5ImageLoader) {
                if (this.isOpen) {
                    return;
                }
                try {
                    this.n5 = new N5FSReader(this.n5File.getAbsolutePath());
                    int maxNumLevels = 0;
                    List setups = this.seq.getViewSetupsOrdered();
                    for (BasicViewSetup setup : setups) {
                        int setupId = setup.getId();
                        SetupImgLoader setupImgLoader = this.createSetupImgLoader(setupId);
                        this.setupImgLoaders.put(setupId, setupImgLoader);
                        maxNumLevels = Math.max(maxNumLevels, setupImgLoader.numMipmapLevels());
                    }
                    int numFetcherThreads = this.requestedNumFetcherThreads >= 0 ? this.requestedNumFetcherThreads : Math.max(1, Runtime.getRuntime().availableProcessors());
                    SharedQueue queue = this.requestedSharedQueue != null ? this.requestedSharedQueue : (this.createdSharedQueue = new SharedQueue(numFetcherThreads, maxNumLevels));
                    this.cache = new VolatileGlobalCellCache(queue);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.isOpen = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isOpen) {
            N5ImageLoader n5ImageLoader = this;
            synchronized (n5ImageLoader) {
                if (!this.isOpen) {
                    return;
                }
                if (this.createdSharedQueue != null) {
                    this.createdSharedQueue.shutdown();
                }
                this.cache.clearCache();
                this.createdSharedQueue = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    public SetupImgLoader getSetupImgLoader(int setupId) {
        this.open();
        return this.setupImgLoaders.get(setupId);
    }

    private <T extends NativeType<T>, V extends Volatile<T>> SetupImgLoader<T, V> createSetupImgLoader(int setupId) throws IOException {
        DataType dataType;
        String pathName = BdvN5Format.getPathName(setupId);
        try {
            dataType = (DataType)this.n5.getAttribute(pathName, "dataType", DataType.class);
        }
        catch (N5Exception e) {
            throw new IOException(e);
        }
        return new SetupImgLoader(this, setupId, (DataTypeProperties)Cast.unchecked(DataTypeProperties.of(dataType)));
    }

    @Override
    public CacheControl getCacheControl() {
        this.open();
        return this.cache;
    }

    public static SimpleCacheArrayLoader<?> createCacheArrayLoader(N5Reader n5, String pathName) throws IOException {
        DatasetAttributes attributes;
        try {
            attributes = n5.getDatasetAttributes(pathName);
        }
        catch (N5Exception e) {
            throw new IOException(e);
        }
        return new N5CacheArrayLoader(n5, pathName, attributes, DataTypeProperties.of(attributes.getDataType()));
    }

    private static <T> void ndArrayCopy(T src, int[] srcSize, int[] srcPos, T dest, int[] destSize, int[] destPos, int[] size) {
        int n = srcSize.length;
        int srcStride = 1;
        int destStride = 1;
        int srcOffset = 0;
        int destOffset = 0;
        for (int d = 0; d < n; ++d) {
            srcOffset += srcStride * srcPos[d];
            srcStride *= srcSize[d];
            destOffset += destStride * destPos[d];
            destStride *= destSize[d];
        }
        N5ImageLoader.ndArrayCopy(n - 1, src, srcSize, srcOffset, dest, destSize, destOffset, size);
    }

    private static <T> void ndArrayCopy(int d, T src, int[] srcSize, int srcPos, T dest, int[] destSize, int destPos, int[] size) {
        if (d == 0) {
            System.arraycopy(src, srcPos, dest, destPos, size[d]);
        } else {
            int srcStride = 1;
            int destStride = 1;
            for (int dd = 0; dd < d; ++dd) {
                srcStride *= srcSize[dd];
                destStride *= destSize[dd];
            }
            int w = size[d];
            for (int x = 0; x < w; ++x) {
                N5ImageLoader.ndArrayCopy(d - 1, src, srcSize, srcPos + x * srcStride, dest, destSize, destPos + x * destStride, size);
            }
        }
    }

    private static class N5CacheArrayLoader<T, A extends DataAccess>
    implements SimpleCacheArrayLoader<A> {
        private final N5Reader n5;
        private final String pathName;
        private final DatasetAttributes attributes;
        private final IntFunction<T> createPrimitiveArray;
        private final Function<T, A> createVolatileArrayAccess;

        N5CacheArrayLoader(N5Reader n5, String pathName, DatasetAttributes attributes, DataTypeProperties<?, ?, T, A> dataTypeProperties) {
            this(n5, pathName, attributes, dataTypeProperties.createPrimitiveArray(), dataTypeProperties.createVolatileArrayAccess());
        }

        N5CacheArrayLoader(N5Reader n5, String pathName, DatasetAttributes attributes, IntFunction<T> createPrimitiveArray, Function<T, A> createVolatileArrayAccess) {
            this.n5 = n5;
            this.pathName = pathName;
            this.attributes = attributes;
            this.createPrimitiveArray = createPrimitiveArray;
            this.createVolatileArrayAccess = createVolatileArrayAccess;
        }

        @Override
        public A loadArray(long[] gridPosition, int[] cellDimensions) throws IOException {
            DataBlock dataBlock;
            try {
                dataBlock = (DataBlock)Cast.unchecked((Object)this.n5.readBlock(this.pathName, this.attributes, gridPosition));
            }
            catch (N5Exception e) {
                throw new IOException(e);
            }
            if (dataBlock != null && Arrays.equals(dataBlock.getSize(), cellDimensions)) {
                return (A)((DataAccess)this.createVolatileArrayAccess.apply(dataBlock.getData()));
            }
            T data = this.createPrimitiveArray.apply((int)Intervals.numElements((int[])cellDimensions));
            if (dataBlock != null) {
                Object src = dataBlock.getData();
                int[] srcDims = dataBlock.getSize();
                int[] pos = new int[srcDims.length];
                int[] size = new int[srcDims.length];
                Arrays.setAll(size, d -> Math.min(srcDims[d], cellDimensions[d]));
                N5ImageLoader.ndArrayCopy(src, srcDims, pos, data, cellDimensions, pos, size);
            }
            return (A)((DataAccess)this.createVolatileArrayAccess.apply(data));
        }
    }

    public static class SetupImgLoader<T extends NativeType<T>, V extends Volatile<T>>
    extends AbstractViewerSetupImgLoader<T, V>
    implements MultiResolutionSetupImgLoader<T> {
        private final int setupId;
        private final double[][] mipmapResolutions;
        private final AffineTransform3D[] mipmapTransforms;
        final /* synthetic */ N5ImageLoader this$0;

        public SetupImgLoader(N5ImageLoader this$0, int setupId, DataTypeProperties<T, V, ?, ?> props) throws IOException {
            this(this$0, setupId, (NativeType)props.type(), (Volatile)props.volatileType());
        }

        public SetupImgLoader(int setupId, T type, V volatileType) throws IOException {
            this.this$0 = this$0;
            super(type, volatileType);
            this.setupId = setupId;
            String pathName = BdvN5Format.getPathName(setupId);
            try {
                this.mipmapResolutions = (double[][])((N5ImageLoader)this$0).n5.getAttribute(pathName, "downsamplingFactors", double[][].class);
            }
            catch (N5Exception e) {
                throw new IOException(e);
            }
            this.mipmapTransforms = new AffineTransform3D[this.mipmapResolutions.length];
            for (int level = 0; level < this.mipmapResolutions.length; ++level) {
                this.mipmapTransforms[level] = MipmapTransforms.getMipmapTransformDefault(this.mipmapResolutions[level]);
            }
        }

        @Override
        public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId, level, LoadingStrategy.BUDGETED, (NativeType)this.volatileType);
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId, level, LoadingStrategy.BLOCKING, (NativeType)this.type);
        }

        public Dimensions getImageSize(int timepointId, int level) {
            try {
                String pathName = BdvN5Format.getPathName(this.setupId, timepointId, level);
                DatasetAttributes attributes = this.this$0.n5.getDatasetAttributes(pathName);
                return new FinalDimensions(attributes.getDimensions());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public double[][] getMipmapResolutions() {
            return this.mipmapResolutions;
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return this.mipmapTransforms;
        }

        public int numMipmapLevels() {
            return this.mipmapResolutions.length;
        }

        public VoxelDimensions getVoxelSize(int timepointId) {
            return null;
        }

        private <T extends NativeType<T>> RandomAccessibleInterval<T> prepareCachedImage(int timepointId, int level, LoadingStrategy loadingStrategy, T type) {
            try {
                String pathName = BdvN5Format.getPathName(this.setupId, timepointId, level);
                DatasetAttributes attributes = this.this$0.n5.getDatasetAttributes(pathName);
                long[] dimensions = attributes.getDimensions();
                int[] cellDimensions = attributes.getBlockSize();
                CellGrid grid = new CellGrid(dimensions, cellDimensions);
                int priority = this.numMipmapLevels() - 1 - level;
                CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
                SimpleCacheArrayLoader<?> loader = N5ImageLoader.createCacheArrayLoader(this.this$0.n5, pathName);
                return this.this$0.cache.createImg(grid, timepointId, this.setupId, level, cacheHints, loader, type);
            }
            catch (IOException | N5Exception e) {
                System.err.println(String.format("image data for timepoint %d setup %d level %d could not be found.", timepointId, this.setupId, level));
                return Views.interval(new ConstantRandomAccessible<Type>(type.createVariable(), 3), (Interval)new FinalInterval(new long[]{1L, 1L, 1L}));
            }
        }
    }
}

