/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import java.util.Arrays;
import net.imglib2.realtransform.AffineTransform3D;

public class MipmapInfo {
    private final double[][] resolutions;
    private final AffineTransform3D[] transforms;
    private final int[][] subdivisions;
    private final int maxLevel;

    public MipmapInfo(double[][] resolutions, AffineTransform3D[] transforms, int[][] subdivisions) {
        this.resolutions = resolutions;
        this.transforms = transforms;
        this.subdivisions = subdivisions;
        this.maxLevel = resolutions.length - 1;
    }

    public double[][] getResolutions() {
        return this.resolutions;
    }

    public AffineTransform3D[] getTransforms() {
        return this.transforms;
    }

    public int[][] getSubdivisions() {
        return this.subdivisions;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getNumLevels() {
        return this.maxLevel + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MipmapInfo{");
        sb.append("resolutions=").append(Arrays.deepToString((Object[])this.resolutions));
        sb.append(", subdivisions=").append(Arrays.deepToString((Object[])this.subdivisions));
        sb.append(", transforms=").append(this.transforms == null ? "null" : Arrays.asList(this.transforms).toString());
        sb.append(", maxLevel=").append(this.maxLevel);
        sb.append('}');
        return sb.toString();
    }
}

