/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import bdv.img.hdf5.DimsAndExistence;
import bdv.img.hdf5.Util;
import ch.systemsx.cisd.hdf5.IHDF5FileLevelReadOnlyHandler;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFHelper;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import hdf.hdf5lib.structs.H5O_info_t;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;

class HDF5Access {
    private final IHDF5Reader hdf5Reader;
    private final long fileId;
    private final long numericConversionXferPropertyListID;
    private static final int MAX_OPEN_DATASETS = 48;
    private final OpenDataSetCache openDataSetCache;

    public HDF5Access(IHDF5Reader hdf5Reader) {
        this.hdf5Reader = hdf5Reader;
        long fileAccessPropertyListId = HDF5Constants.H5P_DEFAULT;
        IHDF5FileLevelReadOnlyHandler fileHandler = hdf5Reader.file();
        boolean performNumericConversions = fileHandler.isPerformNumericConversions();
        File file = fileHandler.getFile();
        H5.H5open();
        this.numericConversionXferPropertyListID = performNumericConversions ? HDFHelper.H5Pcreate_xfer_abort_overflow() : HDFHelper.H5Pcreate_xfer_abort();
        this.fileId = H5.H5Fopen((String)file.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (long)fileAccessPropertyListId);
        this.openDataSetCache = new OpenDataSetCache();
    }

    public DimsAndExistence getDimsAndExistence(String pathName) {
        try (OpenDataSet dataset = this.openDataSetCache.getDataSet(pathName);){
            if (dataset == null) {
                DimsAndExistence dimsAndExistence = new DimsAndExistence(new long[]{1L, 1L, 1L}, null, false);
                return dimsAndExistence;
            }
            long fileSpaceId = H5.H5Dget_space((long)dataset.dataSetId);
            int nDims = H5.H5Sget_simple_extent_ndims((long)fileSpaceId);
            long[] dimensions = new long[nDims];
            H5.H5Sget_simple_extent_dims((long)fileSpaceId, (long[])dimensions, null);
            H5.H5Sclose((long)fileSpaceId);
            int[] chunkSizes = null;
            long creationPropertyList = H5.H5Dget_create_plist((long)dataset.dataSetId);
            if (H5.H5Pget_layout((long)creationPropertyList) == HDF5Constants.H5D_CHUNKED) {
                long[] longChunkSizes = new long[nDims];
                H5.H5Pget_chunk((long)creationPropertyList, (int)nDims, (long[])longChunkSizes);
                chunkSizes = net.imglib2.util.Util.long2int((long[])longChunkSizes);
            }
            H5.H5Pclose((long)creationPropertyList);
            DimsAndExistence dimsAndExistence = new DimsAndExistence(Util.reorder(dimensions), Util.reorder(chunkSizes), true);
            return dimsAndExistence;
        }
    }

    public void closeAllDataSets() {
        this.openDataSetCache.clear();
    }

    public void close() {
        this.closeAllDataSets();
        int status = H5.H5Pclose((long)this.numericConversionXferPropertyListID);
        if (status < 0) {
            throw new RuntimeException("Error closing property list");
        }
        status = H5.H5Fclose((long)this.fileId);
        if (status < 0) {
            throw new RuntimeException("Error closing file");
        }
        this.hdf5Reader.close();
    }

    public DataBlock<?> readBlock(String pathName, DataType dataType, long memTypeId, int[] dimensions, long[] min) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long[] reorderedDimensions = Util.reorder(dimensions, new long[dimensions.length]);
        long[] reorderedMin = Util.reorder(min);
        DataBlock block = dataType.createDataBlock(dimensions, min);
        try (OpenDataSet dataset = this.openDataSetCache.getDataSet(pathName);){
            long memorySpaceId = H5.H5Screate_simple((int)reorderedDimensions.length, (long[])reorderedDimensions, null);
            long fileSpaceId = H5.H5Dget_space((long)dataset.dataSetId);
            H5.H5Sselect_hyperslab((long)fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])reorderedMin, null, (long[])reorderedDimensions, null);
            H5.H5Dread((long)dataset.dataSetId, (long)memTypeId, (long)memorySpaceId, (long)fileSpaceId, (long)this.numericConversionXferPropertyListID, (Object)block.getData());
            H5.H5Sclose((long)fileSpaceId);
            H5.H5Sclose((long)memorySpaceId);
        }
        return block;
    }

    private class OpenDataSetCache {
        private final Map<String, OpenDataSet> cache;

        public OpenDataSetCache() {
            this.cache = new LinkedHashMap<String, OpenDataSet>(48, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, OpenDataSet> eldest) {
                    if (this.size() > 48) {
                        OpenDataSet dataSet = eldest.getValue();
                        if (dataSet != null) {
                            dataSet.close();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }

        public synchronized OpenDataSet getDataSet(String pathName) {
            OpenDataSet dataSet = this.cache.get(pathName);
            if (dataSet == null && this.datasetExists(pathName)) {
                dataSet = new OpenDataSet(pathName);
                this.cache.put(pathName, dataSet);
            }
            if (dataSet != null) {
                dataSet.retain();
            }
            return dataSet;
        }

        public synchronized void clear() {
            this.cache.values().forEach(OpenDataSet::close);
            this.cache.clear();
        }

        private boolean datasetExists(String pathName) {
            if ("/".equals(pathName)) {
                return false;
            }
            try {
                H5O_info_t info = H5.H5Oget_info_by_name((long)HDF5Access.this.fileId, (String)pathName, (int)HDF5Constants.H5O_INFO_BASIC, (long)HDF5Constants.H5P_DEFAULT);
                return info.type == HDF5Constants.H5O_TYPE_DATASET;
            }
            catch (HDF5LibraryException e) {
                return false;
            }
        }
    }

    private class OpenDataSet
    implements AutoCloseable {
        final AtomicInteger refcount = new AtomicInteger(1);
        final long dataSetId;

        public OpenDataSet(String pathName) {
            this.dataSetId = H5.H5Dopen((long)HDF5Access.this.fileId, (String)pathName, (long)HDF5Constants.H5P_DEFAULT);
        }

        public void retain() {
            if (this.refcount.getAndIncrement() <= 0) {
                throw new IllegalStateException();
            }
        }

        @Override
        public void close() {
            if (this.refcount.decrementAndGet() == 0) {
                H5.H5Dclose((long)this.dataSetId);
            }
        }
    }
}

