/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.cache;

import bdv.img.cache.EmptyArrayCreator;
import net.imglib2.cache.volatiles.CreateInvalid;
import net.imglib2.img.basictypeaccess.volatiles.VolatileArrayDataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;

public class CreateInvalidVolatileCell<A>
implements CreateInvalid<Long, Cell<A>> {
    private final CellGrid grid;
    private final Fraction entitiesPerPixel;
    private final EmptyArrayCreator<A> creator;

    public CreateInvalidVolatileCell(CellGrid grid, Fraction entitiesPerPixel, EmptyArrayCreator<A> creator) {
        this.grid = grid;
        this.entitiesPerPixel = entitiesPerPixel;
        this.creator = creator;
    }

    public Cell<A> createInvalid(Long key) throws Exception {
        long index = key;
        long[] cellMin = new long[this.grid.numDimensions()];
        int[] cellDims = new int[this.grid.numDimensions()];
        this.grid.getCellDimensions(index, cellMin, cellDims);
        long numEntities = this.entitiesPerPixel.mulCeil(Intervals.numElements((int[])cellDims));
        A data = this.creator.getEmptyArray(numEntities);
        return new Cell(cellDims, cellMin, data);
    }

    public static <T extends NativeType<T>, A extends VolatileArrayDataAccess<A>> CreateInvalidVolatileCell<A> get(CellGrid grid, T type, boolean dirty) throws IllegalArgumentException {
        return CreateInvalidVolatileCell.get(grid, type.getEntitiesPerPixel(), type.getNativeTypeFactory().getPrimitiveType(), dirty);
    }

    public static <A extends VolatileArrayDataAccess<A>> CreateInvalidVolatileCell<A> get(CellGrid grid, Fraction entitiesPerPixel, PrimitiveType primitiveType, boolean dirty) throws IllegalArgumentException {
        if (primitiveType == PrimitiveType.UNDEFINED) {
            throw new IllegalArgumentException("Cannot instantiate " + CreateInvalidVolatileCell.class.getSimpleName() + " for unrecognized primitive type");
        }
        return new CreateInvalidVolatileCell(grid, entitiesPerPixel, EmptyArrayCreator.get(primitiveType, dirty));
    }
}

