/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.ExportScalePyramid;
import bdv.export.Hdf5BlockWriterThread;
import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterConsole;
import bdv.export.SubTaskProgressWriter;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.img.hdf5.Util;
import bdv.img.n5.DataTypeProperties;
import bdv.spimdata.SequenceDescriptionMinimal;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.Cast;
import org.janelia.saalfeldlab.n5.ByteArrayDataBlock;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.DoubleArrayDataBlock;
import org.janelia.saalfeldlab.n5.FloatArrayDataBlock;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.IntArrayDataBlock;
import org.janelia.saalfeldlab.n5.LongArrayDataBlock;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.ShortArrayDataBlock;

public class WriteSequenceToHdf5 {
    public static void writeHdf5File(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo, boolean deflate, File hdf5File, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) {
        HashMap<Integer, Integer> timepointIdSequenceToPartition = new HashMap<Integer, Integer>();
        for (Object timepoint : seq.getTimePoints().getTimePointsOrdered()) {
            timepointIdSequenceToPartition.put(timepoint.getId(), timepoint.getId());
        }
        HashMap<Integer, Integer> setupIdSequenceToPartition = new HashMap<Integer, Integer>();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            setupIdSequenceToPartition.put(setup.getId(), setup.getId());
        }
        Partition partition = new Partition(hdf5File.getPath(), timepointIdSequenceToPartition, setupIdSequenceToPartition);
        WriteSequenceToHdf5.writeHdf5PartitionFile(seq, perSetupMipmapInfo, deflate, partition, loopbackHeuristic, afterEachPlane, numCellCreatorThreads, progressWriter);
    }

    public static void writeHdf5File(AbstractSequenceDescription<?, ?, ?> seq, int[][] resolutions, int[][] subdivisions, boolean deflate, File hdf5File, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) {
        HashMap<Integer, ExportMipmapInfo> perSetupMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(resolutions, subdivisions);
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            perSetupMipmapInfo.put(setup.getId(), mipmapInfo);
        }
        WriteSequenceToHdf5.writeHdf5File(seq, perSetupMipmapInfo, deflate, hdf5File, loopbackHeuristic, afterEachPlane, numCellCreatorThreads, progressWriter);
    }

    public static void writeHdf5PartitionLinkFile(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo) {
        if (!(seq.getImgLoader() instanceof Hdf5ImageLoader)) {
            throw new IllegalArgumentException("sequence has " + seq.getImgLoader().getClass() + " imgloader. Hdf5ImageLoader required.");
        }
        Hdf5ImageLoader loader = (Hdf5ImageLoader)seq.getImgLoader();
        WriteSequenceToHdf5.writeHdf5PartitionLinkFile(seq, perSetupMipmapInfo, loader.getPartitions(), loader.getHdf5File());
    }

    public static void writeHdf5PartitionLinkFile(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo, ArrayList<Partition> partitions, File hdf5File) {
        if (hdf5File.exists()) {
            hdf5File.delete();
        }
        IHDF5Writer hdf5Writer = HDF5Factory.open((File)hdf5File);
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            int setupId = setup.getId();
            ExportMipmapInfo mipmapInfo = perSetupMipmapInfo.get(setupId);
            DataType dataType = DataTypeProperties.n5DataType((NativeType)Cast.unchecked((Object)seq.getImgLoader().getSetupImgLoader(setupId).getImageType()));
            hdf5Writer.writeDoubleMatrix(Util.getResolutionsPath(setupId), mipmapInfo.getResolutions());
            hdf5Writer.writeIntMatrix(Util.getSubdivisionsPath(setupId), mipmapInfo.getSubdivisions());
            hdf5Writer.string().setAttr(Util.getSetupPath(setupId), "dataType", dataType.toString());
        }
        File basePath = hdf5File.getParentFile();
        for (Partition partition : partitions) {
            Map<Integer, Integer> timepointIdSequenceToPartition = partition.getTimepointIdSequenceToPartition();
            Map<Integer, Integer> setupIdSequenceToPartition = partition.getSetupIdSequenceToPartition();
            for (Map.Entry<Integer, Integer> tEntry : timepointIdSequenceToPartition.entrySet()) {
                int tSequence = tEntry.getKey();
                int tPartition = tEntry.getValue();
                for (Map.Entry<Integer, Integer> sEntry : setupIdSequenceToPartition.entrySet()) {
                    int sSequence = sEntry.getKey();
                    int sPartition = sEntry.getValue();
                    ViewId idSequence = new ViewId(tSequence, sSequence);
                    ViewId idPartition = new ViewId(tPartition, sPartition);
                    int numLevels = perSetupMipmapInfo.get(sSequence).getNumLevels();
                    for (int level = 0; level < numLevels; ++level) {
                        String relativePath = XmlHelpers.getRelativePath((File)new File(partition.getPath()), (File)basePath).getPath();
                        hdf5Writer.object().createOrUpdateExternalLink(relativePath, Util.getCellsPath(idPartition, level), Util.getCellsPath(idSequence, level));
                    }
                }
            }
        }
        hdf5Writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHdf5PartitionFile(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo, boolean deflate, Partition partition, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) {
        int blockWriterQueueLength = 100;
        if (progressWriter == null) {
            progressWriter = new ProgressWriterConsole();
        }
        progressWriter.setProgress(0.0);
        ArrayList<Integer> timepointIdsSequence = new ArrayList<Integer>(partition.getTimepointIdSequenceToPartition().keySet());
        Collections.sort(timepointIdsSequence);
        int numTimepoints = timepointIdsSequence.size();
        ArrayList<Integer> setupIdsSequence = new ArrayList<Integer>(partition.getSetupIdSequenceToPartition().keySet());
        Collections.sort(setupIdsSequence);
        BasicImgLoader imgLoader = seq.getImgLoader();
        File hdf5File = new File(partition.getPath());
        if (hdf5File.exists()) {
            hdf5File.delete();
        }
        try (Hdf5BlockWriterThread writerQueue = new Hdf5BlockWriterThread(hdf5File, 100);){
            writerQueue.start();
            ExecutorService executorService = Executors.newFixedThreadPool(numCellCreatorThreads);
            try {
                int numTasks = 0;
                for (int timepointIdSequence : timepointIdsSequence) {
                    for (int setupIdSequence : setupIdsSequence) {
                        if (!((BasicViewDescription)seq.getViewDescriptions().get(new ViewId(timepointIdSequence, setupIdSequence))).isPresent()) continue;
                        ++numTasks;
                    }
                }
                int numCompletedTasks = 0;
                progressWriter.setProgress(0.01);
                progressWriter = new SubTaskProgressWriter(progressWriter, 0.01, 1.0);
                int timepointIndex = 0;
                for (int timepointIdSequence : timepointIdsSequence) {
                    int timepointIdPartition = partition.getTimepointIdSequenceToPartition().get(timepointIdSequence);
                    progressWriter.out().printf("proccessing timepoint %d / %d\n", ++timepointIndex, numTimepoints);
                    ArrayList<Integer> setupsTimePoint = new ArrayList<Integer>();
                    for (int setupIdSequence : setupIdsSequence) {
                        if (!((BasicViewDescription)seq.getViewDescriptions().get(new ViewId(timepointIdSequence, setupIdSequence))).isPresent()) continue;
                        setupsTimePoint.add(setupIdSequence);
                    }
                    int numSetups = setupsTimePoint.size();
                    int setupIndex = 0;
                    Iterator iterator = setupsTimePoint.iterator();
                    while (iterator.hasNext()) {
                        int setupIdSequence = (Integer)iterator.next();
                        int setupIdPartition = partition.getSetupIdSequenceToPartition().get(setupIdSequence);
                        progressWriter.out().printf("proccessing setup %d / %d\n", ++setupIndex, numSetups);
                        double startCompletionRatio = (double)numCompletedTasks++ / (double)numTasks;
                        double endCompletionRatio = (double)numCompletedTasks / (double)numTasks;
                        SubTaskProgressWriter subProgressWriter = new SubTaskProgressWriter(progressWriter, startCompletionRatio, endCompletionRatio);
                        ExportMipmapInfo mipmapInfo = perSetupMipmapInfo.get(setupIdSequence);
                        WriteSequenceToHdf5.writeViewToHdf5PartitionFile(writerQueue, imgLoader, timepointIdPartition, setupIdPartition, mipmapInfo, true, deflate, executorService, numCellCreatorThreads, loopbackHeuristic, afterEachPlane, (ProgressWriter)subProgressWriter);
                    }
                }
            }
            finally {
                executorService.shutdown();
            }
        }
        progressWriter.setProgress(1.0);
    }

    static <T extends RealType<T> & NativeType<T>> void writeViewToHdf5PartitionFile(Hdf5BlockWriterThread writerQueue, BasicImgLoader imgLoader, int timepointId, int setupId, ExportMipmapInfo mipmapInfo, boolean writeMipmapInfo, boolean deflate, ExecutorService executorService, int numThreads, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, ProgressWriter progressWriter) {
        BasicSetupImgLoader setupImgLoader = (BasicSetupImgLoader)Cast.unchecked((Object)imgLoader.getSetupImgLoader(setupId));
        RandomAccessibleInterval img = setupImgLoader.getImage(timepointId, new ImgLoaderHint[0]);
        RealType type = (RealType)setupImgLoader.getImageType();
        System.out.println("typed ... WriteSequenceToHdf5.writeViewToHdf5PartitionFile");
        WriteSequenceToHdf5.writeViewToHdf5PartitionFile(img, type, timepointId, setupId, mipmapInfo, writeMipmapInfo, deflate, writerQueue, executorService, numThreads, loopbackHeuristic, afterEachPlane, progressWriter);
    }

    public static <T extends RealType<T> & NativeType<T>> void writeViewToHdf5PartitionFile(RandomAccessibleInterval<T> img, T type, int timepointIdPartition, int setupIdPartition, ExportMipmapInfo mipmapInfo, boolean writeMipmapInfo, boolean deflate, Hdf5BlockWriterThread writerQueue, ExecutorService executorService, int numThreads, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, ProgressWriter progressWriter) {
        if (writeMipmapInfo) {
            writerQueue.writeMipmapDescription(setupIdPartition, mipmapInfo);
            writerQueue.writeDataType(setupIdPartition, DataTypeProperties.n5DataType(type));
        }
        LoopBackImageLoader loopback = loopbackHeuristic == null ? null : LoopBackImageLoader.create((IHDF5Reader)writerQueue.getIHDF5Writer(), timepointIdPartition, setupIdPartition, img);
        GzipCompression compression = deflate ? new GzipCompression() : new RawCompression();
        HDF5DatasetIO<T> io = new HDF5DatasetIO<T>(writerQueue, (Compression)compression, setupIdPartition, timepointIdPartition, type, loopback);
        try {
            ExportScalePyramid.writeScalePyramid(img, type, mipmapInfo, io, executorService, numThreads, loopbackHeuristic, afterEachPlane, progressWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (loopback != null) {
            loopback.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void writeViewToHdf5PartitionFile(RandomAccessibleInterval<UnsignedShortType> img, Partition partition, int timepointIdPartition, int setupIdPartition, ExportMipmapInfo mipmapInfo, boolean writeMipmapInfo, boolean deflate, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) {
        int blockWriterQueueLength = 100;
        try (Hdf5BlockWriterThread writerQueue = new Hdf5BlockWriterThread(partition.getPath(), 100);){
            writerQueue.start();
            ExecutorService executorService = Executors.newFixedThreadPool(numCellCreatorThreads);
            try {
                WriteSequenceToHdf5.writeViewToHdf5PartitionFile(img, timepointIdPartition, setupIdPartition, mipmapInfo, writeMipmapInfo, deflate, writerQueue, executorService, numCellCreatorThreads, loopbackHeuristic, afterEachPlane, progressWriter);
            }
            finally {
                executorService.shutdown();
            }
        }
    }

    @Deprecated
    public static void writeViewToHdf5PartitionFile(RandomAccessibleInterval<UnsignedShortType> img, int timepointIdPartition, int setupIdPartition, ExportMipmapInfo mipmapInfo, boolean writeMipmapInfo, boolean deflate, Hdf5BlockWriterThread writerQueue, ExecutorService executorService, int numThreads, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, ProgressWriter progressWriter) {
        WriteSequenceToHdf5.writeViewToHdf5PartitionFile(img, new UnsignedShortType(), timepointIdPartition, setupIdPartition, mipmapInfo, writeMipmapInfo, deflate, writerQueue, executorService, numThreads, loopbackHeuristic, afterEachPlane, progressWriter);
    }

    static class HDF5DatasetIO<T extends RealType<T> & NativeType<T>>
    implements ExportScalePyramid.DatasetIO<H5Dataset, T> {
        private final Hdf5BlockWriterThread writerQueue;
        private final Compression compression;
        private final int setupIdPartition;
        private final int timepointIdPartition;
        private final DataType dataType;
        private final T type;
        private final Function<ExportScalePyramid.Block<T>, DataBlock<?>> getDataBlock;
        private final LoopBackImageLoader loopback;

        public HDF5DatasetIO(Hdf5BlockWriterThread writerQueue, Compression compression, int setupIdPartition, int timepointIdPartition, T type, LoopBackImageLoader loopback) {
            this.writerQueue = writerQueue;
            this.compression = compression;
            this.timepointIdPartition = timepointIdPartition;
            this.setupIdPartition = setupIdPartition;
            this.dataType = DataTypeProperties.n5DataType((NativeType)type);
            this.type = type;
            this.loopback = loopback;
            switch (this.dataType) {
                case UINT8: {
                    this.getDataBlock = b -> new ByteArrayDataBlock(b.getSize(), b.getGridPosition(), (byte[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case UINT16: {
                    this.getDataBlock = b -> new ShortArrayDataBlock(b.getSize(), b.getGridPosition(), (short[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case UINT32: {
                    this.getDataBlock = b -> new IntArrayDataBlock(b.getSize(), b.getGridPosition(), (int[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case UINT64: {
                    this.getDataBlock = b -> new LongArrayDataBlock(b.getSize(), b.getGridPosition(), (long[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case INT8: {
                    this.getDataBlock = b -> new ByteArrayDataBlock(b.getSize(), b.getGridPosition(), (byte[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case INT16: {
                    this.getDataBlock = b -> new ShortArrayDataBlock(b.getSize(), b.getGridPosition(), (short[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case INT32: {
                    this.getDataBlock = b -> new IntArrayDataBlock(b.getSize(), b.getGridPosition(), (int[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case INT64: {
                    this.getDataBlock = b -> new LongArrayDataBlock(b.getSize(), b.getGridPosition(), (long[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case FLOAT32: {
                    this.getDataBlock = b -> new FloatArrayDataBlock(b.getSize(), b.getGridPosition(), (float[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                case FLOAT64: {
                    this.getDataBlock = b -> new DoubleArrayDataBlock(b.getSize(), b.getGridPosition(), (double[])Cast.unchecked((Object)b.getData().getStorageArray()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        public H5Dataset createDataset(int level, long[] dimensions, int[] blockSize) {
            String path = Util.getCellsPath(this.timepointIdPartition, this.setupIdPartition, level);
            this.writerQueue.createDataset(path, dimensions, blockSize, this.dataType, this.compression);
            return new H5Dataset(path, new DatasetAttributes(dimensions, blockSize, this.dataType, this.compression));
        }

        @Override
        public void writeBlock(H5Dataset dataset, ExportScalePyramid.Block<T> dataBlock) {
            this.writerQueue.writeBlock(dataset.pathName, dataset.attributes, this.getDataBlock.apply(dataBlock));
        }

        @Override
        public void flush() {
            this.writerQueue.flush();
        }

        @Override
        public RandomAccessibleInterval<T> getImage(int level) {
            return (RandomAccessibleInterval)Cast.unchecked(((Hdf5ImageLoader.SetupImgLoader)this.loopback.getSetupImgLoader(this.setupIdPartition)).getImage(this.timepointIdPartition, level, new ImgLoaderHint[0]));
        }
    }

    static class H5Dataset {
        final String pathName;
        final DatasetAttributes attributes;

        public H5Dataset(String pathName, DatasetAttributes attributes) {
            this.pathName = pathName;
            this.attributes = attributes;
        }
    }

    static class LoopBackImageLoader
    extends Hdf5ImageLoader {
        private LoopBackImageLoader(IHDF5Reader existingHdf5Reader, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
            super(null, existingHdf5Reader, null, sequenceDescription, false);
        }

        static LoopBackImageLoader create(IHDF5Reader existingHdf5Reader, int timepointIdPartition, int setupIdPartition, Dimensions imageDimensions) {
            HashMap<Integer, TimePoint> timepoints = new HashMap<Integer, TimePoint>();
            timepoints.put(timepointIdPartition, new TimePoint(timepointIdPartition));
            HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>();
            setups.put(setupIdPartition, new BasicViewSetup(setupIdPartition, null, imageDimensions, null));
            SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, null, null);
            return new LoopBackImageLoader(existingHdf5Reader, seq);
        }
    }
}

