/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.DownsampleBlock;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;

class DownsampleBlockInstances {
    private static ClassCopyProvider<DownsampleBlock> provider;

    DownsampleBlockInstances() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends RealType<T>> DownsampleBlock<T> create(int[] blockDimensions, int[] downsamplingFactors, Class<?> pixelTypeClass, Class<?> inAccessClass) {
        if (provider == null) {
            Class<DownsampleBlockInstances> clazz = DownsampleBlockInstances.class;
            // MONITORENTER : bdv.export.DownsampleBlockInstances.class
            if (provider == null) {
                provider = new ClassCopyProvider(Imp.class, DownsampleBlock.class, new Class[]{int[].class, int[].class});
            }
            // MONITOREXIT : clazz
        }
        int numDimensions = blockDimensions.length;
        List<Serializable> key = Arrays.asList(numDimensions, pixelTypeClass, inAccessClass);
        return (DownsampleBlock)provider.newInstanceForKey(key, new Object[]{blockDimensions, downsamplingFactors});
    }

    public static class Imp<T extends RealType<T>>
    implements DownsampleBlock<T> {
        private final int n;
        private final int[] downsamplingFactors;
        private final double scale;
        private final double[] accumulator;
        private final RandomAccess<DoubleType> acc;

        public Imp(int[] blockDimensions, int[] downsamplingFactors) {
            this.n = blockDimensions.length;
            if (this.n < 1 || this.n > 3) {
                throw new IllegalArgumentException();
            }
            this.downsamplingFactors = downsamplingFactors;
            this.scale = 1.0 / (double)Intervals.numElements((int[])downsamplingFactors);
            this.accumulator = new double[(int)Intervals.numElements((int[])blockDimensions)];
            long[] dims = new long[this.n];
            Arrays.setAll(dims, d -> blockDimensions[d]);
            this.acc = ArrayImgs.doubles((double[])this.accumulator, (long[])dims).randomAccess();
        }

        @Override
        public void downsampleBlock(RandomAccess<T> in, Cursor<T> out, int[] dimensions) {
            this.clearAccumulator();
            if (this.n == 3) {
                this.downsampleBlock3D(this.acc, dimensions[0], dimensions[1], dimensions[2], in);
                this.writeOutput3D(out, dimensions[0], dimensions[1], dimensions[2], this.acc);
            } else if (this.n == 2) {
                this.downsampleBlock2D(this.acc, dimensions[0], dimensions[1], in);
                this.writeOutput2D(out, dimensions[0], dimensions[1], this.acc);
            } else {
                this.downsampleBlock1D(this.acc, dimensions[0], in);
                this.writeOutput1D(out, dimensions[0], this.acc);
            }
        }

        private void clearAccumulator() {
            Arrays.fill(this.accumulator, 0, this.accumulator.length, 0.0);
        }

        private void downsampleBlock3D(RandomAccess<DoubleType> acc, int asx, int asy, int asz, RandomAccess<T> in) {
            int bsz = this.downsamplingFactors[2];
            int sz = asz * bsz;
            int bz = 0;
            for (int z = 0; z < sz; ++z) {
                this.downsampleBlock2D(acc, asx, asy, in);
                in.fwd(2);
                if (++bz != bsz) continue;
                bz = 0;
                acc.fwd(2);
            }
            in.move(-sz, 2);
            acc.move(-asz, 2);
        }

        private void downsampleBlock2D(RandomAccess<DoubleType> acc, int asx, int asy, RandomAccess<T> in) {
            int bsy = this.downsamplingFactors[1];
            int sy = asy * bsy;
            int by = 0;
            for (int y = 0; y < sy; ++y) {
                this.downsampleBlock1D(acc, asx, in);
                in.fwd(1);
                if (++by != bsy) continue;
                by = 0;
                acc.fwd(1);
            }
            in.move(-sy, 1);
            acc.move(-asy, 1);
        }

        private void downsampleBlock1D(RandomAccess<DoubleType> acc, int asx, RandomAccess<T> in) {
            int bsx = this.downsamplingFactors[0];
            int sx = asx * bsx;
            int bx = 0;
            for (int x = 0; x < sx; ++x) {
                ((DoubleType)acc.get()).set(((DoubleType)acc.get()).get() + ((RealType)in.get()).getRealDouble());
                in.fwd(0);
                if (++bx != bsx) continue;
                bx = 0;
                acc.fwd(0);
            }
            in.move(-sx, 0);
            acc.move(-asx, 0);
        }

        private void writeOutput3D(Cursor<T> out, int asx, int asy, int asz, RandomAccess<DoubleType> acc) {
            for (int z = 0; z < asz; ++z) {
                this.writeOutput2D(out, asx, asy, acc);
                acc.fwd(2);
            }
            acc.move(-asz, 2);
        }

        private void writeOutput2D(Cursor<T> out, int asx, int asy, RandomAccess<DoubleType> acc) {
            for (int y = 0; y < asy; ++y) {
                this.writeOutput1D(out, asx, acc);
                acc.fwd(1);
            }
            acc.move(-asy, 1);
        }

        private void writeOutput1D(Cursor<T> out, int asx, RandomAccess<DoubleType> acc) {
            double scale = this.scale;
            for (int x = 0; x < asx; ++x) {
                ((RealType)out.next()).setReal(((DoubleType)acc.get()).get() * scale);
                acc.fwd(0);
            }
            acc.move(-asx, 0);
        }
    }
}

