/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.struct;

import bdv.util.RealRandomAccessibleIntervalSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.struct.AtlasNode;
import ch.epfl.biop.atlas.struct.AtlasOntology;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.position.FunctionRealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.real.FloatType;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class AtlasHelper {
    public static List<Integer> getAllParentIds(AtlasOntology ontology, int label) {
        AtlasNode origin = ontology.getNodeFromId(label);
        ArrayList<Integer> listOfParentLabels = new ArrayList<Integer>();
        if (origin == null) {
            return listOfParentLabels;
        }
        for (AtlasNode p = origin.parent(); p != null; p = p.parent()) {
            listOfParentLabels.add(p.getId());
        }
        return listOfParentLabels;
    }

    public static Map<Integer, AtlasNode> buildIdToAtlasNodeMap(AtlasNode root) {
        HashMap<Integer, AtlasNode> result = new HashMap<Integer, AtlasNode>();
        return AtlasHelper.appendToIdToAtlasNodeMap(result, root);
    }

    private static Map<Integer, AtlasNode> appendToIdToAtlasNodeMap(Map<Integer, AtlasNode> map, AtlasNode node) {
        map.put(node.getId(), node);
        node.children().forEach(child -> AtlasHelper.appendToIdToAtlasNodeMap(map, child));
        return map;
    }

    public static SourceAndConverter<FloatType> getCoordinateSac(int axis, String name) {
        BiConsumer<RealLocalizable, FloatType> coordIndicator = (l, t) -> t.set(l.getFloatPosition(axis));
        FunctionRealRandomAccessible coordSource = new FunctionRealRandomAccessible(3, coordIndicator, FloatType::new);
        RealRandomAccessibleIntervalSource s = new RealRandomAccessibleIntervalSource((RealRandomAccessible)coordSource, (Interval)FinalInterval.createMinMax((long[])new long[]{0L, 0L, 0L, 1320L, 800L, 1140L}), (Type)new FloatType(), new AffineTransform3D(), name);
        return SourceAndConverterHelper.createSourceAndConverter((Source)s);
    }

    public static SourceAndConverter<FloatType> getCoordinateSacInvOffset(int axis, float offset, String name) {
        BiConsumer<RealLocalizable, FloatType> coordIndicator = (l, t) -> t.set(offset - l.getFloatPosition(axis));
        FunctionRealRandomAccessible coordSource = new FunctionRealRandomAccessible(3, coordIndicator, FloatType::new);
        RealRandomAccessibleIntervalSource s = new RealRandomAccessibleIntervalSource((RealRandomAccessible)coordSource, (Interval)FinalInterval.createMinMax((long[])new long[]{0L, 0L, 0L, 1320L, 800L, 1140L}), (Type)new FloatType(), new AffineTransform3D(), name);
        return SourceAndConverterHelper.createSourceAndConverter((Source)s);
    }

    public static SourceAndConverter<FloatType> getCoordinateSacOffset(int axis, float offset, String name) {
        BiConsumer<RealLocalizable, FloatType> coordIndicator = (l, t) -> t.set(offset + l.getFloatPosition(axis));
        FunctionRealRandomAccessible coordSource = new FunctionRealRandomAccessible(3, coordIndicator, FloatType::new);
        RealRandomAccessibleIntervalSource s = new RealRandomAccessibleIntervalSource((RealRandomAccessible)coordSource, (Interval)FinalInterval.createMinMax((long[])new long[]{0L, 0L, 0L, 1320L, 800L, 1140L}), (Type)new FloatType(), new AffineTransform3D(), name);
        return SourceAndConverterHelper.createSourceAndConverter((Source)s);
    }

    public static boolean saveOntologyToJsonFile(AtlasOntology ontology, String path) {
        try {
            FileWriter fw = new FileWriter(path);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)new SerializableOntology(ontology), (Appendable)fw);
            fw.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static AtlasOntology openOntologyFromJsonFile(String path) {
        File ontologyFile = new File(path);
        if (ontologyFile.exists()) {
            Gson gson = new Gson();
            try {
                FileReader fr = new FileReader(ontologyFile.getAbsoluteFile());
                SerializableOntology ontology = (SerializableOntology)gson.fromJson((Reader)new FileReader(ontologyFile.getAbsoluteFile()), SerializableOntology.class);
                ontology.initialize();
                fr.close();
                return ontology;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static class SerializableAtlasNode
    implements AtlasNode {
        public final int id;
        public final int[] color;
        public final Map<String, String> data;
        public final List<SerializableAtlasNode> children;
        public final transient SerializableAtlasNode parent;

        public SerializableAtlasNode(AtlasNode node, SerializableAtlasNode parent) {
            this.id = node.getId();
            this.data = node.data();
            this.parent = parent;
            this.color = node.getColor();
            this.children = new ArrayList<SerializableAtlasNode>();
            node.children().forEach(n -> this.children.add(new SerializableAtlasNode((AtlasNode)n, this)));
        }

        @Override
        public Integer getId() {
            return this.id;
        }

        @Override
        public int[] getColor() {
            return this.color;
        }

        @Override
        public Map<String, String> data() {
            return this.data;
        }

        @Override
        public AtlasNode parent() {
            return this.parent;
        }

        @Override
        public List<? extends AtlasNode> children() {
            return this.children;
        }
    }

    public static class SerializableOntology
    implements AtlasOntology {
        String name;
        String namingProperty;
        SerializableAtlasNode root;
        transient Map<Integer, AtlasNode> idToAtlasNodeMap;

        public SerializableOntology(AtlasOntology ontology) {
            this.name = ontology.getName();
            this.root = new SerializableAtlasNode(ontology.getRoot(), null);
            this.namingProperty = ontology.getNamingProperty();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void initialize() throws Exception {
            this.idToAtlasNodeMap = AtlasHelper.buildIdToAtlasNodeMap(this.root);
        }

        @Override
        public void setDataSource(URL dataSource) {
        }

        @Override
        public URL getDataSource() {
            return null;
        }

        @Override
        public AtlasNode getRoot() {
            return this.root;
        }

        @Override
        public AtlasNode getNodeFromId(int id) {
            return this.idToAtlasNodeMap.get(id);
        }

        @Override
        public String getNamingProperty() {
            return this.namingProperty;
        }

        @Override
        public void setNamingProperty(String namingProperty) {
            this.namingProperty = namingProperty;
        }
    }
}

