/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.scijava;

import ch.epfl.biop.atlas.struct.Atlas;
import org.scijava.module.Module;
import org.scijava.module.process.AbstractPostprocessorPlugin;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;

@Plugin(type=PostprocessorPlugin.class, priority=-10001.0)
public class AtlasPostProcessor
extends AbstractPostprocessorPlugin {
    @Parameter
    ObjectService os;
    @Parameter
    SourceAndConverterService source_service;

    public void process(Module module) {
        module.getInfo().outputs().forEach(output -> {
            if (output.getGenericType() == Atlas.class && output.isOutput()) {
                String name = output.getName();
                Atlas ba = (Atlas)module.getOutput(name);
                if (ba == null) {
                    System.err.println("No atlas was returned - the open atlas command did not work as expected.");
                } else if (!this.os.getObjects(Atlas.class).contains(ba)) {
                    this.os.addObject((Object)ba);
                    ba.getMap().getStructuralImages().forEach((key, source) -> this.source_service.register(source));
                    this.source_service.register(ba.getMap().getLabelImage());
                }
            }
        });
    }
}

