/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.scijava;

import ch.epfl.biop.atlas.mouse.allen.ccfv3p1.command.AllenBrainAdultMouseAtlasCCF2017v3p1Command;
import ch.epfl.biop.atlas.mouse.allen.ccfv3p1asr.command.AllenBrainAdultMouseAtlasCCF2017v3p1ASRCommand;
import ch.epfl.biop.atlas.rat.waxholm.spraguedawley.v4p2.command.WaxholmSpragueDawleyRatV4p2Command;
import ch.epfl.biop.atlas.rat.waxholm.spraguedawley.v4p2asr.command.WaxholmSpragueDawleyRatV4p2ASRCommand;
import ch.epfl.biop.atlas.struct.Atlas;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.scijava.ItemIO;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.command.DynamicCommand;
import org.scijava.module.Module;
import org.scijava.module.MutableModuleItem;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=DynamicCommand.class, menuPath="Plugins>BIOP>Atlas>Open Atlas", initializer="init")
public class AtlasChooserCommand
extends DynamicCommand {
    @Parameter
    ObjectService os;
    @Parameter
    CommandService cmd;
    @Parameter(label="Choose an atlas", persist=false)
    String choice = "-";
    @Parameter(type=ItemIO.OUTPUT)
    Atlas atlas = null;
    static Map<String, Supplier<Atlas>> extraAtlases = new LinkedHashMap<String, Supplier<Atlas>>();

    public void run() {
        List openedAtlases = this.os.getObjects(Atlas.class);
        for (Atlas a : openedAtlases) {
            if (!a.getName().equals(this.choice)) continue;
            this.atlas = a;
            return;
        }
        try {
            switch (this.choice) {
                case "Rat - Waxholm Sprague Dawley V4p2": {
                    this.atlas = (Atlas)((CommandModule)this.cmd.run(WaxholmSpragueDawleyRatV4p2Command.class, true, new Object[0]).get()).getOutput("ba");
                    break;
                }
                case "Adult Mouse Brain - Allen Brain Atlas V3p1": {
                    this.atlas = (Atlas)((CommandModule)this.cmd.run(AllenBrainAdultMouseAtlasCCF2017v3p1Command.class, true, new Object[0]).get()).getOutput("ba");
                    break;
                }
                case "allen_mouse_10um_java": {
                    this.atlas = (Atlas)((CommandModule)this.cmd.run(AllenBrainAdultMouseAtlasCCF2017v3p1ASRCommand.class, true, new Object[0]).get()).getOutput("ba");
                    break;
                }
                case "whs_sd_rat_39um_java": {
                    this.atlas = (Atlas)((CommandModule)this.cmd.run(WaxholmSpragueDawleyRatV4p2ASRCommand.class, true, new Object[0]).get()).getOutput("ba");
                    break;
                }
                default: {
                    if (extraAtlases.containsKey(this.choice)) {
                        this.atlas = extraAtlases.get(this.choice).get();
                        break;
                    }
                    System.err.println("Unrecognized atlas named " + this.choice);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerAtlas(String name, Supplier<Atlas> supplier) {
        if (extraAtlases.containsKey(name)) {
            System.err.println("Conflict : an atlas named " + name + " already exists. It will be overriden by the new one");
        } else {
            System.out.println("Adding " + name + " atlas");
        }
        extraAtlases.put(name, supplier);
    }

    protected void init() {
        ArrayList<String> choices = new ArrayList<String>();
        for (Map.Entry<String, Supplier<Atlas>> entry : extraAtlases.entrySet()) {
            System.out.println(entry.getKey());
            choices.add(entry.getKey());
        }
        Collections.sort(choices);
        choices.add(0, "Rat - Waxholm Sprague Dawley V4p2");
        choices.add(0, "whs_sd_rat_39um_java");
        choices.add(0, "Adult Mouse Brain - Allen Brain Atlas V3p1");
        choices.add(0, "allen_mouse_10um_java");
        MutableModuleItem input = this.getInfo().getMutableInput("choice", String.class);
        input.setChoices(choices);
        input.setValue((Module)this, choices.get(0));
    }
}

