/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.rat.waxholm.spraguedawley.v4p2asr;

import ch.epfl.biop.atlas.AtlasLocationHelper;
import ch.epfl.biop.atlas.mouse.allen.ccfv3.DownloadProgressBar;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaxholmSpragueDawleyRatV4p2ASRDownloader {
    protected static Logger logger = LoggerFactory.getLogger(WaxholmSpragueDawleyRatV4p2ASRDownloader.class);
    private static String xmlFileName = "WHS_SD_rat_atlas_v4p2asr.xml";
    private static String hdf5FileName = "WHS_SD_rat_atlas_v4p1.h5";
    public static final String wh_sd_rat_v4p2_hdf5 = "https://zenodo.org/record/7492525/files/" + hdf5FileName + "?download=1";
    public static final String wh_sd_rat_v4p2_xml = "https://zenodo.org/records/14055690/files/WHS_SD_rat_atlas_v4p2asr.xml?download=1";

    public static URL getMapUrl() {
        if (!AtlasLocationHelper.getAtlasCacheDir().exists()) {
            AtlasLocationHelper.getAtlasCacheDir().mkdir();
        }
        File fileXml = new File(AtlasLocationHelper.getAtlasCacheDir(), xmlFileName);
        File fileHdf5 = new File(AtlasLocationHelper.getAtlasCacheDir(), hdf5FileName);
        boolean dlH5 = true;
        boolean dlXml = true;
        if (fileHdf5.exists()) {
            if (fileHdf5.length() != 601500109L) {
                logger.warn("hdf5 file wrong size ... downloading again");
            } else {
                logger.info("hdf5 file already downloaded - skipping");
                dlH5 = false;
            }
        }
        if (fileXml.exists()) {
            logger.info("xml file already downloaded - skipping");
            dlXml = false;
        }
        URL returned = null;
        try {
            if (dlXml) {
                DownloadProgressBar.urlToFile(new URL(wh_sd_rat_v4p2_xml), new File(AtlasLocationHelper.getAtlasCacheDir(), xmlFileName), "Downloading " + xmlFileName, -1L);
            }
            if (dlH5) {
                DownloadProgressBar.urlToFile(new URL(wh_sd_rat_v4p2_hdf5), new File(AtlasLocationHelper.getAtlasCacheDir(), hdf5FileName), "Downloading " + hdf5FileName, 601500109L);
            }
            returned = fileXml.toURI().toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returned;
    }
}

