/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.rat.waxholm.spraguedawley.v4;

import ch.epfl.biop.atlas.AtlasLocationHelper;
import ch.epfl.biop.atlas.mouse.allen.ccfv3.DownloadProgressBar;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaxholmSpragueDawleyRatV4Downloader {
    protected static Logger logger = LoggerFactory.getLogger(WaxholmSpragueDawleyRatV4Downloader.class);
    public static final String wh_sd_rat_v4_hdf5 = "https://zenodo.org/record/5644162/files/WHS_SD_rat_atlas_v4.h5?download=1";
    public static final String wh_sd_rat_v4_xml = "https://zenodo.org/record/5644162/files/WHS_SD_rat_atlas_v4.xml?download=1";
    public static final String wh_sd_rat_v4_ontology = "https://zenodo.org/record/5644162/files/WHS_SD_rat_atlas_v4_labels.ilf?download=1";

    public static URL getMapUrl() {
        if (!AtlasLocationHelper.getAtlasCacheDir().exists()) {
            AtlasLocationHelper.getAtlasCacheDir().mkdir();
        }
        File fileXml = new File(AtlasLocationHelper.getAtlasCacheDir(), "WHS_SD_rat_atlas_v4.xml");
        File fileHdf5 = new File(AtlasLocationHelper.getAtlasCacheDir(), "WHS_SD_rat_atlas_v4.h5");
        boolean dlH5 = true;
        boolean dlXml = true;
        if (fileHdf5.exists()) {
            if (fileHdf5.length() != 499413218L) {
                logger.warn("hdf5 file wrong size ... downloading again");
            } else {
                logger.info("hdf5 file already downloaded - skipping");
                dlH5 = false;
            }
        }
        if (fileXml.exists()) {
            logger.info("xml file already downloaded - skipping");
            dlXml = false;
        }
        URL returned = null;
        try {
            if (dlXml) {
                DownloadProgressBar.urlToFile(new URL(wh_sd_rat_v4_xml), new File(AtlasLocationHelper.getAtlasCacheDir(), "WHS_SD_rat_atlas_v4.xml"), "Downloading WHS_SD_rat_atlas_v4.xml", -1L);
            }
            if (dlH5) {
                DownloadProgressBar.urlToFile(new URL(wh_sd_rat_v4_hdf5), new File(AtlasLocationHelper.getAtlasCacheDir(), "WHS_SD_rat_atlas_v4.h5"), "Downloading WHS_SD_rat_atlas_v4.h5", 499413218L);
            }
            returned = fileXml.toURI().toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returned;
    }

    public static URL getOntologyURL() {
        File ontologyFile = new File(AtlasLocationHelper.getAtlasCacheDir(), "WHS_SD_rat_atlas_v4_labels.ilf");
        boolean dlOntology = true;
        if (ontologyFile.exists()) {
            dlOntology = false;
            logger.info("Ontology file already downloaded - skipping");
        }
        URL returned = null;
        try {
            if (dlOntology) {
                DownloadProgressBar.urlToFile(new URL(wh_sd_rat_v4_ontology), new File(AtlasLocationHelper.getAtlasCacheDir(), "WHS_SD_rat_atlas_v4_labels.ilf"), "Downloading ontology", -1L);
            }
            returned = ontologyFile.toURI().toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returned;
    }
}

