/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.rat.waxholm.spraguedawley.v4;

import ch.epfl.biop.atlas.rat.waxholm.spraguedawley.ilfparser.Label;
import ch.epfl.biop.atlas.struct.AtlasNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WHSDRegionsNode
implements AtlasNode {
    final transient Label label;
    final transient WHSDRegionsNode parent;
    final Map<String, String> properties;
    final List<AtlasNode> children;
    final transient Integer id;
    int[] color;
    public static String toStringKey = "abbreviation";

    public WHSDRegionsNode(Label label, WHSDRegionsNode parent) {
        this.label = label;
        this.parent = parent;
        HashMap<String, String> mutableMap = new HashMap<String, String>();
        mutableMap.put("id", label.id);
        mutableMap.put("abbreviation", label.abbreviation);
        mutableMap.put("name", label.name);
        mutableMap.put("color", label.color);
        this.color = WHSDRegionsNode.hex2Rgb(label.color);
        this.properties = Collections.unmodifiableMap(mutableMap);
        if (label.labels != null) {
            this.children = new ArrayList<AtlasNode>(label.labels.length);
            for (Label childLabel : label.labels) {
                this.children.add(new WHSDRegionsNode(childLabel, this));
            }
        } else {
            this.children = new ArrayList<AtlasNode>(0);
        }
        this.id = Integer.parseInt(label.id);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public static int[] hex2Rgb(String colorStr) {
        return new int[]{Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16), 255};
    }

    @Override
    public int[] getColor() {
        return this.color;
    }

    @Override
    public Map<String, String> data() {
        return this.properties;
    }

    @Override
    public WHSDRegionsNode parent() {
        return this.parent;
    }

    public List<AtlasNode> children() {
        return this.children;
    }

    public String toString() {
        return this.data().get(toStringKey);
    }
}

