/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.mouse.allen.ccfv3p1asr.command;

import ch.epfl.biop.atlas.mouse.allen.ccfv3.AllenBrainCCFv3Downloader;
import ch.epfl.biop.atlas.mouse.allen.ccfv3.AllenOntology;
import ch.epfl.biop.atlas.mouse.allen.ccfv3p1.AllenBrainCCFv3p1Downloader;
import ch.epfl.biop.atlas.mouse.allen.ccfv3p1asr.AllenAtlasASR;
import ch.epfl.biop.atlas.mouse.allen.ccfv3p1asr.AllenBrainCCFv3p1ASRDownloader;
import ch.epfl.biop.atlas.struct.Atlas;
import ij.Prefs;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class)
public class AllenBrainAdultMouseAtlasCCF2017v3p1ASRCommand
extends AllenAtlasASR
implements Command {
    public static String keyPrefix = AllenBrainAdultMouseAtlasCCF2017v3p1ASRCommand.class.getName() + ".";
    String mapUrl;
    String ontologyUrl;
    @Parameter(type=ItemIO.OUTPUT)
    Atlas ba;
    public static final String atlasName = "allen_mouse_10um_java";

    public String toString() {
        return this.getName();
    }

    public void run() {
        try {
            URL ontologyURL;
            URL mapURL;
            if (this.mapUrl == null || this.mapUrl.isEmpty() || this.ontologyUrl == null || this.ontologyUrl.isEmpty()) {
                mapURL = AllenBrainCCFv3p1ASRDownloader.getMapUrl();
                ontologyURL = AllenBrainCCFv3Downloader.getOntologyURL();
            } else {
                mapURL = new URL(this.mapUrl.replaceAll(" ", "%20"));
                ontologyURL = new URL(this.ontologyUrl.replaceAll(" ", "%20"));
            }
            try {
                this.initialize(mapURL, ontologyURL);
            }
            catch (Exception e) {
                System.err.println("Could not initialize the atlas : " + e.getMessage());
                System.err.println("Re-downloading it.");
                mapURL = AllenBrainCCFv3p1Downloader.getMapUrl();
                ontologyURL = AllenBrainCCFv3Downloader.getOntologyURL();
                try {
                    this.initialize(mapURL, ontologyURL);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            ((AllenOntology)this.getOntology()).name = this.getName();
            Prefs.set((String)(keyPrefix + "mapUrl"), (String)mapURL.toString());
            Prefs.set((String)(keyPrefix + "ontologyUrl"), (String)ontologyURL.toString());
            this.ba = this;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getDOIs() {
        ArrayList<String> dois = new ArrayList<String>();
        dois.add("10.1016/j.cell.2020.04.007");
        return dois;
    }

    @Override
    public String getURL() {
        return "https://community.brain-map.org/t/allen-mouse-ccf-accessing-and-using-related-data-and-tools/359";
    }

    @Override
    public String getName() {
        return atlasName;
    }
}

