/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.mouse.allen.ccfv3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadProgressBar {
    protected static Logger logger = LoggerFactory.getLogger(DownloadProgressBar.class);

    public static void urlToFile(URL url, File file, String frameTitle, long fileSize) throws Exception {
        final JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setMaximum(10000);
        JFrame frame = new JFrame(frameTitle);
        frame.setContentPane(jProgressBar);
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 250);
        frame.setVisible(true);
        RunnableWithException updatethread = () -> {
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            long completeFileSize = httpConnection.getContentLength();
            logger.info("File Size : " + completeFileSize);
            if (completeFileSize == -1L) {
                completeFileSize = fileSize;
            }
            BufferedInputStream in = new BufferedInputStream(httpConnection.getInputStream());
            FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
            BufferedOutputStream bout = new BufferedOutputStream(fos, 0x100000);
            byte[] data = new byte[0x100000];
            long downloadedFileSize = 0L;
            int x = 0;
            while ((x = in.read(data, 0, 0x100000)) >= 0) {
                final int currentProgress = (int)((double)(downloadedFileSize += (long)x) / (double)completeFileSize * 10000.0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jProgressBar.setValue(currentProgress);
                    }
                });
                bout.write(data, 0, x);
            }
            bout.close();
            in.close();
        };
        Thread t = new Thread(() -> {
            try {
                updatethread.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
        t.join();
        frame.setVisible(false);
        frame.dispose();
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

