/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.mouse.allen.ccfv3;

import ch.epfl.biop.atlas.mouse.allen.ccfv3.AllenBrainRegionsNode;
import ch.epfl.biop.atlas.mouse.allen.ccfv3.AllenOntologyJson;
import ch.epfl.biop.atlas.struct.AtlasHelper;
import ch.epfl.biop.atlas.struct.AtlasNode;
import ch.epfl.biop.atlas.struct.AtlasOntology;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class AllenOntology
implements AtlasOntology {
    URL dataSource;
    transient AllenOntologyJson ontology;
    transient AtlasNode root;
    transient Map<Integer, AtlasNode> idToAtlasNodeMap;
    public String name;
    String namingProperty = "acronym";

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initialize() throws Exception {
        try (BufferedReader fileReader = new BufferedReader(new FileReader(new File(this.getDataSource().toURI())));){
            Gson gson = new Gson();
            this.ontology = (AllenOntologyJson)gson.fromJson((Reader)fileReader, AllenOntologyJson.class);
        }
        this.root = new AllenBrainRegionsNode(this.ontology.msg.get(0), null);
        this.idToAtlasNodeMap = AtlasHelper.buildIdToAtlasNodeMap(this.root);
        HashMap moduloAdd = new HashMap();
        this.idToAtlasNodeMap.forEach((id, v) -> moduloAdd.put(id % 65000, v));
        this.idToAtlasNodeMap.putAll(moduloAdd);
    }

    @Override
    public void setDataSource(URL dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public URL getDataSource() {
        return this.dataSource;
    }

    @Override
    public AtlasNode getRoot() {
        return this.root;
    }

    @Override
    public AtlasNode getNodeFromId(int id) {
        return this.idToAtlasNodeMap.get(id);
    }

    @Override
    public String getNamingProperty() {
        return this.namingProperty;
    }

    @Override
    public void setNamingProperty(String namingProperty) {
        this.namingProperty = namingProperty;
    }
}

