/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.mouse.allen.ccfv3;

import bdv.util.RealRandomAccessibleIntervalSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.struct.AtlasHelper;
import ch.epfl.biop.atlas.struct.AtlasMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.position.FunctionRealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.spimdata.importer.SpimDataFromXmlImporter;

public class AllenMap
implements AtlasMap {
    URL dataSource;
    public String name;
    private static final int NisslSetupId = 0;
    private static final int LabelBorberSetupId = 1;
    private static final int AraSetupId = 2;
    private static final int LabelSetupId = 3;
    final Map<String, SourceAndConverter<?>> atlasSources = new HashMap();
    SourceAndConverter<?> labelSource;

    @Override
    public void initialize(String atlasName) {
        this.name = atlasName;
        String address = this.getDataSource().toString();
        if (address.startsWith("file:")) {
            address = address.substring(5).replaceAll("%20", " ");
        }
        if (System.getProperty("os.name").startsWith("Windows") && address.startsWith("/")) {
            address = address.substring(1);
        }
        SpimDataFromXmlImporter importer = new SpimDataFromXmlImporter(address);
        List sacs = SourceAndConverterServices.getSourceAndConverterService().getSourceAndConverterFromSpimdata(importer.get());
        this.atlasSources.put("Ara", (SourceAndConverter<?>)sacs.get(2));
        this.atlasSources.put("Nissl", (SourceAndConverter<?>)sacs.get(0));
        this.atlasSources.put("Label Borders", (SourceAndConverter<?>)sacs.get(1));
        this.labelSource = (SourceAndConverter)sacs.get(3);
        BiConsumer<RealLocalizable, UnsignedShortType> leftRightIndicator = (l, t) -> {
            if ((double)l.getFloatPosition(2) < 5.7) {
                t.set(255);
            } else {
                t.set(0);
            }
        };
        FunctionRealRandomAccessible leftRightSource = new FunctionRealRandomAccessible(3, leftRightIndicator, UnsignedShortType::new);
        RealRandomAccessibleIntervalSource s = new RealRandomAccessibleIntervalSource((RealRandomAccessible)leftRightSource, (Interval)FinalInterval.createMinMax((long[])new long[]{0L, 0L, 0L, 1000L, 1000L, 0L}), (Type)new UnsignedShortType(), new AffineTransform3D(), "Left_Right");
        SourceAndConverter leftRight = SourceAndConverterHelper.createSourceAndConverter((Source)s);
        this.atlasSources.put("Left Right", leftRight);
        SourceAndConverterServices.getSourceAndConverterService().register(leftRight);
        SourceAndConverter<FloatType> xSource = AtlasHelper.getCoordinateSac(0, "X");
        SourceAndConverter<FloatType> ySource = AtlasHelper.getCoordinateSac(1, "Y");
        SourceAndConverter<FloatType> zSource = AtlasHelper.getCoordinateSac(2, "Z");
        this.atlasSources.put("X", xSource);
        this.atlasSources.put("Y", ySource);
        this.atlasSources.put("Z", zSource);
    }

    @Override
    public void setDataSource(URL dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public URL getDataSource() {
        return this.dataSource;
    }

    @Override
    public Map<String, SourceAndConverter<?>> getStructuralImages() {
        return this.atlasSources;
    }

    @Override
    public List<String> getImagesKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("Nissl");
        keys.add("Ara");
        keys.add("Label Borders");
        keys.add("X");
        keys.add("Y");
        keys.add("Z");
        keys.add("Left Right");
        return keys;
    }

    @Override
    public SourceAndConverter<?> getLabelImage() {
        return this.labelSource;
    }

    @Override
    public Double getAtlasPrecisionInMillimeter() {
        return 0.01;
    }

    @Override
    public AffineTransform3D getCoronalTransform() {
        AffineTransform3D coronalTransform = new AffineTransform3D();
        coronalTransform.rotate(1, 1.5707963267948966);
        return coronalTransform;
    }

    @Override
    public Double getImageMax(String key) {
        switch (key) {
            case "Nissl": {
                return 56000.0;
            }
            case "Ara": {
                return 1024.0;
            }
            case "Label Borders": {
                return 1024.0;
            }
        }
        return 65535.0;
    }

    @Override
    public int labelRight() {
        return 0;
    }

    @Override
    public int labelLeft() {
        return 255;
    }

    public String toString() {
        return this.name;
    }
}

