/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.mouse.allen.ccfv3;

import ch.epfl.biop.atlas.mouse.allen.ccfv3.AllenOntologyJson;
import ch.epfl.biop.atlas.struct.AtlasNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllenBrainRegionsNode
implements AtlasNode {
    final transient AllenOntologyJson.AllenBrainRegion abr;
    final transient AllenBrainRegionsNode parent;
    final Map<String, String> properties;
    final List<AtlasNode> children;
    final int[] color;
    public static String toStringKey = "acronym";

    public AllenBrainRegionsNode(AllenOntologyJson.AllenBrainRegion abr, AllenBrainRegionsNode parent) {
        this.abr = abr;
        this.parent = parent;
        HashMap<String, String> mutableMap = new HashMap<String, String>();
        mutableMap.put("id", Integer.toString(abr.id));
        mutableMap.put("atlas_id", Integer.toString(abr.atlas_id));
        mutableMap.put("ontology_id", Integer.toString(abr.ontology_id));
        mutableMap.put("acronym", abr.acronym);
        mutableMap.put("name", abr.name);
        mutableMap.put("color_hex_triplet", abr.color_hex_triplet);
        mutableMap.put("graph_order", Integer.toString(abr.graph_order));
        mutableMap.put("st_level", Integer.toString(abr.st_level));
        mutableMap.put("hemisphere_id", Integer.toString(abr.hemisphere_id));
        mutableMap.put("parent_structure_id", Integer.toString(abr.parent_structure_id));
        this.properties = Collections.unmodifiableMap(mutableMap);
        this.children = new ArrayList<AtlasNode>(abr.children.size());
        this.color = AllenBrainRegionsNode.hex2Rgba(abr.color_hex_triplet);
        abr.children.forEach(child_abr -> this.children.add(new AllenBrainRegionsNode((AllenOntologyJson.AllenBrainRegion)child_abr, this)));
    }

    @Override
    public Integer getId() {
        return this.abr.id;
    }

    public static int[] hex2Rgba(String colorStr) {
        return new int[]{Integer.valueOf(colorStr.substring(0, 2), 16), Integer.valueOf(colorStr.substring(2, 4), 16), Integer.valueOf(colorStr.substring(4, 6), 16), 255};
    }

    @Override
    public int[] getColor() {
        return this.color;
    }

    @Override
    public Map<String, String> data() {
        return this.properties;
    }

    @Override
    public AllenBrainRegionsNode parent() {
        return this.parent;
    }

    public List<AtlasNode> children() {
        return this.children;
    }

    public String toString() {
        return this.data().get(toStringKey);
    }
}

