/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.custom;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.struct.Atlas;
import ch.epfl.biop.atlas.struct.AtlasHelper;
import ch.epfl.biop.atlas.struct.AtlasMap;
import ch.epfl.biop.atlas.struct.AtlasNode;
import ch.epfl.biop.atlas.struct.AtlasOntology;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusToSpimData;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class AtlasFromSourcesHelper {
    public static AtlasMap fromSources(SourceAndConverter<?>[] sources, SourceAndConverter<?> label, double atlasPixelSizeMm) {
        return new AtlasMapFromSources(sources, label, atlasPixelSizeMm);
    }

    public static Atlas makeAtlas(final AtlasMap map, final AtlasOntology ontology, final String name) {
        return new Atlas(){

            @Override
            public AtlasMap getMap() {
                return map;
            }

            @Override
            public AtlasOntology getOntology() {
                return ontology;
            }

            @Override
            public void initialize(URL mapURL, URL ontologyURL) throws Exception {
            }

            @Override
            public List<String> getDOIs() {
                ArrayList<String> dois = new ArrayList<String>();
                dois.add("no doi");
                return dois;
            }

            @Override
            public String getURL() {
                return null;
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public static AtlasOntology dummyOntology() {
        return new AtlasOntology(){

            @Override
            public String getName() {
                return "No Ontology";
            }

            @Override
            public void initialize() throws Exception {
            }

            @Override
            public void setDataSource(URL dataSource) {
            }

            @Override
            public URL getDataSource() {
                return null;
            }

            @Override
            public AtlasNode getRoot() {
                return new AtlasNode(){

                    @Override
                    public Integer getId() {
                        return 0;
                    }

                    @Override
                    public int[] getColor() {
                        return new int[]{255, 0, 0, 128};
                    }

                    @Override
                    public Map<String, String> data() {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("name", "root");
                        return data;
                    }

                    @Override
                    public AtlasNode parent() {
                        return null;
                    }

                    @Override
                    public List<? extends AtlasNode> children() {
                        return new ArrayList();
                    }

                    public String toString() {
                        return "root";
                    }
                };
            }

            @Override
            public AtlasNode getNodeFromId(int id) {
                if (id == 0) {
                    return this.getRoot();
                }
                return null;
            }

            @Override
            public String getNamingProperty() {
                return "name";
            }

            @Override
            public void setNamingProperty(String namingProperty) {
            }
        };
    }

    public static AtlasOntology ontologyFromLabelImage(final String atlasName, final ImagePlus labelImage) {
        return new AtlasOntology(){
            Map<Integer, AtlasNode> idToNode = new HashMap<Integer, AtlasNode>();

            @Override
            public String getName() {
                return "Ontology-" + atlasName;
            }

            @Override
            public void initialize() throws Exception {
                HashSet<Integer> values = AtlasFromSourcesHelper.getUniquePixelValues(labelImage);
                values.forEach(id -> this.idToNode.put((Integer)id, new AtlasNode((Integer)id){
                    final /* synthetic */ Integer val$id;
                    {
                        this.val$id = n;
                    }

                    @Override
                    public Integer getId() {
                        return this.val$id;
                    }

                    @Override
                    public int[] getColor() {
                        return new int[]{0, 255, 128, 128};
                    }

                    @Override
                    public Map<String, String> data() {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("name", Integer.toString(this.val$id));
                        return data;
                    }

                    @Override
                    public AtlasNode parent() {
                        return this.getRoot();
                    }

                    @Override
                    public List<? extends AtlasNode> children() {
                        return Collections.emptyList();
                    }

                    public String toString() {
                        return Integer.toString(this.val$id);
                    }
                }));
            }

            @Override
            public void setDataSource(URL dataSource) {
            }

            @Override
            public URL getDataSource() {
                return null;
            }

            @Override
            public AtlasNode getRoot() {
                return new AtlasNode(){

                    @Override
                    public Integer getId() {
                        return -1;
                    }

                    @Override
                    public int[] getColor() {
                        return new int[]{255, 0, 0, 128};
                    }

                    @Override
                    public Map<String, String> data() {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("name", "root");
                        return data;
                    }

                    @Override
                    public AtlasNode parent() {
                        return null;
                    }

                    @Override
                    public List<? extends AtlasNode> children() {
                        return new ArrayList<AtlasNode>(idToNode.values());
                    }

                    public String toString() {
                        return "root";
                    }
                };
            }

            @Override
            public AtlasNode getNodeFromId(int id) {
                if (id == -1) {
                    return this.getRoot();
                }
                return this.idToNode.get(id);
            }

            @Override
            public String getNamingProperty() {
                return "name";
            }

            @Override
            public void setNamingProperty(String namingProperty) {
            }
        };
    }

    public static HashSet<Integer> getUniquePixelValues(ImagePlus image) {
        HashSet<Integer> uniqueValues = new HashSet<Integer>();
        int stackSize = image.getStackSize();
        for (int i = 1; i <= stackSize; ++i) {
            ImageProcessor ip = image.getStack().getProcessor(i);
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    int pixelValue = ip.get(x, y);
                    uniqueValues.add(pixelValue);
                }
            }
        }
        return uniqueValues;
    }

    public static Atlas fromImagePlus(String atlasName, ImagePlus image, ImagePlus label, double atlasPrecisionMm) {
        AtlasOntology ontology = label == null ? AtlasFromSourcesHelper.dummyOntology() : AtlasFromSourcesHelper.ontologyFromLabelImage(atlasName, label);
        AbstractSpimData sd = ImagePlusToSpimData.getSpimData((ImagePlus)image);
        SourceAndConverterServices.getSourceAndConverterService().register(sd);
        List structuralImages = SourceAndConverterServices.getSourceAndConverterService().getSourceAndConverterFromSpimdata(sd);
        AbstractSpimData sdLabel = ImagePlusToSpimData.getSpimData((ImagePlus)label);
        SourceAndConverterServices.getSourceAndConverterService().register(sdLabel);
        List labelSource = SourceAndConverterServices.getSourceAndConverterService().getSourceAndConverterFromSpimdata(sdLabel);
        AtlasMap map = AtlasFromSourcesHelper.fromSources(structuralImages.toArray(new SourceAndConverter[0]), (SourceAndConverter)labelSource.get(0), atlasPrecisionMm);
        return AtlasFromSourcesHelper.makeAtlas(map, ontology, atlasName);
    }

    public static class AtlasMapFromSources
    implements AtlasMap {
        final Map<String, SourceAndConverter<?>> keyToImage = new HashMap();
        final List<String> imageKeys = new ArrayList<String>();
        final SourceAndConverter<?> labelImage;
        final double atlasPixelSizeInMillimeter;

        public AtlasMapFromSources(SourceAndConverter<?>[] sources, SourceAndConverter<?> label, double atlasPixelSizeInMillimeter) {
            for (SourceAndConverter<?> source : sources) {
                this.imageKeys.add(source.getSpimSource().getName());
                this.keyToImage.put(source.getSpimSource().getName(), source);
            }
            this.keyToImage.put("X", AtlasHelper.getCoordinateSac(0, "X"));
            this.keyToImage.put("Y", AtlasHelper.getCoordinateSac(1, "Y"));
            this.keyToImage.put("Z", AtlasHelper.getCoordinateSac(2, "Z"));
            this.keyToImage.put("Left Right", label);
            this.imageKeys.add("X");
            this.imageKeys.add("Y");
            this.imageKeys.add("Z");
            this.imageKeys.add("Left Right");
            this.labelImage = label;
            this.atlasPixelSizeInMillimeter = atlasPixelSizeInMillimeter;
        }

        @Override
        public void setDataSource(URL dataSource) {
        }

        @Override
        public void initialize(String atlasName) {
        }

        @Override
        public URL getDataSource() {
            return null;
        }

        @Override
        public Map<String, SourceAndConverter<?>> getStructuralImages() {
            return this.keyToImage;
        }

        @Override
        public List<String> getImagesKeys() {
            return this.imageKeys;
        }

        @Override
        public SourceAndConverter<?> getLabelImage() {
            return this.labelImage;
        }

        @Override
        public Double getAtlasPrecisionInMillimeter() {
            return this.atlasPixelSizeInMillimeter;
        }

        @Override
        public AffineTransform3D getCoronalTransform() {
            return new AffineTransform3D();
        }

        @Override
        public Double getImageMax(String key) {
            return 65535.0;
        }

        @Override
        public int labelRight() {
            return -1;
        }

        @Override
        public int labelLeft() {
            return -1;
        }
    }
}

