/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.brainglobe;

import ch.epfl.biop.atlas.brainglobe.BrainGlobeStructures;
import ch.epfl.biop.atlas.struct.AtlasNode;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BrainGlobeHelper {
    public static AtlasNode buildTreeAndGetRoot(String jsonStructuresFilePath) throws Exception {
        try (BufferedReader r = Files.newBufferedReader(Paths.get(jsonStructuresFilePath, new String[0]));){
            BrainGlobeStructures.Entry[] entries = (BrainGlobeStructures.Entry[])new Gson().fromJson((Reader)r, BrainGlobeStructures.Entry[].class);
            HashMap<Integer, BrainGlobeStructures.Entry> idToEntry = new HashMap<Integer, BrainGlobeStructures.Entry>();
            HashMap<Integer, BrainGlobeNode> idToNode = new HashMap<Integer, BrainGlobeNode>();
            HashSet<Integer> remainingIds = new HashSet<Integer>();
            for (BrainGlobeStructures.Entry e : entries) {
                idToEntry.put(e.id, e);
                remainingIds.add(e.id);
            }
            while (!remainingIds.isEmpty()) {
                Integer currentId = (Integer)remainingIds.stream().findAny().get();
                BrainGlobeNode brainGlobeNode = new BrainGlobeNode(currentId, idToEntry, idToNode, remainingIds);
            }
            BrainGlobeNode root = null;
            for (BrainGlobeNode node : idToNode.values()) {
                if (node.parent != null) continue;
                if (root != null) {
                    System.err.println("Error!! Multiple root ontology found: " + root.id + " and " + node.id);
                    continue;
                }
                root = node;
            }
            if (root == null) {
                System.err.println("Error: root node of atlas ontology not found!");
            }
            Iterator iterator = root;
            return iterator;
        }
    }

    public static class BrainGlobeNode
    implements AtlasNode {
        final Integer id;
        final Map<Integer, BrainGlobeStructures.Entry> idToEntry;
        final int[] color;
        final Map<String, String> data = new HashMap<String, String>(2);
        final AtlasNode parent;
        final List<BrainGlobeNode> children = new ArrayList<BrainGlobeNode>();

        public BrainGlobeNode(Integer currentId, Map<Integer, BrainGlobeStructures.Entry> idToEntry, Map<Integer, BrainGlobeNode> idToNode, Set<Integer> remainingIds) {
            this.id = currentId;
            BrainGlobeStructures.Entry entry = idToEntry.get(this.id);
            this.color = new int[]{entry.rgb_triplet[0], entry.rgb_triplet[1], entry.rgb_triplet[2], 255};
            this.data.put("name", entry.name);
            this.data.put("acronym", entry.acronym);
            this.data.put("id", Integer.toString(entry.id));
            idToNode.put(this.id, this);
            remainingIds.remove(this.id);
            this.idToEntry = idToEntry;
            if (entry.structure_id_path.length <= 1) {
                this.parent = null;
            } else {
                AtlasNode parentNode;
                int parent = entry.structure_id_path[entry.structure_id_path.length - 2];
                if (!idToNode.containsKey(parent)) {
                    new BrainGlobeNode(parent, idToEntry, idToNode, remainingIds);
                }
                this.parent = parentNode = (AtlasNode)idToNode.get(parent);
                List<? extends AtlasNode> childrenList = this.parent.children();
                childrenList.add(this);
            }
        }

        @Override
        public Integer getId() {
            return this.id;
        }

        @Override
        public int[] getColor() {
            return this.color;
        }

        @Override
        public Map<String, String> data() {
            return this.data;
        }

        @Override
        public AtlasNode parent() {
            return this.parent;
        }

        @Override
        public List<? extends AtlasNode> children() {
            return this.children;
        }

        public String toString() {
            return this.data.get("acronym");
        }
    }
}

