/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.scijava.plugins.scripteditor.jython.DotAutocompletions;
import org.scijava.plugins.scripteditor.jython.JythonDev;
import org.scijava.ui.swing.script.autocompletion.CompletionText;

public class VarDotAutocompletions
implements DotAutocompletions {
    String className;

    public VarDotAutocompletions(String className) {
        this.className = className;
    }

    @Override
    public String getClassname() {
        return this.className;
    }

    @Override
    public List<CompletionText> get() {
        ArrayList<CompletionText> ac = new ArrayList<CompletionText>();
        if (null != this.className) {
            try {
                Class<?> c = Class.forName(this.className);
                DotAutocompletions.fieldsAndMethodsInto(c, ac);
            }
            catch (Exception e) {
                JythonDev.print("Could not load class " + this.className, e);
            }
        }
        return ac;
    }

    @Override
    public Stream<CompletionText> getStream() {
        try {
            Class<?> c = Class.forName(this.className);
            return Stream.concat(Arrays.stream(c.getFields()).map(f -> new CompletionText(f.getName(), c, (Field)f)), Arrays.stream(c.getMethods()).map(m -> new CompletionText(m.getName(), c, (Method)m)));
        }
        catch (Exception e) {
            JythonDev.print("Could not load class " + this.className, e);
            return Stream.empty();
        }
    }

    public String toString() {
        return "VarDotAutocompletions: " + this.className;
    }
}

