/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterChoicesProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.python.indexer.types.NModuleType;
import org.scijava.plugins.scripteditor.jython.ConstructorAutocompletions;
import org.scijava.plugins.scripteditor.jython.CustomFunctionCompletion;
import org.scijava.plugins.scripteditor.jython.DotAutocompletions;
import org.scijava.plugins.scripteditor.jython.JythonAutocompletionProvider;
import org.scijava.plugins.scripteditor.jython.JythonDev;
import org.scijava.plugins.scripteditor.jython.JythonScriptParser;
import org.scijava.plugins.scripteditor.jython.Scope;
import org.scijava.ui.swing.script.autocompletion.CompletionText;

public class JythonAutoCompletions {
    private static final Pattern assign = Pattern.compile("^([ \\t]*)(([a-zA-Z_][a-zA-Z0-9_ \\t,]*)[ \\t]+=[ \\t]+(.*))$");
    private static final Pattern nameToken = Pattern.compile("^(.*?[ \\t,\\[=\\(]+)([a-zA-Z_][a-zA-Z0-9_]+)$");
    private static final Pattern invocation = Pattern.compile("^(.*?[ \\t]+|)([a-zA-Z_][a-zA-Z0-9_]+\\()$");
    private static final Pattern dotNameToken = Pattern.compile("^(.*?[ \\t]+|)([a-zA-Z0-9_\\.\\[\\](){}]+)\\.([a-zA-Z0-9_]*)$");
    private static final Pattern endingCode = Pattern.compile("^([ \\t]*)[^#]*?(.*?)[ \\t]*:[ \\t]*(#.*|)[\\n]*$");
    private static final Pattern sysPathAppend = Pattern.compile("sys.path.append[ \\t]*[(][ \\t]*['\"](.*?)['\"][ \\t]*[)]");
    private static final Pattern importPkg = Pattern.compile("^(import|from)[ \\t]+([a-zA-Z_][a-zA-Z0-9._]*)$");
    private static final Pattern importMember = Pattern.compile("^from[ \\t]+([a-z_][a-zA-Z0-9_.]*)[ \\t]+import[ \\t]*([a-zA-Z0-9_]*)$");
    public static final List<String> jython_jar_modules;

    public List<Completion> completionsFor(JythonAutocompletionProvider provider, String codeWithoutLastLine, String lastLine, String alreadyEnteredText) {
        Matcher m2;
        String pkgName;
        int crop = lastLine.length() - alreadyEnteredText.length();
        char lastChar = lastLine.charAt(lastLine.length() - 1);
        if (0 == lastLine.length() || "[]{},; ".indexOf(lastChar) > -1) {
            return Collections.emptyList();
        }
        boolean add_pass = false;
        if (codeWithoutLastLine.endsWith("\n")) {
            JythonDev.printTrace("codeWithoutLastLine ends with line break");
            int priorLineBreak = codeWithoutLastLine.lastIndexOf(10, codeWithoutLastLine.length() - 2);
            String endingLine = codeWithoutLastLine.substring(priorLineBreak + 1);
            Matcher me = endingCode.matcher(endingLine);
            if (me.find()) {
                codeWithoutLastLine = codeWithoutLastLine.substring(0, priorLineBreak + 1) + me.group(1) + me.group(2);
                add_pass = true;
                JythonDev.printTrace("changed code to: \n" + codeWithoutLastLine + "\n###");
            }
        }
        try {
            Matcher mpath = sysPathAppend.matcher(codeWithoutLastLine);
            while (mpath.find()) {
                File path = new File(mpath.group(1));
                if (!path.exists() || !path.isDirectory() || Scope.indexer.getLoadPath().stream().filter(s -> path.equals(new File((String)s))).findFirst().isPresent()) continue;
                Scope.indexer.addPath(path.getAbsolutePath());
            }
            JythonDev.printTrace("PYTHONPATH:\n" + String.join((CharSequence)"\n", Scope.indexer.getLoadPath()));
        }
        catch (Exception e) {
            JythonDev.print("Failed to add path from sys.path.append expression.", e);
        }
        Matcher mi = importPkg.matcher(lastLine);
        if (mi.find()) {
            String first = mi.group(1);
            pkgName = mi.group(2);
            ArrayList<Completion> ac = new ArrayList<Completion>();
            ac.addAll(jython_jar_modules.stream().filter(s -> s.startsWith(pkgName)).map(s -> new BasicCompletion((CompletionProvider)provider, first + " " + s + (first.equals("from") ? " import " : ""), null, "Python standard library module")).collect(Collectors.toList()));
            String pkgNameFile = pkgName.replace('.', '/');
            ac.addAll(Scope.indexer.getLoadPath().stream().map(dir -> {
                try {
                    return Files.walk(new File((String)dir).toPath(), FileVisitOption.FOLLOW_LINKS).map(path -> path.toFile().getAbsolutePath()).filter(s -> s.startsWith(dir + pkgNameFile) && s.endsWith(".py")).map(s -> (s.endsWith("__init__.py") ? s.substring(dir.length(), s.length() - 12) : s.substring(dir.length(), s.length() - 3)).replace('/', '.'));
                }
                catch (IOException e) {
                    JythonDev.print("Failed to read jython module file.", e);
                    return null;
                }
            }).flatMap(Function.identity()).map(s -> new BasicCompletion((CompletionProvider)provider, first + " " + s + (first.equals("from") ? " import " : ""), null, "Custom python module")).collect(Collectors.toList()));
            return ac;
        }
        Matcher mm = importMember.matcher(lastLine);
        if (mm.find()) {
            pkgName = mm.group(1);
            String member = mm.group(2) == null ? "" : mm.group(2);
            NModuleType mod2 = Scope.loadPythonModule(pkgName);
            if (null != mod2 && !mod2.getTable().keySet().isEmpty()) {
                return mod2.getTable().keySet().stream().filter(s -> s.startsWith(member)).map(s -> new BasicCompletion((CompletionProvider)provider, "from " + pkgName + " import " + s, null, null)).collect(Collectors.toList());
            }
            if (null != mod2) {
                ArrayList<Completion> ac = new ArrayList<Completion>();
                for (String dir2 : Scope.indexer.getLoadPath()) {
                    File fdir = new File(dir2 + pkgName.replace('.', '/'));
                    if (!fdir.exists() || !fdir.isDirectory()) continue;
                    for (String filename : fdir.list()) {
                        if (!filename.startsWith(member) || !new File(fdir.getAbsolutePath() + "/" + filename).isDirectory() && !filename.endsWith(".py")) continue;
                        ac.add((Completion)new BasicCompletion((CompletionProvider)provider, "from " + pkgName + " import " + (filename.endsWith(".py") ? filename.substring(0, filename.length() - 3) : filename), null, null));
                    }
                }
                return ac;
            }
            return Collections.emptyList();
        }
        Matcher m1 = nameToken.matcher(lastLine);
        if (m1.find()) {
            Scope scope = JythonScriptParser.parseAST(codeWithoutLastLine).getLast();
            provider.setParameterChoicesProvider(new CustomParameterChoicesProvider(provider, scope));
            Map<String, String> names = scope.findStartsWith2(m1.group(2));
            ArrayList<Completion> completions = new ArrayList<Completion>();
            for (Map.Entry<String, String> e : names.entrySet()) {
                String classname = e.getValue();
                if (null != classname) {
                    try {
                        Class<?> c = Class.forName(classname);
                        for (Constructor<?> constructor : c.getConstructors()) {
                            completions.add(JythonAutoCompletions.makeDotCompletion(crop > -1 && crop < m1.group(1).length() ? m1.group(1).substring(crop) : "", m1.group(2), new CompletionText(e.getKey(), c, constructor), (CompletionProvider)provider));
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        JythonDev.printTrace("Can't load class: " + classname);
                    }
                }
                completions.add((Completion)new BasicCompletion((CompletionProvider)provider, (lastLine + e.getKey().substring(m1.group(2).length())).substring(crop)));
            }
            return completions;
        }
        JythonDev.printTrace("invocation.matcher:");
        Matcher m1c = invocation.matcher(lastLine);
        if (m1c.find()) {
            String name = m1c.group(2).substring(0, m1c.group(2).length() - 1);
            JythonDev.printTrace("    name: " + name);
            Scope scope = JythonScriptParser.parseAST(codeWithoutLastLine).getLast();
            DotAutocompletions da = scope.find(name, DotAutocompletions.EMPTY);
            provider.setParameterChoicesProvider(new CustomParameterChoicesProvider(provider, scope));
            JythonDev.print(da);
            if (da instanceof ConstructorAutocompletions) {
                JythonDev.printTrace("da is a ConstructorAutocompletions");
                return da.get().stream().map(ct -> JythonAutoCompletions.makeDotCompletion("", name, ct, (CompletionProvider)provider)).collect(Collectors.toList());
            }
        }
        if ((m2 = dotNameToken.matcher(lastLine)).find()) {
            String code;
            String varName;
            String seed = m2.group(3);
            Matcher m3 = assign.matcher(lastLine);
            if (m3.find()) {
                String[] assignment = lastLine.split("=");
                String[] names = assignment[0].split(",");
                varName = names[names.length - 1].trim();
                code = codeWithoutLastLine + lastLine.substring(0, lastLine.length() - 1 - seed.length());
            } else {
                int start = 0;
                while (Character.isWhitespace(lastLine.charAt(start++))) {
                }
                --start;
                String suffix = "";
                if (add_pass) {
                    add_pass = false;
                    JythonDev.printTrace("Removed ' pass'");
                    suffix = ":\n  ";
                }
                varName = "____GRAB____";
                code = codeWithoutLastLine + (add_pass ? ": pass" : "") + suffix + lastLine.substring(0, start) + varName + " = " + lastLine.substring(start, lastLine.length() - 1 - seed.length());
                JythonDev.printTrace("codeWithoutLastLine:\n" + codeWithoutLastLine);
            }
            Scope scope = JythonScriptParser.parseAST(code);
            DotAutocompletions da = scope.getLast().find(varName, DotAutocompletions.EMPTY);
            String fullPre = lastLine.substring(crop);
            String pre = fullPre.substring(0, fullPre.lastIndexOf(seed));
            String lowerCaseSeed = seed.toLowerCase();
            provider.setParameterChoicesProvider(new CustomParameterChoicesProvider(provider, scope));
            List<Completion> list = da.get().stream().filter(s -> s.getReplacementText().toLowerCase().contains(lowerCaseSeed)).map(s -> JythonAutoCompletions.makeDotCompletion(pre, lowerCaseSeed, s, (CompletionProvider)provider)).collect(Collectors.toList());
            this.sortCompletions(list, seed);
            return list;
        }
        return Collections.emptyList();
    }

    protected static Completion makeDotCompletion(String pre, String seed, CompletionText ct, CompletionProvider provider) {
        List<Parameter> ps = ct.getMethodArgs();
        if (null != ps && null != ct.getReturnType()) {
            JythonDev.printTrace("using FunctionCompletion: ps is " + ps.stream().map(Parameter::toString).collect(Collectors.joining(", ", "[", "]")));
            String text = ct.getReplacementText();
            if (text.endsWith("()")) {
                text = text.substring(0, text.length() - 2);
            }
            CustomFunctionCompletion fc = new CustomFunctionCompletion(provider, pre + text, ct.getReturnType());
            fc.setReturnValueDescription(ct.getReturnType());
            fc.setShortDescription(ct.getSummary());
            ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
            for (int i = 0; i < ps.size(); ++i) {
                params.add(new ParameterizedCompletion.Parameter((Object)ps.get(i).getType().getCanonicalName(), ps.get(i).getName(), false));
            }
            fc.setParams(params);
            fc.setRelevance(fc.getReplacementText().startsWith(seed) ? 1 : 0);
            return fc;
        }
        JythonDev.printTrace("not FunctionCompletion: replacement text is " + ct.getReplacementText());
        return ct.getCompletion(provider, pre + ct.getReplacementText(), ct.getReplacementText().startsWith(seed) ? 1 : 0);
    }

    private static String removeLastOptionalDot(String s) {
        return s != null && s.endsWith(".") ? s.substring(0, s.length() - 1) : s;
    }

    private void sortCompletions(List<Completion> completions, final String pre) {
        Collections.sort(completions, new Comparator<Completion>(){
            int prefix1Index = Integer.MAX_VALUE;
            int prefix2Index = Integer.MAX_VALUE;

            @Override
            public int compare(Completion o1, Completion o2) {
                this.prefix1Index = Integer.MAX_VALUE;
                this.prefix2Index = Integer.MAX_VALUE;
                if (o1.getReplacementText().startsWith(pre)) {
                    this.prefix1Index = 0;
                }
                if (o2.getReplacementText().startsWith(pre)) {
                    this.prefix2Index = 0;
                }
                if (this.prefix1Index == this.prefix2Index) {
                    return o1.getReplacementText().compareTo(o2.getReplacementText());
                }
                return this.prefix1Index - this.prefix2Index;
            }
        });
    }

    static {
        List ls = Collections.emptyList();
        try {
            ls = Files.walk(new File(System.getProperty("ij.dir") + "/jars/").toPath(), new FileVisitOption[0]).filter(path -> path.toFile().getName().startsWith("jython-slim-")).map(new Function<Path, List<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<String> apply(Path filepath) {
                    JarFile jar = null;
                    try {
                        List<String> modules;
                        jar = new JarFile(filepath.toString());
                        List<String> list = modules = jar.stream().map(ZipEntry::getName).filter(s -> s.startsWith("Lib/") && s.endsWith(".py")).map(s -> (s.endsWith("/__init__.py") ? s.substring(4, s.length() - 12) : s.substring(4, s.length() - 3)).replace('/', '.')).collect(Collectors.toList());
                        return list;
                    }
                    catch (Exception e) {
                        JythonDev.print("Failed to load jython module", e);
                    }
                    finally {
                        if (null != jar) {
                            try {
                                jar.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    return Collections.emptyList();
                }
            }).findFirst().orElse(Collections.emptyList());
        }
        catch (IOException e) {
            JythonDev.print("Cannot find jython-slim-*.jar file", e);
        }
        finally {
            jython_jar_modules = ls;
        }
    }

    private final class CustomParameterChoicesProvider
    implements ParameterChoicesProvider {
        private final JythonAutocompletionProvider provider;
        private final Scope scope;

        private CustomParameterChoicesProvider(JythonAutocompletionProvider provider, Scope scope) {
            this.provider = provider;
            this.scope = scope;
        }

        public List<Completion> getParameterChoices(JTextComponent tc, ParameterizedCompletion.Parameter param) {
            Object typeObj = param.getTypeObject();
            Class clazz = null;
            if (null != typeObj && typeObj instanceof Class) {
                clazz = (Class<Integer>)typeObj;
                JythonDev.printTrace("class: " + clazz + ", " + clazz.getCanonicalName());
            }
            switch (param.getType()) {
                case "int": {
                    clazz = Integer.class;
                    break;
                }
                case "long": {
                    clazz = Long.class;
                    break;
                }
                case "float": {
                    clazz = Float.class;
                    break;
                }
                case "double": {
                    clazz = Double.class;
                    break;
                }
                case "boolean": {
                    clazz = Boolean.class;
                    break;
                }
                case "char": {
                    clazz = Character.class;
                    break;
                }
                case "short": {
                    clazz = Short.class;
                    break;
                }
                case "byte": {
                    clazz = Byte.class;
                }
            }
            if (null != clazz) {
                try {
                    JythonDev.printTrace("type is: " + param.getType());
                    JythonDev.printTrace("class is: " + clazz.getCanonicalName());
                    List<Completion> bc = this.scope.findVarsByType(param.getType(), clazz).map(varName -> new BasicCompletion((CompletionProvider)this.provider, varName)).collect(Collectors.toList());
                    for (int i = 0; i < bc.size(); ++i) {
                        ((BasicCompletion)bc.get(i)).setRelevance(bc.size() - i);
                    }
                    JythonDev.printTrace("found bc: " + bc.size());
                    return bc;
                }
                catch (Exception e) {
                    JythonDev.printError(e);
                }
            }
            return Collections.emptyList();
        }
    }
}

