/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.scijava.ui.swing.script.EditorPane;
import org.scijava.ui.swing.script.autocompletion.ImportCompletion;

public class JythonAutoCompletion
extends AutoCompletion {
    private static final Pattern importPattern = Pattern.compile("^(from[ \\t]+([a-zA-Z_][a-zA-Z0-9._]*)[ \\t]+|)import[ \\t]+([a-zA-Z_][a-zA-Z0-9_]*[ \\ta-zA-Z0-9_,]*)[ \\t]*([\\\\]*|)[  \\t]*(#.*|)$");
    private static final Pattern tripleQuotePattern = Pattern.compile("\"\"\"");
    private static final Pattern variableDeclarationPattern = Pattern.compile("([a-zA-Z_][a-zA-Z0-9._]*)[ \\t]*=[ \\t]*([A-Z_][a-zA-Z0-9._]*)(?:\\()");

    public JythonAutoCompletion(CompletionProvider provider) {
        super(provider);
        this.setParameterAssistanceEnabled(true);
        this.setShowDescWindow(true);
    }

    public static final String findClassAliasOfVariable(String variable, String inputText) {
        String[] lines = inputText.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            Matcher matcher = variableDeclarationPattern.matcher(line);
            if (!matcher.find() || !variable.equals(matcher.group(1))) continue;
            return matcher.group(2);
        }
        return null;
    }

    public static final HashMap<String, Import> findImportedClasses(String text) {
        HashMap<String, Import> importedClasses = new HashMap<String, Import>();
        String packageName = "";
        boolean endingBackslash = false;
        boolean insideTripleQuotes = false;
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String trimmed = line.trim();
            if (0 == trimmed.length() || '#' == trimmed.charAt(0)) continue;
            Matcher mq = tripleQuotePattern.matcher(line);
            int n_triple_quotes = 0;
            while (mq.find()) {
                ++n_triple_quotes;
            }
            if (insideTripleQuotes) {
                if (0 == n_triple_quotes % 2) continue;
                insideTripleQuotes = false;
                continue;
            }
            if (0 != n_triple_quotes % 2) {
                insideTripleQuotes = true;
                continue;
            }
            if (endingBackslash) {
                String importLine = line;
                int backslash = line.lastIndexOf(92);
                if (backslash > -1) {
                    importLine = importLine.substring(0, backslash);
                } else {
                    int sharp = importLine.lastIndexOf(35);
                    if (sharp > -1) {
                        importLine = importLine.substring(0, sharp);
                    }
                }
                String[] stringArray = importLine.split(",");
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String simpleClassName = stringArray[j];
                    Import im = new Import(packageName, simpleClassName.trim().split("\\s"), i);
                    importedClasses.put(im.alias, im);
                }
                endingBackslash = -1 != backslash;
                continue;
            }
            Matcher m = importPattern.matcher(line);
            if (!m.find()) continue;
            packageName = null == m.group(2) ? "" : m.group(2);
            for (String simpleClassName : m.group(3).split(",")) {
                Import im = new Import(packageName, simpleClassName.trim().split("\\s"), i);
                importedClasses.put(im.alias, im);
            }
            endingBackslash = null != m.group(4) && m.group(4).length() > 0 && '\\' == m.group(4).charAt(0);
        }
        return importedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCompletion(Completion c, boolean typedParamListStartChar) {
        if (c instanceof ImportCompletion) {
            EditorPane editor = (EditorPane)((Object)super.getTextComponent());
            editor.beginAtomicEdit();
            try {
                super.insertCompletion(c, typedParamListStartChar);
                ImportCompletion cc = (ImportCompletion)c;
                HashMap<String, Import> importedClasses = JythonAutoCompletion.findImportedClasses(editor.getText());
                for (Import im2 : importedClasses.values()) {
                    if (!im2.className.contentEquals(cc.getClassName())) continue;
                    return;
                }
                try {
                    int insertAtLine = 0 == importedClasses.size() ? 0 : importedClasses.values().stream().map(im -> im.lineNumber).reduce(Math::max).get();
                    editor.insert(cc.getImportStatement() + "\n", editor.getLineStartOffset(0 == insertAtLine ? 0 : insertAtLine + 1));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            finally {
                editor.endAtomicEdit();
            }
        } else {
            super.insertCompletion(c, typedParamListStartChar);
        }
    }

    public static class Import {
        public final String className;
        public final String alias;
        public final int lineNumber;

        public Import(String className, String alias2, int lineNumber) {
            this.className = className;
            this.alias = null != alias2 ? alias2 : className.substring(className.lastIndexOf(46) + 1);
            this.lineNumber = lineNumber;
        }

        public Import(String packageName, String[] parts, int lineNumber) {
            this(packageName + "." + parts[0], 3 == parts.length ? parts[2] : null, lineNumber);
        }
    }
}

