/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.YesNoCancelDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Export_EPS
implements PlugInFilter {
    static final String extension = ".eps";
    static final int epsLineLength = 38;
    private ImagePlus img;
    private int imgType = 0;
    private String imgTitle = "";
    private Calibration imgCalib;
    private int width;
    private int height;
    private double realWidth;
    private double realHeight;
    private boolean saveAsBitmap = false;
    private final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final char[] hexByte = new char[2];

    public int setup(String arg0, ImagePlus img) {
        this.img = img;
        return 159;
    }

    public void run(ImageProcessor ip) {
        if (this.img.getStackSize() != 1) {
            IJ.error((String)"Can only save 2D images!");
            return;
        }
        this.imgTitle = this.stripFileExtension(this.img.getTitle());
        SaveDialog sd = new SaveDialog("Save image as EPS", this.imgTitle, extension);
        String dir = sd.getDirectory();
        String name = sd.getFileName();
        if (name == null || name.length() == 0) {
            return;
        }
        if (ip.isBinary()) {
            YesNoCancelDialog bd = new YesNoCancelDialog(null, "EPS Export", "Save this image as binary bitmap?");
            if (bd.cancelPressed()) {
                return;
            }
            this.saveAsBitmap = bd.yesPressed();
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.imgType = this.img.getType();
        this.imgCalib = this.img.getCalibration();
        this.realWidth = (double)this.width * this.imgCalib.pixelWidth;
        this.realHeight = (double)this.height * this.imgCalib.pixelHeight;
        ip.resetMinAndMax();
        IJ.showStatus((String)("Writing EPS " + dir + name + "..."));
        try {
            FileWriter output = new FileWriter(dir + name);
            this.writeHeader(output, name);
            this.writeImage(output, ip);
            this.writeTrailer(output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            IJ.error((String)("Error writing EPS file " + dir + name));
        }
        IJ.showStatus((String)"");
    }

    boolean isGrayType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    void writeHeader(Writer out, String fileName) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss", Locale.US);
        String date = dateFormat.format(new Date());
        double x0 = this.imgCalib.xOrigin;
        double y0 = this.imgCalib.yOrigin;
        double x1 = this.imgCalib.xOrigin + this.realWidth;
        double y1 = this.imgCalib.yOrigin + this.realHeight;
        int u0 = (int)Math.floor(x0);
        int v0 = (int)Math.floor(y0);
        int u1 = (int)Math.ceil(x1);
        int v1 = (int)Math.ceil(y1);
        out.write("%!PS-Adobe-2.0 EPSF-1.2\n");
        out.write("%%Title: " + fileName + "\n");
        out.write("%%Creator: " + this.getClass().getSimpleName() + " ImageJ Plugin by W. Burger 2010.12\n");
        out.write("%%CreationDate: " + date + "\n");
        out.write("%%BoundingBox: " + u0 + " " + v0 + " " + u1 + " " + v1 + "\n");
        out.write("%%HiResBoundingBox: " + x0 + " " + y0 + " " + x1 + " " + y1 + "\n");
        out.write("%%EndComments\n");
        out.write("save\n");
        out.write("countdictstack mark newpath\n");
        out.write("/showpage {} def\n");
        out.write("/setpagedevice {pop} def\n");
    }

    void writeImage(Writer out, ImageProcessor ip) throws IOException {
        boolean isGray = this.isGrayType(this.imgType);
        int spp = isGray ? 1 : 3;
        int bps = this.saveAsBitmap ? 1 : 8;
        out.write("/imgstring " + spp + " string def\n" + this.width + " " + this.height + " " + bps + " [ " + 1.0 / this.imgCalib.pixelWidth + " 0 0 " + -1.0 / this.imgCalib.pixelHeight + " " + this.imgCalib.xOrigin + " " + (this.realHeight - this.imgCalib.yOrigin) + " ] { currentfile imgstring readhexstring pop } ");
        switch (spp) {
            case 1: {
                out.write("image");
                break;
            }
            case 3: {
                out.write("false 3 colorimage");
            }
        }
        switch (this.imgType) {
            case 0: {
                if (this.saveAsBitmap) {
                    this.writeBitmap(out, (ByteProcessor)ip);
                    break;
                }
                this.writeGray(out, (ByteProcessor)ip);
                break;
            }
            case 1: {
                this.writeGray(out, (ShortProcessor)ip);
                break;
            }
            case 2: {
                this.writeGray(out, (FloatProcessor)ip);
                break;
            }
            case 4: {
                this.writeColor(out, (ColorProcessor)ip);
                break;
            }
            case 3: {
                this.writeColor(out, (ByteProcessor)ip);
                break;
            }
            default: {
                throw new Error("Unknown image type");
            }
        }
    }

    void writeTrailer(Writer out) throws IOException {
        out.write("\n%%Trailer\n");
        out.write("cleartomark countdictstack exch sub { end } repeat\n");
        out.write("restore\n");
        out.write("%%EOF\n");
    }

    void writeBitmap(Writer out, ByteProcessor bp) throws IOException {
        int w = bp.getWidth();
        int h = bp.getHeight();
        int n = w % 8 == 0 ? w / 8 : w / 8 + 1;
        int[] line = new int[w];
        byte[] packedLine = new byte[n];
        for (int v = 0; v < h; ++v) {
            bp.getRow(0, v, line, w);
            this.packOneLine(line, packedLine);
            for (int i = 0; i < packedLine.length; ++i) {
                if (i % 38 == 0) {
                    out.write("\n");
                }
                int p = packedLine[i] & 0xFF;
                out.write(this.toHex(p));
            }
        }
    }

    void packOneLine(int[] line, byte[] packed) {
        int i = 0;
        for (int j = 0; j < packed.length; ++j) {
            int b = 0;
            for (int bit = 0; bit < 8; ++bit) {
                b <<= 1;
                if (i >= line.length) continue;
                if (line[i] > 0) {
                    b |= 1;
                }
                ++i;
            }
            packed[j] = (byte)(b & 0xFF);
        }
    }

    void writeGray(Writer out, ByteProcessor bp) throws IOException {
        byte[] pixels = (byte[])bp.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            if (i % 38 == 0) {
                out.write("\n");
            }
            int p = pixels[i] & 0xFF;
            out.write(this.toHex(p));
        }
    }

    void writeGray(Writer out, ShortProcessor sp) throws IOException {
        float min = (float)sp.getMin();
        float max = (float)sp.getMax();
        float offset = min;
        float scale = 1.0f;
        if ((double)(max - min) > 0.001) {
            scale = 255.0f * (max - min);
        }
        short[] pixels = (short[])sp.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            if (i % 38 == 0) {
                out.write("\n");
            }
            int p = pixels[i] & 0xFFFF;
            int pn = Math.round(((float)p - offset) * scale);
            out.write(this.toHex(pn));
        }
    }

    void writeGray(Writer out, FloatProcessor fp) throws IOException {
        float min = (float)fp.getMin();
        float max = (float)fp.getMax();
        float offset = min;
        float scale = 1.0f;
        if ((double)(max - min) > 0.001) {
            scale = 255.0f * (max - min);
        }
        float[] pixels = (float[])fp.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            if (i % 38 == 0) {
                out.write("\n");
            }
            int pn = Math.round((pixels[i] - offset) * scale);
            out.write(this.toHex(pn));
        }
    }

    void writeColor(Writer out, ColorProcessor cp) throws IOException {
        int lineLength = 12;
        int[] pixels = (int[])cp.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            if (i % 12 == 0) {
                out.write("\n");
            }
            int c = pixels[i];
            out.write(this.toHex(c >> 16 & 0xFF));
            out.write(this.toHex(c >> 8 & 0xFF));
            out.write(this.toHex(c & 0xFF));
        }
    }

    void writeColor(Writer out, ByteProcessor bp) throws IOException {
        int lineLength = 12;
        ColorModel cm = bp.getColorModel();
        byte[] pixels = (byte[])bp.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            if (i % 12 == 0) {
                out.write("\n");
            }
            int value = 0xFF & pixels[i];
            out.write(this.toHex(cm.getRed(value) & 0xFF));
            out.write(this.toHex(cm.getGreen(value) & 0xFF));
            out.write(this.toHex(cm.getBlue(value) & 0xFF));
        }
    }

    char[] toHex(int m) {
        this.hexByte[0] = this.hexChar[m >> 4 & 0xF];
        this.hexByte[1] = this.hexChar[m & 0xF];
        return this.hexByte;
    }

    String stripFileExtension(String fileName) {
        int dotInd = fileName.lastIndexOf(46);
        return dotInd > 0 ? fileName.substring(0, dotInd) : fileName;
    }
}

