/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata.imagej;

import ij.ImagePlus;
import java.io.IOException;
import java.util.Arrays;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.SpatialMetadataToImagePlus;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.NgffSingleScaleAxesMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;

public class NgffToImagePlus
extends SpatialMetadataToImagePlus<NgffSingleScaleAxesMetadata> {
    @Override
    public void writeMetadata(NgffSingleScaleAxesMetadata t, ImagePlus ip) throws IOException {
        ip.setTitle(t.getPath());
        int numChannels = 0;
        int numTimes = 0;
        int numZ = 0;
        int numSpace = 0;
        int xIdx = -1;
        int yIdx = -1;
        int cIdx = -1;
        int zIdx = -1;
        int tIdx = -1;
        for (int i = 0; i < t.getAxes().length; ++i) {
            Axis axis = t.getAxis(i);
            if (axis.getType().equals("time")) {
                numTimes = (int)t.getAttributes().getDimensions()[i];
                tIdx = i;
            }
            if (axis.getType().equals("channel")) {
                numChannels = (int)t.getAttributes().getDimensions()[i];
                cIdx = i;
            }
            if (!axis.getType().equals("space")) continue;
            if (++numSpace == 1) {
                xIdx = i;
            } else if (numSpace == 2) {
                yIdx = i;
            } else if (numSpace == 3) {
                zIdx = i;
            }
            if (numSpace <= 2) continue;
            numZ = (int)t.getAttributes().getDimensions()[i];
        }
        numChannels = numChannels == 0 ? 1 : numChannels;
        numZ = numZ == 0 ? 1 : numZ;
        int n = numTimes = numTimes == 0 ? 1 : numTimes;
        if (xIdx >= 0) {
            ip.getCalibration().pixelWidth = t.getScale()[xIdx];
            ip.getCalibration().xOrigin = t.getTranslation()[xIdx];
        }
        if (yIdx >= 0) {
            ip.getCalibration().pixelHeight = t.getScale()[yIdx];
            ip.getCalibration().yOrigin = t.getTranslation()[yIdx];
        }
        if (zIdx >= 0) {
            ip.getCalibration().pixelDepth = t.getScale()[zIdx];
            ip.getCalibration().zOrigin = t.getTranslation()[zIdx];
        }
        if (tIdx > 0) {
            ip.getCalibration().frameInterval = t.getScale()[tIdx];
        }
    }

    @Override
    public NgffSingleScaleAxesMetadata readMetadata(ImagePlus ip) throws IOException {
        boolean noOffset;
        int nc = ip.getNChannels();
        int nz = ip.getNSlices();
        int nt = ip.getNFrames();
        int N = 2;
        if (nz > 1) {
            ++N;
        }
        if (nc > 1) {
            ++N;
        }
        if (nt > 1) {
            ++N;
        }
        Axis[] axes = new Axis[N];
        double[] scale = new double[N];
        double[] offset = new double[N];
        String spaceUnit = ip.getCalibration().getUnit();
        axes[0] = new Axis("space", "x", spaceUnit);
        scale[0] = ip.getCalibration().pixelWidth;
        offset[0] = ip.getCalibration().xOrigin;
        axes[1] = new Axis("space", "y", spaceUnit);
        scale[1] = ip.getCalibration().pixelHeight;
        offset[1] = ip.getCalibration().yOrigin;
        int k = 2;
        if (nc > 1) {
            axes[k] = new Axis("channel", "c", "");
            scale[k] = 1.0;
            offset[k] = 0.0;
            ++k;
        }
        if (nz > 1) {
            axes[k] = new Axis("space", "z", spaceUnit);
            scale[k] = ip.getCalibration().pixelDepth;
            offset[k] = ip.getCalibration().zOrigin;
            ++k;
        }
        if (nt > 1) {
            axes[k] = new Axis("time", "t", ip.getCalibration().getTimeUnit());
            scale[k] = ip.getCalibration().frameInterval;
            if (scale[k] == 0.0) {
                scale[k] = 1.0;
            }
            offset[k] = 0.0;
            ++k;
        }
        if (noOffset = Arrays.stream(offset).allMatch(x -> x == 0.0)) {
            return new NgffSingleScaleAxesMetadata("", scale, null, axes, ImageplusMetadata.datasetAttributes(ip));
        }
        return new NgffSingleScaleAxesMetadata("", scale, offset, axes, ImageplusMetadata.datasetAttributes(ip));
    }

    public static OmeNgffMultiScaleMetadata buildMetadata(ImagePlus image, String path, DatasetAttributes[] dsetAttrs, OmeNgffMultiScaleMetadata.OmeNgffDataset[] datasets) {
        int nc = image.getNChannels();
        int nz = image.getNSlices();
        int nt = image.getNFrames();
        String unit = image.getCalibration().getUnit();
        int N = 2;
        if (nc > 1) {
            ++N;
        }
        if (nz > 1) {
            ++N;
        }
        if (nt > 1) {
            ++N;
        }
        Object[] axes = new Axis[N];
        double[] pixelSpacing = new double[N];
        axes[0] = new Axis("space", "x", unit);
        pixelSpacing[0] = image.getCalibration().pixelWidth;
        axes[1] = new Axis("space", "y", unit);
        pixelSpacing[1] = image.getCalibration().pixelHeight;
        int d = 2;
        if (nc > 1) {
            axes[d] = new Axis("channel", "c", "");
            pixelSpacing[d] = 1.0;
            ++d;
        }
        if (nz > 1) {
            axes[d] = new Axis("space", "z", unit);
            pixelSpacing[d] = image.getCalibration().pixelDepth;
            ++d;
        }
        if (nt > 1) {
            axes[d] = new Axis("time", "t", image.getCalibration().getTimeUnit());
            pixelSpacing[d] = image.getCalibration().frameInterval;
            ++d;
        }
        Object[] axesToWrite = dsetAttrs != null ? (Axis[])OmeNgffMultiScaleMetadata.reverseIfCorder((DatasetAttributes)dsetAttrs[0], (Object[])axes) : axes;
        String name = image.getTitle();
        String type = "sampling";
        String version = "0.4";
        return new OmeNgffMultiScaleMetadata(N, path, name, "sampling", "0.4", (Axis[])axesToWrite, datasets, dsetAttrs, null, null);
    }

    public static OmeNgffMultiScaleMetadata buildMetadata(NgffSingleScaleAxesMetadata meta, String name, String path, DatasetAttributes[] dsetAttrs, OmeNgffMultiScaleMetadata.OmeNgffDataset[] datasets) {
        int N = meta.getScale().length;
        String type = "sampling";
        String version = "0.4";
        return new OmeNgffMultiScaleMetadata(N, path, name, "sampling", "0.4", meta.getAxes(), datasets, dsetAttrs, null, null);
    }
}

