/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ij;

import ij.IJ;
import ij.ImagePlus;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.DoubleStream;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.SubsampleIntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.Lz4Compression;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.XzCompression;
import org.janelia.saalfeldlab.n5.blosc.BloscCompression;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.metadata.imagej.CosemToImagePlus;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImagePlusLegacyMetadataParser;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImagePlusMetadataTemplate;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.MetadataTemplateMapper;
import org.janelia.saalfeldlab.n5.metadata.imagej.N5ViewerToImagePlus;
import org.janelia.saalfeldlab.n5.ui.N5MetadataSpecDialog;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformation;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.ScaleCoordinateTransformation;
import org.scijava.ItemVisibility;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.UIService;

@Deprecated
public class NgffExporter
implements WindowListener {
    public static final String GZIP_COMPRESSION = "gzip";
    public static final String RAW_COMPRESSION = "raw";
    public static final String LZ4_COMPRESSION = "lz4";
    public static final String XZ_COMPRESSION = "xz";
    public static final String BLOSC_COMPRESSION = "blosc";
    public static final String NONE = "None";
    public static final String NO_OVERWRITE = "No overwrite";
    public static final String OVERWRITE = "Overwrite";
    public static final String WRITE_SUBSET = "Overwrite subset";
    @Parameter(visibility=ItemVisibility.MESSAGE, required=false)
    private final String message = "Export an ImagePlus to an OME-NGFF";
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @Parameter
    private UIService ui;
    @Parameter(label="Image")
    private ImagePlus image;
    @Parameter(label="Root url")
    private String rootLocation;
    @Parameter(label="Dataset", required=false)
    private String dataset;
    @Parameter(label="Block size")
    private String blockSizeArg;
    @Parameter(label="Number of scales")
    private Integer numScales = 1;
    @Parameter(label="Compression", choices={"gzip", "raw", "lz4", "xz", "blosc"}, style="listBox")
    private String compressionArg = "gzip";
    @Parameter(label="Thread count", required=true, min="1", max="256")
    private final int nThreads = 1;
    @Parameter(label="Overwrite options", required=true, choices={"No overwrite", "Overwrite", "Overwrite subset"}, description="Determines whether overwriting datasets allows, and how overwriting occurs. If selected will overwrite values in an existing dataset if they exist.")
    private String overwriteChoices = "No overwrite";
    @Parameter(label="Overwrite subset offset", required=false, description="The point in pixel units where the origin of this image will be written into the n5-dataset (comma-delimited)")
    private String subsetOffset;
    private int[] blockSize;
    private final Map<String, N5MetadataWriter<?>> styles = new HashMap();
    private ImageplusMetadata<?> impMeta;
    private N5MetadataSpecDialog metaSpecDialog;
    private final HashMap<Class<?>, ImageplusMetadata<?>> impMetaWriterTypes;

    public NgffExporter() {
        this.styles.put("N5Viewer", (N5MetadataWriter<?>)new N5SingleScaleMetadataParser());
        this.styles.put("COSEM", (N5MetadataWriter<?>)new N5CosemMetadataParser());
        this.styles.put("ImageJ", new ImagePlusLegacyMetadataParser());
        this.impMetaWriterTypes = new HashMap();
        this.impMetaWriterTypes.put(ImagePlusLegacyMetadataParser.class, new ImagePlusLegacyMetadataParser());
        this.impMetaWriterTypes.put(N5CosemMetadataParser.class, new CosemToImagePlus());
        this.impMetaWriterTypes.put(N5SingleScaleMetadataParser.class, new N5ViewerToImagePlus());
    }

    public void setOptions(ImagePlus image, String rootLocation, String dataset, String blockSizeArg, String compression, int nScales, String overwriteOption, String subsetOffset) {
        this.image = image;
        this.rootLocation = rootLocation;
        this.dataset = N5URI.normalizeGroupPath(dataset);
        this.blockSizeArg = blockSizeArg;
        this.compressionArg = compression;
        this.numScales = nScales;
        this.overwriteChoices = overwriteOption;
        this.subsetOffset = subsetOffset;
    }

    public void parseBlockSize() {
        int i;
        int nd = this.image.getNDimensions();
        String[] blockArgList = this.blockSizeArg.split(",");
        this.blockSize = new int[nd];
        for (i = 0; i < blockArgList.length && i < nd; ++i) {
            this.blockSize[i] = Integer.parseInt(blockArgList[i]);
        }
        int N = blockArgList.length - 1;
        while (i < nd) {
            this.blockSize[i] = this.blockSize[N];
            ++i;
        }
    }

    public <T extends RealType<T> & NativeType<T>, M extends N5DatasetMetadata> void process() throws IOException, InterruptedException, ExecutionException {
        N5Writer n5 = new N5Factory().zarrDimensionSeparator("/").gsonBuilder(OmeNgffMetadataParser.gsonBuilder()).openWriter(this.rootLocation);
        Compression compression = this.getCompression();
        this.parseBlockSize();
        N5MetadataWriter<M> writer = null;
        Img img = ImageJFunctions.wrap((ImagePlus)this.image);
        int nd = img.numDimensions();
        this.write((RandomAccessibleInterval<T>)img, n5, this.dataset + "/s0", compression, writer);
        DatasetAttributes[] dsetAttrs = new DatasetAttributes[this.numScales.intValue()];
        OmeNgffMultiScaleMetadata.OmeNgffDataset[] msDatasets = new OmeNgffMultiScaleMetadata.OmeNgffDataset[this.numScales.intValue()];
        String dset = this.dataset + "/s0";
        dsetAttrs[0] = n5.getDatasetAttributes(dset);
        msDatasets[0] = new OmeNgffMultiScaleMetadata.OmeNgffDataset();
        msDatasets[0].path = dset;
        int scale = 1;
        for (int i = 1; i < this.numScales; ++i) {
            SubsampleIntervalView<T> imgDown = this.downsampleSimple((RandomAccessibleInterval<T>)img, scale *= 2);
            dset = String.format("%s/s%d", this.dataset, i);
            this.write((RandomAccessibleInterval<T>)imgDown, n5, dset, compression, writer);
            dsetAttrs[i] = n5.getDatasetAttributes(dset);
            msDatasets[i] = new OmeNgffMultiScaleMetadata.OmeNgffDataset();
            msDatasets[i].path = dset;
            double s = scale;
            msDatasets[i].coordinateTransformations = new CoordinateTransformation[]{new ScaleCoordinateTransformation(DoubleStream.generate(() -> s).limit(nd).toArray())};
        }
        OmeNgffMultiScaleMetadata ms = this.buildMetadata(this.dataset, dsetAttrs, msDatasets);
        OmeNgffMultiScaleMetadata[] msList = new OmeNgffMultiScaleMetadata[]{ms};
        OmeNgffMetadata meta = new OmeNgffMetadata(this.dataset, msList);
        try {
            new OmeNgffMetadataParser().writeMetadata(meta, n5, this.dataset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        n5.close();
    }

    public <T extends RealType<T> & NativeType<T>, M extends N5DatasetMetadata> SubsampleIntervalView<T> downsampleSimple(RandomAccessibleInterval<T> img, int downsampleFactor) {
        return Views.subsample(img, (long)downsampleFactor);
    }

    public OmeNgffMultiScaleMetadata buildMetadata(String path, DatasetAttributes[] dsetAttrs, OmeNgffMultiScaleMetadata.OmeNgffDataset[] datasets) {
        if (!OmeNgffMultiScaleMetadata.allSameAxisOrder((DatasetAttributes[])dsetAttrs)) {
            throw new RuntimeException("All ome-zarr arrays must have same array order");
        }
        int nc = this.image.getNChannels();
        int nz = this.image.getNSlices();
        int nt = this.image.getNFrames();
        String unit = this.image.getCalibration().getUnit();
        int N = 2;
        if (nc > 1) {
            ++N;
        }
        if (nz > 1) {
            ++N;
        }
        if (nt > 1) {
            ++N;
        }
        Object[] axes = new Axis[N];
        double[] pixelSpacing = new double[N];
        axes[0] = new Axis("space", "x", unit);
        pixelSpacing[0] = this.image.getCalibration().pixelWidth;
        axes[1] = new Axis("space", "y", unit);
        pixelSpacing[1] = this.image.getCalibration().pixelHeight;
        int d = 2;
        if (nc > 1) {
            axes[d] = new Axis("channel", "c", "");
            pixelSpacing[d] = 1.0;
            ++d;
        }
        if (nz > 1) {
            axes[d] = new Axis("space", "z", unit);
            pixelSpacing[d] = this.image.getCalibration().pixelDepth;
            ++d;
        }
        if (nt > 1) {
            axes[d] = new Axis("time", "t", this.image.getCalibration().getTimeUnit());
            pixelSpacing[d] = this.image.getCalibration().frameInterval;
            ++d;
        }
        Axis[] axesToWrite = (Axis[])OmeNgffMultiScaleMetadata.reverseIfCorder((DatasetAttributes)dsetAttrs[0], (Object[])axes);
        String name = this.image.getTitle();
        String type = "sampling";
        String version = "0.4";
        return new OmeNgffMultiScaleMetadata(N, path, name, "sampling", "0.4", axesToWrite, datasets, dsetAttrs, null, null);
    }

    private <T extends RealType & NativeType, M extends N5DatasetMetadata> void write(RandomAccessibleInterval<T> image, N5Writer n5, String dataset, Compression compression, N5MetadataWriter<M> writer) throws IOException, InterruptedException, ExecutionException {
        if (this.overwriteChoices.equals(NO_OVERWRITE) && n5.datasetExists(dataset)) {
            if (this.ui != null) {
                this.ui.showDialog(String.format("Dataset (%s) already exists, not writing.", dataset));
            } else {
                System.out.println(String.format("Dataset (%s) already exists, not writing.", dataset));
            }
            return;
        }
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.progressMonitor(threadPool);
        N5Utils.save(image, (N5Writer)n5, (String)dataset, (int[])this.blockSize, (Compression)compression, (ExecutorService)Executors.newFixedThreadPool(1));
        this.writeMetadata(n5, dataset, writer);
    }

    private static long[] getOffsetForSaveSubset3d(ImagePlus imp) {
        int nd = imp.getNDimensions();
        long[] offset = new long[nd];
        offset[0] = (int)imp.getCalibration().xOrigin;
        offset[1] = (int)imp.getCalibration().yOrigin;
        int j = 2;
        if (imp.getNSlices() > 1) {
            offset[j++] = (int)imp.getCalibration().zOrigin;
        }
        return offset;
    }

    private <M extends N5Metadata> void writeMetadata(N5Writer n5, String datasetString, N5MetadataWriter<M> writer) {
        if (writer != null) {
            try {
                Object meta = this.impMeta.readMetadata(this.image);
                writer.writeMetadata(meta, n5, datasetString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void run() {
        try {
            this.process();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void progressMonitor(final ThreadPoolExecutor exec) {
        new Thread(){

            @Override
            public void run() {
                IJ.showProgress((double)0.01);
                try {
                    Thread.sleep(333L);
                    boolean done = false;
                    while (!done && !exec.isShutdown()) {
                        long N;
                        long i = exec.getCompletedTaskCount();
                        done = i == (N = exec.getTaskCount());
                        IJ.showProgress((double)((double)i / (double)N));
                        Thread.sleep(333L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IJ.showProgress((double)1.0);
            }
        }.start();
    }

    private Compression getCompression() {
        switch (this.compressionArg) {
            case "gzip": {
                return new GzipCompression();
            }
            case "lz4": {
                return new Lz4Compression();
            }
            case "xz": {
                return new XzCompression();
            }
            case "raw": {
                return new RawCompression();
            }
            case "blosc": {
                return new BloscCompression();
            }
        }
        return new RawCompression();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.styles.put("Custom", this.metaSpecDialog.getMapper());
        this.impMetaWriterTypes.put(MetadataTemplateMapper.class, new ImagePlusMetadataTemplate());
        try {
            this.process();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    public static enum OVERWRITE_OPTIONS {
        NO_OVERWRITE,
        OVERWRITE,
        WRITE_SUBSET;

    }
}

