/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ij;

import ij.ImagePlus;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.Img;
import net.imglib2.img.VirtualStackAdapter;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ByteImagePlus;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.util.Pair;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;

public class N5IJUtils {
    public static <T extends NativeType<T> & NumericType<T>> ImagePlus load(N5Reader n5, String dataset) throws IOException, ImgLibException {
        return N5IJUtils.load(n5, dataset, null);
    }

    public static <T extends NativeType<T> & NumericType<T>, M extends N5DatasetMetadata, W extends N5MetadataParser<M> & ImageplusMetadata<M>> ImagePlus load(N5Reader n5, String dataset, W metaReader) throws IOException, ImgLibException {
        return N5IJUtils.load(n5, dataset, metaReader, (ImageplusMetadata<M>)metaReader);
    }

    public static <T extends NativeType<T> & NumericType<T>, M extends N5DatasetMetadata, W extends N5MetadataParser<M>, I extends ImageplusMetadata<M>> ImagePlus load(N5Reader n5, String dataset, W metaReader, I ipMeta) throws IOException, ImgLibException {
        ByteImagePlus impImg;
        CachedCellImg rai = N5Utils.open((N5Reader)n5, (String)dataset);
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        long[] dimensions = attributes.getDimensions();
        N5DatasetMetadata metadata = null;
        if (metaReader != null && metaReader != null) {
            try {
                metadata = (N5DatasetMetadata)metaReader.parseMetadata(n5, dataset).get();
                if (metadata != null && metadata instanceof AxisMetadata) {
                    int[] p = AxisUtils.findImagePlusPermutation((AxisMetadata)((AxisMetadata)metadata));
                    Iterator res = AxisUtils.permuteImageAndMetadataForImagePlus((int[])p, (RandomAccessibleInterval)rai, (N5Metadata)metadata);
                    rai = (RandomAccessibleInterval)res.getA();
                    dimensions = rai.dimensionsAsLongArray();
                    metadata = (N5DatasetMetadata)res.getB();
                }
            }
            catch (Exception e) {
                System.err.println("Warning: could not read metadata.");
            }
        }
        switch (attributes.getDataType()) {
            case UINT8: {
                impImg = ImagePlusImgs.unsignedBytes((long[])dimensions);
                break;
            }
            case INT8: {
                impImg = ImagePlusImgs.bytes((long[])dimensions);
                break;
            }
            case UINT16: {
                impImg = ImagePlusImgs.unsignedShorts((long[])dimensions);
                break;
            }
            case INT16: {
                impImg = ImagePlusImgs.shorts((long[])dimensions);
                break;
            }
            case UINT32: {
                impImg = ImagePlusImgs.unsignedInts((long[])dimensions);
                break;
            }
            case INT32: {
                impImg = ImagePlusImgs.ints((long[])dimensions);
                break;
            }
            case FLOAT32: {
                impImg = ImagePlusImgs.floats((long[])dimensions);
                break;
            }
            default: {
                System.err.println("Data type " + (Object)((Object)attributes.getDataType()) + " not supported in ImageJ.");
                return null;
            }
        }
        for (Pair pair : Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.pair((RandomAccessible)rai, (RandomAccessible)impImg), (Interval)rai))) {
            ((NativeType)pair.getB()).set((Type)pair.getA());
        }
        ImagePlus imp = impImg.getImagePlus();
        if (metadata != null) {
            ipMeta.writeMetadata((N5DatasetMetadata)metadata, imp);
        }
        return imp;
    }

    public static void save(ImagePlus imp, N5Writer n5, String datasetName, int[] blockSize, Compression compression) throws IOException {
        N5MetadataWriter<M> & ImageplusMetadata<M> nullWriter = null;
        N5IJUtils.save(imp, n5, datasetName, blockSize, compression, nullWriter);
    }

    public static <T extends RealType & NativeType, M extends N5DatasetMetadata, W extends N5MetadataWriter<M> & ImageplusMetadata<M>> void save(ImagePlus imp, N5Writer n5, String datasetName, int[] blockSize, Compression compression, W metaWriter) throws IOException {
        N5IJUtils.save(imp, n5, datasetName, blockSize, compression, metaWriter, (ImageplusMetadata<M>)metaWriter);
    }

    public static <T extends RealType & NativeType, M extends N5DatasetMetadata, W extends N5MetadataWriter<M>, I extends ImageplusMetadata<M>> void save(ImagePlus imp, N5Writer n5, String datasetName, int[] blockSize, Compression compression, W metaWriter, I ipMetadata) throws IOException {
        Img rai = imp.getType() == 4 ? (Img)N5IJUtils.wrapRgbAsInt(imp) : ImageJFunctions.wrap((ImagePlus)imp);
        N5Utils.save((RandomAccessibleInterval)rai, (N5Writer)n5, (String)datasetName, (int[])blockSize, (Compression)compression);
        if (metaWriter != null && metaWriter != null) {
            try {
                M metadata = ipMetadata.readMetadata(imp);
                metaWriter.writeMetadata(metadata, n5, datasetName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void save(ImagePlus imp, N5Writer n5, String datasetName, int[] blockSize, Compression compression, ExecutorService exec) throws IOException, InterruptedException, ExecutionException {
        N5IJUtils.save(imp, n5, datasetName, blockSize, compression, exec, null, null);
    }

    public static <T extends RealType & NativeType, M extends N5DatasetMetadata, W extends N5MetadataWriter<M> & ImageplusMetadata<M>> void save(ImagePlus imp, N5Writer n5, String datasetName, int[] blockSize, Compression compression, ExecutorService exec, W metaWriter) throws IOException, InterruptedException, ExecutionException {
        N5IJUtils.save(imp, n5, datasetName, blockSize, compression, exec, metaWriter, (ImageplusMetadata<M>)metaWriter);
    }

    public static <T extends RealType & NativeType, M extends N5DatasetMetadata, W extends N5MetadataWriter<M>, I extends ImageplusMetadata<M>> void save(ImagePlus imp, N5Writer n5, String datasetName, int[] blockSize, Compression compression, ExecutorService exec, W metaWriter, I ipMetadata) throws IOException, InterruptedException, ExecutionException {
        Img rai = imp.getType() == 4 ? (Img)N5IJUtils.wrapRgbAsInt(imp) : ImageJFunctions.wrap((ImagePlus)imp);
        N5Utils.save((RandomAccessibleInterval)rai, (N5Writer)n5, (String)datasetName, (int[])blockSize, (Compression)compression, (ExecutorService)exec);
        if (metaWriter != null && metaWriter != null) {
            try {
                M metadata = ipMetadata.readMetadata(imp);
                metaWriter.writeMetadata(metadata, n5, datasetName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveMaskedUnsignedByte(ImagePlus imp, N5Writer n5, String groupName, int[] blockSize, Compression compression) throws IOException {
        ImagePlusImg rai = ImagePlusImgs.from((ImagePlus)imp);
        RandomAccessibleInterval mask = Converters.convert((RandomAccessibleInterval)rai, (argb, uint8) -> {
            int argbValue = argb.get();
            int r = ARGBType.red((int)argbValue);
            int g = ARGBType.green((int)argbValue);
            int b = ARGBType.blue((int)argbValue);
            if (r == g && g == b) {
                uint8.set(1);
            } else {
                uint8.set(0);
            }
        }, (Type)new UnsignedByteType());
        RandomAccessibleInterval gray = Converters.convert((RandomAccessibleInterval)rai, (argb, uint8) -> uint8.set(ARGBType.red((int)argb.get())), (Type)new UnsignedByteType());
        n5.createGroup(groupName);
        N5Utils.save((RandomAccessibleInterval)mask, (N5Writer)n5, (String)(groupName + "/mask"), (int[])blockSize, (Compression)compression);
        N5Utils.save((RandomAccessibleInterval)gray, (N5Writer)n5, (String)(groupName + "/gray"), (int[])blockSize, (Compression)compression);
    }

    public static void saveMaskedUnsignedByte(ImagePlus imp, N5Writer n5, String groupName, int[] blockSize, Compression compression, ExecutorService exec) throws IOException, InterruptedException, ExecutionException {
        ImagePlusImg rai = ImagePlusImgs.from((ImagePlus)imp);
        RandomAccessibleInterval mask = Converters.convert((RandomAccessibleInterval)rai, (argb, uint8) -> {
            int argbValue = argb.get();
            int r = ARGBType.red((int)argbValue);
            int g = ARGBType.green((int)argbValue);
            int b = ARGBType.blue((int)argbValue);
            if (r == g && g == b) {
                uint8.set(1);
            } else {
                uint8.set(0);
            }
        }, (Type)new UnsignedByteType());
        RandomAccessibleInterval gray = Converters.convert((RandomAccessibleInterval)rai, (argb, uint8) -> uint8.set(ARGBType.red((int)argb.get())), (Type)new UnsignedByteType());
        n5.createGroup(groupName);
        N5Utils.save((RandomAccessibleInterval)mask, (N5Writer)n5, (String)(groupName + "/mask"), (int[])blockSize, (Compression)compression, (ExecutorService)exec);
        N5Utils.save((RandomAccessibleInterval)gray, (N5Writer)n5, (String)(groupName + "/gray"), (int[])blockSize, (Compression)compression, (ExecutorService)exec);
    }

    public static RandomAccessibleInterval<UnsignedIntType> wrapRgbAsInt(ImagePlus image) {
        if (image.getType() != 4) {
            throw new IllegalArgumentException();
        }
        ImgPlus wimg = VirtualStackAdapter.wrapRGBA((ImagePlus)image);
        return Converters.convertRAI((RandomAccessibleInterval)wimg, (Converter)new Converter<ARGBType, UnsignedIntType>(){

            public void convert(ARGBType input, UnsignedIntType output) {
                output.set((long)input.get());
            }
        }, (Type)new UnsignedIntType());
    }
}

