/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.SIFT;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.ij.blockmatching.BlockMatching;
import mpicbg.ij.plugin.ElasticAlign;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AbstractModel;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.MovingLeastSquaresTransform;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.Spring;
import mpicbg.models.SpringMesh;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;
import mpicbg.models.TransformMesh;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.Vertex;
import mpicbg.util.Util;

public class ElasticMontage
implements PlugIn {
    static final Param p = new Param();

    public final void run(String args) {
        if (IJ.versionLessThan((String)"1.41n")) {
            return;
        }
        try {
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void run() throws Exception {
        ColorProcessor ip;
        Object meshMin;
        void var12_15;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            System.err.println("There are no images open");
            return;
        }
        if (!p.setup()) {
            return;
        }
        final ImageStack stack = imp.getStack();
        final double displayRangeMin = imp.getDisplayRangeMin();
        final double displayRangeMax = imp.getDisplayRangeMax();
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        block9: for (int i = 0; i < stack.getSize(); ++i) {
            switch (ElasticMontage.p.modelIndexOptimize) {
                case 0: {
                    tiles.add(new Tile((Model)new TranslationModel2D()));
                    continue block9;
                }
                case 1: {
                    tiles.add(new Tile((Model)new RigidModel2D()));
                    continue block9;
                }
                case 2: {
                    tiles.add(new Tile((Model)new SimilarityModel2D()));
                    continue block9;
                }
                case 3: {
                    tiles.add(new Tile((Model)new AffineModel2D()));
                    continue block9;
                }
                case 4: {
                    tiles.add(new Tile((Model)new HomographyModel2D()));
                    continue block9;
                }
                default: {
                    return;
                }
            }
        }
        ExecutorService execSift = Executors.newFixedThreadPool(ElasticMontage.p.maxNumThreadsSift);
        final AtomicInteger counter = new AtomicInteger(0);
        ArrayList<Future<ArrayList<Feature>>> siftTasks = new ArrayList<Future<ArrayList<Feature>>>();
        int i = 1;
        while (i <= stack.getSize()) {
            final int n = i++;
            siftTasks.add(execSift.submit(new Callable<ArrayList<Feature>>(){

                @Override
                public ArrayList<Feature> call() {
                    IJ.showProgress((int)counter.getAndIncrement(), (int)stack.getSize());
                    String path = ElasticMontage.p.outputPath + String.format("%05d", n - 1) + ".features";
                    ArrayList<Feature> fs = ElasticMontage.deserializeFeatures(ElasticMontage.p.sift, path);
                    if (null == fs) {
                        FloatArray2DSIFT sift = new FloatArray2DSIFT(ElasticMontage.p.sift);
                        SIFT ijSIFT = new SIFT(sift);
                        fs = new ArrayList<Feature>();
                        ImageProcessor ip = stack.getProcessor(n);
                        ip.setMinAndMax(displayRangeMin, displayRangeMax);
                        ijSIFT.extractFeatures(ip, fs);
                        if (!ElasticMontage.serializeFeatures(ElasticMontage.p.sift, fs, path)) {
                            IJ.log((String)("FAILED to store serialized features for " + String.format("%05d", n - 1)));
                        }
                    }
                    IJ.log((String)(fs.size() + " features extracted for slice " + String.format("%05d", n - 1)));
                    return fs;
                }
            }));
        }
        for (Future future : siftTasks) {
            future.get();
        }
        siftTasks.clear();
        execSift.shutdown();
        ArrayList<Triple> pairs = new ArrayList<Triple>();
        counter.set(0);
        boolean bl = false;
        while (var12_15 < stack.getSize()) {
            ArrayList<2> threads = new ArrayList<2>(ElasticMontage.p.maxNumThreads);
            void sliceA = var12_15;
            void j = var12_15 + true;
            while (j < stack.getSize()) {
                int numThreads = Math.min(ElasticMontage.p.maxNumThreads, stack.getSize() - j);
                ArrayList<Object> models = new ArrayList<Object>(numThreads);
                for (int k = 0; k < numThreads; ++k) {
                    models.add(null);
                }
                int t = 0;
                while (t < ElasticMontage.p.maxNumThreads && j < stack.getSize()) {
                    void var19_32 = j++;
                    int ti = t++;
                    Thread thread = new Thread((int)var19_32, (int)sliceA, models, ti){
                        final /* synthetic */ int val$sliceB;
                        final /* synthetic */ int val$sliceA;
                        final /* synthetic */ ArrayList val$models;
                        final /* synthetic */ int val$ti;
                        {
                            this.val$sliceB = n;
                            this.val$sliceA = n2;
                            this.val$models = arrayList;
                            this.val$ti = n3;
                        }

                        @Override
                        public void run() {
                            boolean modelFound;
                            TranslationModel2D model;
                            IJ.showProgress((int)counter.getAndIncrement(), (int)(stack.getSize() - 1));
                            IJ.log((String)("matching " + this.val$sliceB + " -> " + this.val$sliceA + "..."));
                            String path = ElasticMontage.p.outputPath + String.format("%05d", this.val$sliceB) + "-" + String.format("%05d", this.val$sliceA) + ".pointmatches";
                            ArrayList candidates = ElasticMontage.deserializePointMatches(p, path);
                            if (null == candidates) {
                                ArrayList fs1 = ElasticMontage.deserializeFeatures(ElasticMontage.p.sift, ElasticMontage.p.outputPath + String.format("%05d", this.val$sliceA) + ".features");
                                ArrayList fs2 = ElasticMontage.deserializeFeatures(ElasticMontage.p.sift, ElasticMontage.p.outputPath + String.format("%05d", this.val$sliceB) + ".features");
                                candidates = new ArrayList(FloatArray2DSIFT.createMatches((List)fs2, (List)fs1, (float)ElasticMontage.p.rod));
                                if (!ElasticMontage.serializePointMatches(p, candidates, path)) {
                                    IJ.log((String)"Could not store point matches!");
                                }
                            }
                            switch (ElasticMontage.p.modelIndex) {
                                case 0: {
                                    model = new TranslationModel2D();
                                    break;
                                }
                                case 1: {
                                    model = new RigidModel2D();
                                    break;
                                }
                                case 2: {
                                    model = new SimilarityModel2D();
                                    break;
                                }
                                case 3: {
                                    model = new AffineModel2D();
                                    break;
                                }
                                case 4: {
                                    model = new HomographyModel2D();
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            ArrayList inliers = new ArrayList();
                            try {
                                modelFound = model.filterRansac((List)candidates, inliers, 1000, (double)ElasticMontage.p.maxEpsilon, (double)ElasticMontage.p.minInlierRatio, ElasticMontage.p.minNumInliers);
                            }
                            catch (Exception e) {
                                modelFound = false;
                                System.err.println(e.getMessage());
                            }
                            if (!modelFound) {
                                IJ.log((String)(this.val$sliceB + " -> " + this.val$sliceA + ": no correspondences found."));
                                return;
                            }
                            IJ.log((String)(this.val$sliceB + " -> " + this.val$sliceA + ": " + inliers.size() + " corresponding features with an average displacement of " + PointMatch.meanDistance(inliers) + "px identified."));
                            IJ.log((String)("Estimated transformation model: " + model));
                            this.val$models.set(this.val$ti, new Triple<Integer, Integer, TranslationModel2D>(this.val$sliceA, this.val$sliceB, model));
                        }
                    };
                    threads.add(thread);
                    thread.start();
                }
                for (Thread thread : threads) {
                    thread.join();
                }
                for (t = 0; t < models.size(); ++t) {
                    Triple triple = (Triple)models.get(t);
                    if (triple == null) continue;
                    pairs.add(triple);
                }
            }
            IJ.showProgress((int)var12_15, (int)(stack.getSize() - 1));
            ++var12_15;
        }
        TileConfiguration tileConfiguration = new TileConfiguration();
        tileConfiguration.addTiles(tiles);
        ArrayList<SpringMesh> meshes = new ArrayList<SpringMesh>(stack.getSize());
        for (int i3 = 0; i3 < stack.getSize(); ++i3) {
            meshes.add(new SpringMesh(ElasticMontage.p.resolutionSpringMesh, (double)stack.getWidth(), (double)stack.getHeight(), ElasticMontage.p.stiffnessSpringMesh, ElasticMontage.p.maxStretchSpringMesh, ElasticMontage.p.dampSpringMesh));
        }
        int blockRadius = Math.max(32, stack.getWidth() / ElasticMontage.p.resolutionSpringMesh / 2);
        int searchRadius = Math.round(ElasticMontage.p.maxEpsilon);
        AbstractModel<?> localSmoothnessFilterModel = ElasticAlign.createModel(ElasticMontage.p.localModelIndex);
        for (Triple pair : pairs) {
            Vertex p2;
            Vertex p1;
            SpringMesh springMesh = (SpringMesh)meshes.get((Integer)pair.a);
            SpringMesh m2 = (SpringMesh)meshes.get((Integer)pair.b);
            Iterator pm12 = new ArrayList();
            ArrayList pm21 = new ArrayList();
            ArrayList v1 = springMesh.getVertices();
            ArrayList v2 = m2.getVertices();
            FloatProcessor ip1 = (FloatProcessor)stack.getProcessor((Integer)pair.a + 1).convertToFloat().duplicate();
            FloatProcessor ip2 = (FloatProcessor)stack.getProcessor((Integer)pair.b + 1).convertToFloat().duplicate();
            BlockMatching.matchByMaximalPMCC((FloatProcessor)ip1, (FloatProcessor)ip2, null, null, (double)Math.min(1.0, (double)(ElasticMontage.p.maxImageSize / ip1.getWidth())), (CoordinateTransform)((InvertibleCoordinateTransform)pair.c).createInverse(), (int)blockRadius, (int)blockRadius, (int)searchRadius, (int)searchRadius, (float)ElasticMontage.p.minR, (float)ElasticMontage.p.rodR, (float)ElasticMontage.p.maxCurvatureR, (Collection)v1, pm12, (ErrorStatistic)new ErrorStatistic(1));
            if (ElasticMontage.p.useLocalSmoothnessFilter) {
                IJ.log((String)(pair.a + " > " + pair.b + ": found " + ((ArrayList)((Object)pm12)).size() + " correspondence candidates."));
                localSmoothnessFilterModel.localSmoothnessFilter(pm12, pm12, (double)ElasticMontage.p.localRegionSigma, (double)ElasticMontage.p.maxLocalEpsilon, (double)ElasticMontage.p.maxLocalTrust);
                IJ.log((String)(pair.a + " > " + pair.b + ": " + ((ArrayList)((Object)pm12)).size() + " candidates passed local smoothness filter."));
            } else {
                IJ.log((String)(pair.a + " > " + pair.b + ": found " + ((ArrayList)((Object)pm12)).size() + " correspondences."));
            }
            BlockMatching.matchByMaximalPMCC((FloatProcessor)ip2, (FloatProcessor)ip1, null, null, (double)Math.min(1.0, (double)(ElasticMontage.p.maxImageSize / ip1.getWidth())), (CoordinateTransform)((CoordinateTransform)pair.c), (int)blockRadius, (int)blockRadius, (int)searchRadius, (int)searchRadius, (float)ElasticMontage.p.minR, (float)ElasticMontage.p.rodR, (float)ElasticMontage.p.maxCurvatureR, (Collection)v2, pm21, (ErrorStatistic)new ErrorStatistic(1));
            if (ElasticMontage.p.useLocalSmoothnessFilter) {
                IJ.log((String)(pair.a + " < " + pair.b + ": found " + pm21.size() + " correspondence candidates."));
                localSmoothnessFilterModel.localSmoothnessFilter(pm21, pm21, (double)ElasticMontage.p.localRegionSigma, (double)ElasticMontage.p.maxLocalEpsilon, (double)ElasticMontage.p.maxLocalTrust);
                IJ.log((String)(pair.a + " < " + pair.b + ": " + pm21.size() + " candidates passed local smoothness filter."));
            } else {
                IJ.log((String)(pair.a + " < " + pair.b + ": found " + pm21.size() + " correspondences."));
            }
            Iterator iterator = ((ArrayList)((Object)pm12)).iterator();
            while (iterator.hasNext()) {
                PointMatch pm = (PointMatch)iterator.next();
                p1 = (Vertex)pm.getP1();
                p2 = new Vertex(pm.getP2());
                p1.addSpring(p2, new Spring(0.0, 1.0));
                m2.addPassiveVertex(p2);
            }
            for (PointMatch pm : pm21) {
                p1 = (Vertex)pm.getP1();
                p2 = new Vertex(pm.getP2());
                p1.addSpring(p2, new Spring(0.0, 1.0));
                springMesh.addPassiveVertex(p2);
            }
            Tile t1 = (Tile)tiles.get((Integer)pair.a);
            Tile t2 = (Tile)tiles.get((Integer)pair.b);
            if (((ArrayList)((Object)pm12)).size() > ((AbstractModel)pair.c).getMinNumMatches()) {
                t1.connect(t2, pm12);
            }
            if (pm21.size() <= ((AbstractModel)pair.c).getMinNumMatches()) continue;
            t2.connect(t1, pm21);
        }
        tileConfiguration.optimize((double)ElasticMontage.p.maxEpsilon, ElasticMontage.p.maxIterationsSpringMesh, ElasticMontage.p.maxPlateauwidthSpringMesh);
        for (int i4 = 0; i4 < stack.getSize(); ++i4) {
            ((SpringMesh)meshes.get(i4)).init((CoordinateTransform)((Tile)tiles.get(i4)).getModel());
        }
        try {
            long t0 = System.currentTimeMillis();
            IJ.log((String)"Optimizing spring meshes...");
            SpringMesh.optimizeMeshes(meshes, (double)ElasticMontage.p.maxEpsilon, (int)ElasticMontage.p.maxIterationsSpringMesh, (int)ElasticMontage.p.maxPlateauwidthSpringMesh, (boolean)ElasticMontage.p.visualize);
            IJ.log((String)("Done optimizing spring meshes. Took " + (System.currentTimeMillis() - t0) + " ms"));
        }
        catch (NotEnoughDataPointsException e) {
            e.printStackTrace();
        }
        Set firstMeshVertices = ((SpringMesh)meshes.get(0)).getVA().keySet();
        RigidModel2D rigid = new RigidModel2D();
        rigid.fit(firstMeshVertices);
        for (SpringMesh mesh : meshes) {
            for (Vertex vertex : mesh.getVertices()) {
                double[] w = vertex.getW();
                rigid.applyInverseInPlace(w);
            }
            mesh.updateAffines();
            mesh.updatePassiveVertices();
        }
        double[] dArray = new double[2];
        double[] max = new double[2];
        for (SpringMesh mesh : meshes) {
            meshMin = new double[2];
            double[] meshMax = new double[2];
            mesh.bounds((double[])meshMin, meshMax);
            Util.min((double[])dArray, (double[])meshMin);
            Util.max((double[])max, (double[])meshMax);
        }
        for (SpringMesh mesh : meshes) {
            meshMin = mesh.getVertices().iterator();
            while (meshMin.hasNext()) {
                Vertex vertex = (Vertex)meshMin.next();
                double[] w = vertex.getW();
                w[0] = w[0] - dArray[0];
                w[1] = w[1] - dArray[1];
            }
            mesh.updateAffines();
            mesh.updatePassiveVertices();
        }
        int width = (int)Math.ceil(max[0] - dArray[0]);
        int height = (int)Math.ceil(max[1] - dArray[1]);
        if (ElasticMontage.p.rgbWithGreenBackground) {
            ip = new ColorProcessor(width, height);
            for (int i5 = width * height - 1; i5 >= 0; --i5) {
                ip.set(i5, -16711936);
            }
        } else {
            ip = stack.getProcessor(1).createProcessor(width, height);
        }
        for (int i6 = 0; i6 < stack.getSize(); ++i6) {
            int slice = i6 + 1;
            MovingLeastSquaresTransform mlt = new MovingLeastSquaresTransform();
            mlt.setModel(AffineModel2D.class);
            mlt.setAlpha(2.0);
            mlt.setMatches(((SpringMesh)meshes.get(i6)).getVA().keySet());
            TransformMeshMapping mltMapping = new TransformMeshMapping((TransformMesh)new CoordinateTransformMesh((CoordinateTransform)mlt, ElasticMontage.p.resolutionOutput, (double)(stack.getWidth() - 1), (double)(stack.getHeight() - 1)));
            ImageProcessor source = ElasticMontage.p.rgbWithGreenBackground ? stack.getProcessor(slice).convertToRGB() : stack.getProcessor(slice);
            if (ElasticMontage.p.interpolate) {
                mltMapping.mapInterpolated(source, (ImageProcessor)ip);
                continue;
            }
            mltMapping.map(source, (ImageProcessor)ip);
        }
        IJ.save((ImagePlus)new ImagePlus("elastic montage", (ImageProcessor)ip), (String)(ElasticMontage.p.outputPath + "elastic-montage.tif"));
        IJ.log((String)"Done.");
    }

    private static final boolean serializeFeatures(FloatArray2DSIFT.Param param, ArrayList<Feature> fs, String path) {
        return ElasticMontage.serialize(new Features(param, fs), path);
    }

    private static final ArrayList<Feature> deserializeFeatures(FloatArray2DSIFT.Param param, String path) {
        Object o = ElasticMontage.deserialize(path);
        if (null == o) {
            return null;
        }
        Features fs = (Features)o;
        if (param.equals(fs.param)) {
            return fs.features;
        }
        return null;
    }

    private static final boolean serializePointMatches(Param param, ArrayList<PointMatch> pms, String path) {
        return ElasticMontage.serialize(new PointMatches(param, pms), path);
    }

    private static final ArrayList<PointMatch> deserializePointMatches(Param param, String path) {
        Object o = ElasticMontage.deserialize(path);
        if (null == o) {
            return null;
        }
        PointMatches pms = (PointMatches)o;
        if (param.equalSiftPointMatchParams(pms.param)) {
            return pms.pointMatches;
        }
        return null;
    }

    public static boolean serialize(Object ob, String path) {
        try {
            File fdir = new File(path).getParentFile();
            if (null == fdir) {
                return false;
            }
            fdir.mkdirs();
            if (!fdir.exists()) {
                IJ.log((String)("Could not create folder " + fdir.getAbsolutePath()));
                return false;
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(path));
            out.writeObject(ob);
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Object deserialize(String path) {
        try {
            if (!new File(path).exists()) {
                return null;
            }
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
            Object ob = in.readObject();
            in.close();
            return ob;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static final class Param
    implements Serializable {
        private static final long serialVersionUID = -4602300995235309506L;
        public String outputPath = "";
        public final FloatArray2DSIFT.Param sift = new FloatArray2DSIFT.Param();
        public int maxNumThreadsSift = Runtime.getRuntime().availableProcessors();
        public float rod = 0.92f;
        public float maxEpsilon = 25.0f;
        public float minInlierRatio = 0.1f;
        public int minNumInliers = 7;
        public static final String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine", "Perspective"};
        public int modelIndex = 1;
        public int maxImageSize = 1024;
        public float minR = 0.8f;
        public float maxCurvatureR = 3.0f;
        public float rodR = 0.8f;
        public boolean useLocalSmoothnessFilter = true;
        public int localModelIndex = 1;
        public float localRegionSigma = this.maxEpsilon / 4.0f;
        public float maxLocalEpsilon = this.maxEpsilon / 4.0f;
        public float maxLocalTrust = 3.0f;
        public int modelIndexOptimize = 1;
        public int maxIterationsOptimize = 1000;
        public int maxPlateauwidthOptimize = 200;
        public int resolutionSpringMesh = 16;
        public double stiffnessSpringMesh = 0.1;
        public double dampSpringMesh = 0.9;
        public double maxStretchSpringMesh = 2000.0;
        public int maxIterationsSpringMesh = 1000;
        public int maxPlateauwidthSpringMesh = 200;
        public boolean interpolate = true;
        public boolean visualize = true;
        public int resolutionOutput = 128;
        public boolean rgbWithGreenBackground = false;
        public boolean clearCache = true;
        public int maxNumThreads = Runtime.getRuntime().availableProcessors();

        private Param() {
        }

        public boolean setup() {
            DirectoryChooser.setDefaultDirectory((String)this.outputPath);
            DirectoryChooser dc = new DirectoryChooser("Elastically montage stack: Output directory");
            this.outputPath = dc.getDirectory();
            if (this.outputPath == null) {
                this.outputPath = "";
                return false;
            }
            File d = new File(this.outputPath);
            if (!d.exists() || !d.isDirectory()) {
                return false;
            }
            this.outputPath = this.outputPath + "/";
            GenericDialog gdOutput = new GenericDialog("Elastically montage stack: Output");
            gdOutput.addCheckbox("interpolate", this.interpolate);
            gdOutput.addCheckbox("visualize", this.visualize);
            gdOutput.addNumericField("resolution :", (double)this.resolutionOutput, 0);
            gdOutput.addCheckbox("render RGB with green background", this.rgbWithGreenBackground);
            gdOutput.showDialog();
            if (gdOutput.wasCanceled()) {
                return false;
            }
            this.interpolate = gdOutput.getNextBoolean();
            this.visualize = gdOutput.getNextBoolean();
            this.resolutionOutput = (int)gdOutput.getNextNumber();
            this.rgbWithGreenBackground = gdOutput.getNextBoolean();
            GenericDialog gd = new GenericDialog("Elastically montage stack: SIFT parameters");
            SIFT.addFields((GenericDialog)gd, (FloatArray2DSIFT.Param)this.sift);
            gd.addNumericField("closest/next_closest_ratio :", (double)this.rod, 2);
            gd.addMessage("Geometric Consensus Filter:");
            gd.addNumericField("maximal_alignment_error :", (double)this.maxEpsilon, 2, 6, "px");
            gd.addNumericField("minimal_inlier_ratio :", (double)this.minInlierRatio, 2);
            gd.addNumericField("minimal_number_of_inliers :", (double)this.minNumInliers, 0);
            gd.addChoice("approximate_transformation :", modelStrings, modelStrings[this.modelIndex]);
            gd.addMessage("Miscellaneous:");
            gd.addCheckbox("clear_cache", this.clearCache);
            gd.addNumericField("feature_extraction_threads :", (double)this.maxNumThreadsSift, 0);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            SIFT.readFields((GenericDialog)gd, (FloatArray2DSIFT.Param)this.sift);
            this.rod = (float)gd.getNextNumber();
            this.maxEpsilon = (float)gd.getNextNumber();
            this.minInlierRatio = (float)gd.getNextNumber();
            this.minNumInliers = (int)gd.getNextNumber();
            this.modelIndex = gd.getNextChoiceIndex();
            this.clearCache = gd.getNextBoolean();
            this.maxNumThreadsSift = (int)gd.getNextNumber();
            GenericDialog gdBlockMatching = new GenericDialog("Elastically montage stack: Block Matching parameters");
            gdBlockMatching.addMessage("Block Matching:");
            gdBlockMatching.addNumericField("maximal_image_size :", (double)this.maxImageSize, 0, 6, "px");
            gdBlockMatching.addNumericField("resolution :", (double)this.resolutionSpringMesh, 0);
            gdBlockMatching.addMessage("Correlation Filters:");
            gdBlockMatching.addNumericField("minimal_PMCC_r :", (double)this.minR, 2);
            gdBlockMatching.addNumericField("maximal_curvature_ratio :", (double)this.maxCurvatureR, 2);
            gdBlockMatching.addNumericField("maximal_second_best_r/best_r :", (double)this.rodR, 2);
            gdBlockMatching.addMessage("Local Smoothness Filter:");
            gdBlockMatching.addCheckbox("use_local_smoothness_filter", this.useLocalSmoothnessFilter);
            gdBlockMatching.addChoice("approximate_local_transformation :", modelStrings, modelStrings[this.localModelIndex]);
            gdBlockMatching.addNumericField("local_region_sigma:", (double)this.localRegionSigma, 2, 6, "px");
            gdBlockMatching.addNumericField("maximal_local_displacement (absolute):", (double)this.maxLocalEpsilon, 2, 6, "px");
            gdBlockMatching.addNumericField("maximal_local_displacement (relative):", (double)this.maxLocalTrust, 2);
            gdBlockMatching.showDialog();
            if (gdBlockMatching.wasCanceled()) {
                return false;
            }
            this.maxImageSize = (int)gdBlockMatching.getNextNumber();
            this.resolutionSpringMesh = (int)gdBlockMatching.getNextNumber();
            this.minR = (float)gdBlockMatching.getNextNumber();
            this.maxCurvatureR = (float)gdBlockMatching.getNextNumber();
            this.rodR = (float)gdBlockMatching.getNextNumber();
            this.useLocalSmoothnessFilter = gdBlockMatching.getNextBoolean();
            this.localModelIndex = gdBlockMatching.getNextChoiceIndex();
            this.localRegionSigma = (float)gdBlockMatching.getNextNumber();
            this.maxLocalEpsilon = (float)gdBlockMatching.getNextNumber();
            this.maxLocalTrust = (float)gdBlockMatching.getNextNumber();
            GenericDialog gdOptimize = new GenericDialog("Elastically montage stack: Optimization");
            gdOptimize.addMessage("Approximate Optimizer:");
            gdOptimize.addChoice("approximate_transformation :", modelStrings, modelStrings[this.modelIndexOptimize]);
            gdOptimize.addNumericField("maximal_iterations :", (double)this.maxIterationsOptimize, 0);
            gdOptimize.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthOptimize, 0);
            gdOptimize.addMessage("Spring Mesh:");
            gdOptimize.addNumericField("stiffness :", this.stiffnessSpringMesh, 2);
            gdOptimize.addNumericField("maximal_stretch :", this.maxStretchSpringMesh, 2, 6, "px");
            gdOptimize.addNumericField("maximal_iterations :", (double)this.maxIterationsSpringMesh, 0);
            gdOptimize.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthSpringMesh, 0);
            gdOptimize.showDialog();
            if (gdOptimize.wasCanceled()) {
                return false;
            }
            this.modelIndexOptimize = gdOptimize.getNextChoiceIndex();
            this.maxIterationsOptimize = (int)gdOptimize.getNextNumber();
            this.maxPlateauwidthOptimize = (int)gdOptimize.getNextNumber();
            this.stiffnessSpringMesh = gdOptimize.getNextNumber();
            this.maxStretchSpringMesh = gdOptimize.getNextNumber();
            this.maxIterationsSpringMesh = (int)gdOptimize.getNextNumber();
            this.maxPlateauwidthSpringMesh = (int)gdOptimize.getNextNumber();
            return true;
        }

        public boolean equalSiftPointMatchParams(Param param) {
            return this.sift.equals(param.sift) && this.maxEpsilon == param.maxEpsilon && this.minInlierRatio == param.minInlierRatio && this.minNumInliers == param.minNumInliers && this.modelIndex == param.modelIndex;
        }
    }

    private static final class Triple<A, B, C> {
        public final A a;
        public final B b;
        public final C c;

        Triple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    private static final class Features
    implements Serializable {
        private static final long serialVersionUID = 2689219384710526198L;
        final FloatArray2DSIFT.Param param;
        final ArrayList<Feature> features;

        Features(FloatArray2DSIFT.Param p, ArrayList<Feature> features) {
            this.param = p;
            this.features = features;
        }
    }

    private static final class PointMatches
    implements Serializable {
        private static final long serialVersionUID = -2564147268101223484L;
        Param param;
        ArrayList<PointMatch> pointMatches;

        PointMatches(Param p, ArrayList<PointMatch> pointMatches) {
            this.param = p;
            this.pointMatches = pointMatches;
        }
    }
}

