/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.util.Collection;
import mpicbg.ij.stack.InverseTransformMapping;
import mpicbg.models.AbstractModel;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class AlignStacksWithLandmarks
implements PlugIn {
    public static final <M extends AbstractModel<M>> ImagePlus createAlignedStack(ImagePlus source, ImagePlus target, Collection<PointMatch> pointMatches, M model) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        ImageStack sourceStack = source.getStack();
        ImageStack targetStack = new ImageStack(target.getWidth(), target.getHeight());
        model.fit(pointMatches);
        InverseTransformMapping mapping = new InverseTransformMapping(model);
        ImageProcessor ipSource = sourceStack.getProcessor(1);
        for (int i = 0; i < target.getNSlices(); ++i) {
            ImageProcessor ip = ipSource.createProcessor(target.getWidth(), target.getHeight());
            mapping.setSlice((float)i);
            mapping.mapInterpolated(sourceStack, ip);
            targetStack.addSlice("" + i, ip);
            IJ.showProgress((int)i, (int)target.getNSlices());
        }
        ImagePlus alignedTarget = source.createImagePlus();
        alignedTarget.setTitle(source.getTitle() + " aligned");
        alignedTarget.setStack(targetStack, source.getNChannels(), target.getNSlices(), source.getNFrames());
        alignedTarget.setCalibration(target.getCalibration().copy());
        return alignedTarget;
    }

    public void run(String arg0) {
    }
}

