/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Canvas;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import mpicbg.ij.stack.InverseTransformMapping;
import mpicbg.models.AffineModel3D;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.InvertibleCoordinateTransformList;
import mpicbg.models.TranslationModel3D;

public class Stack_Rotate
implements PlugIn,
KeyListener,
AdjustmentListener,
MouseWheelListener,
MouseListener,
MouseMotionListener {
    private static final String NL = System.getProperty("line.separator");
    private ImagePlus imp;
    private ImageProcessor ip;
    private ImageStack stack;
    private GUI gui;
    private final InvertibleCoordinateTransformList<InvertibleCoordinateTransform> ictl = new InvertibleCoordinateTransformList();
    private final AffineModel3D rotation = new AffineModel3D();
    private final AffineModel3D mouseRotation = new AffineModel3D();
    private static final double step = Math.PI / 180;
    private final TranslationModel3D sliceShift = new TranslationModel3D();
    private final AffineModel3D reducedAffine = new AffineModel3D();
    private final InverseTransformMapping<AffineModel3D> mapping = new InverseTransformMapping((InverseCoordinateTransform)this.reducedAffine);
    private double zScale;
    private int axis = 0;
    private double currentSlice = 0.0;
    private int oX;
    private int oY;
    private int dX;
    private int dY;
    private MappingThread painter;

    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp == null || this.imp.getStackSize() == 1) {
            IJ.error((String)"This is not a stack.");
            return;
        }
        this.ictl.clear();
        try {
            this.gui = new GUI(this.imp);
        }
        catch (ClassCastException e) {
            StackTraceElement[] stackTraceElements;
            IJ.log((String)"Could not acquire GUI.  Probably, the AWT components of the stack window changed.  Write an e-mail to saalfed@mpi-cbg.de to fix this.");
            for (StackTraceElement stackTraceElement : stackTraceElements = e.getStackTrace()) {
                IJ.log((String)stackTraceElement.toString());
            }
        }
        Calibration c = this.imp.getCalibration();
        this.zScale = c.pixelDepth / c.pixelWidth;
        this.stack = this.imp.getStack();
        this.currentSlice = (double)(this.imp.getCurrentSlice() - 1) * this.zScale;
        int w = this.stack.getWidth();
        int h = this.stack.getHeight();
        int d = this.stack.getSize();
        this.ip = this.stack.getProcessor((int)(this.currentSlice / this.zScale + 1.5)).duplicate();
        AffineModel3D unScale = new AffineModel3D();
        unScale.set(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, this.zScale, 0.0);
        this.sliceShift.set(0.0, 0.0, -this.currentSlice);
        TranslationModel3D centerShift = new TranslationModel3D();
        centerShift.set((double)(-w / 2), (double)(-h / 2), (double)(-d / 2) * this.zScale);
        TranslationModel3D centerUnShift = new TranslationModel3D();
        centerUnShift.set((double)(w / 2), (double)(h / 2), (double)(d / 2) * this.zScale);
        this.rotation.set(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        this.ictl.add((InvertibleCoordinateTransform)unScale);
        this.ictl.add((InvertibleCoordinateTransform)centerShift);
        this.ictl.add((InvertibleCoordinateTransform)this.rotation);
        this.ictl.add((InvertibleCoordinateTransform)centerUnShift);
        this.ictl.add((InvertibleCoordinateTransform)this.sliceShift);
        Stack_Rotate.reduceAffineTransformList(this.ictl, this.reducedAffine);
        this.imp.setProcessor(this.imp.getTitle(), this.ip);
        this.gui.backupGui();
        this.gui.takeOverGui();
        this.painter = new MappingThread(this.stack, this.ip, true);
        this.painter.start();
    }

    private final void updateScrollBar() {
        double[] min = new double[]{0.0, 0.0, 0.0};
        double[] max = new double[]{this.stack.getWidth() - 1, this.stack.getHeight() - 1, this.stack.getSize() - 1};
        this.reducedAffine.estimateBounds(min, max);
        min[2] = min[2] + this.currentSlice;
        max[2] = max[2] + this.currentSlice;
        this.gui.scrollBar.setValues((int)Math.round(this.currentSlice), 1, (int)Math.round(min[2]), (int)Math.round(max[2]));
    }

    private final void update() {
        Stack_Rotate.reduceAffineTransformList(this.ictl, this.reducedAffine);
        this.painter.repaint();
    }

    private final void apply() {
        new Thread(new Runnable(){

            @Override
            public final void run() {
                Stack_Rotate.this.imp.lock();
                AffineModel3D a = new AffineModel3D();
                a.preConcatenate((AffineModel3D)Stack_Rotate.this.ictl.get(0));
                a.preConcatenate((TranslationModel3D)Stack_Rotate.this.ictl.get(1));
                a.preConcatenate((AffineModel3D)Stack_Rotate.this.ictl.get(2));
                a.preConcatenate((TranslationModel3D)Stack_Rotate.this.ictl.get(3));
                double[] min = new double[]{0.0, 0.0, 0.0};
                double[] max = new double[]{Stack_Rotate.this.stack.getWidth(), Stack_Rotate.this.stack.getHeight(), Stack_Rotate.this.stack.getSize()};
                a.estimateBounds(min, max);
                int w = (int)Math.ceil(max[0] - min[0]);
                int h = (int)Math.ceil(max[1] - min[1]);
                int d = (int)Math.ceil(max[2] - min[2]);
                TranslationModel3D minShift = new TranslationModel3D();
                minShift.set(-min[0], -min[1], -min[2]);
                a.preConcatenate(minShift);
                TranslationModel3D sliceOffset = new TranslationModel3D();
                sliceOffset.set(0.0, 0.0, -1.0);
                InverseTransformMapping aMapping = new InverseTransformMapping((InverseCoordinateTransform)a);
                ImageProcessor source = Stack_Rotate.this.stack.getProcessor(1);
                ImageStack result = new ImageStack((int)Math.ceil(w), (int)Math.ceil(h));
                for (int i = 0; i <= d; ++i) {
                    ImageProcessor ipSlice = source.createProcessor(w, h);
                    aMapping.mapInterpolated(Stack_Rotate.this.stack, ipSlice);
                    result.addSlice("" + i, ipSlice);
                    a.preConcatenate(sliceOffset);
                    IJ.showProgress((int)i, (int)d);
                }
                Calibration resultCalibration = Stack_Rotate.this.imp.getCalibration().copy();
                resultCalibration.pixelDepth = resultCalibration.pixelWidth;
                Stack_Rotate.this.gui.restoreGui();
                Stack_Rotate.this.imp.setStack(Stack_Rotate.this.imp.getTitle(), result);
                ((StackWindow)Stack_Rotate.this.imp.getWindow()).updateSliceSelector();
                Stack_Rotate.this.imp.setCalibration(resultCalibration);
                Stack_Rotate.this.imp.updateAndDraw();
                Stack_Rotate.this.imp.unlock();
            }
        }).start();
    }

    private void rotate(int a, double d) {
        this.rotation.rotate(a, d * (Math.PI / 180));
    }

    private final void shift(double d) {
        this.currentSlice += d;
        this.sliceShift.set(0.0, 0.0, -this.currentSlice);
    }

    private static final void reduceAffineTransformList(InvertibleCoordinateTransformList<?> ictl, AffineModel3D affine) {
        AffineModel3D a = new AffineModel3D();
        for (InvertibleCoordinateTransform t : ictl.getList(null)) {
            if (AffineModel3D.class.isInstance(t)) {
                a.preConcatenate((AffineModel3D)t);
                continue;
            }
            if (!TranslationModel3D.class.isInstance(t)) continue;
            a.preConcatenate((TranslationModel3D)t);
        }
        affine.set(a);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.painter.interrupt();
            if (this.imp != null) {
                if (e.getKeyCode() == 27) {
                    this.imp.setStack(this.imp.getTitle(), this.stack);
                    this.gui.restoreGui();
                } else if (e.getKeyCode() == 10) {
                    this.gui.clearGui();
                    this.apply();
                }
            }
        } else if (e.getKeyCode() == 16) {
            this.oX -= 9 * this.dX / 10;
            this.oY -= 9 * this.dY / 10;
        } else if (e.getKeyCode() == 17) {
            this.oX += 9 * this.dX;
            this.oY += 9 * this.dY;
        } else if (e.getKeyCode() == 88) {
            this.axis = 0;
        } else if (e.getKeyCode() == 89) {
            this.axis = 1;
        } else if (e.getKeyCode() == 90) {
            this.axis = 2;
        } else {
            double v = this.keyModfiedSpeed(e.getModifiersEx());
            if (e.getKeyCode() == 37) {
                this.rotate(this.axis, -v);
                this.updateScrollBar();
                this.update();
            } else if (e.getKeyCode() == 39) {
                this.rotate(this.axis, v);
                this.updateScrollBar();
                this.update();
            } else if (e.getKeyCode() == 44) {
                this.shift(-v);
                this.gui.scrollBar.setValue((int)Math.round(this.currentSlice));
                this.update();
            } else if (e.getKeyCode() == 46) {
                this.shift(v);
                this.gui.scrollBar.setValue((int)Math.round(this.currentSlice));
                this.update();
            } else if (e.getKeyCode() == 73) {
                this.painter.toggleInterpolation();
                this.update();
            } else if (e.getKeyCode() == 69) {
                IJ.log((String)this.rotation.toString());
            } else if (e.getKeyCode() == 84) {
                GenericDialog gd = new GenericDialog("Define Rotation Matrix");
                double[] m = this.rotation.getMatrix(null);
                gd.addNumericField("m00", m[0], 5);
                gd.addNumericField("m01", m[1], 5);
                gd.addNumericField("m02", m[2], 5);
                gd.addNumericField("m10", m[4], 5);
                gd.addNumericField("m11", m[5], 5);
                gd.addNumericField("m12", m[6], 5);
                gd.addNumericField("m20", m[8], 5);
                gd.addNumericField("m21", m[9], 5);
                gd.addNumericField("m22", m[10], 5);
                gd.showDialog();
                if (!gd.wasCanceled()) {
                    m[0] = gd.getNextNumber();
                    m[1] = gd.getNextNumber();
                    m[2] = gd.getNextNumber();
                    m[4] = gd.getNextNumber();
                    m[5] = gd.getNextNumber();
                    m[6] = gd.getNextNumber();
                    m[8] = gd.getNextNumber();
                    m[9] = gd.getNextNumber();
                    m[10] = gd.getNextNumber();
                    this.rotation.set(m[0], m[1], m[2], 0.0, m[4], m[5], m[6], 0.0, m[8], m[9], m[10], 0.0);
                    Stack_Rotate.reduceAffineTransformList(this.ictl, this.reducedAffine);
                    this.updateScrollBar();
                    this.painter.repaint();
                }
            } else if (e.getKeyCode() == 112) {
                IJ.showMessage((String)"Interactive Stack Rotation", (String)("Mouse control:" + NL + " " + NL + "Pan and tilt the stack by dragging the image in the canvas and" + NL + "browse alongside the z-axis using the mouse-wheel and the slice bar." + NL + " " + NL + "Key control:" + NL + " " + NL + "X - Select x-axis as rotation axis." + NL + "Y - Select y-axis as rotation axis." + NL + "Z - Select z-axis as rotation axis." + NL + "CURSOR LEFT - Rotate counter-clockwise around the choosen rotation axis." + NL + "CURSOR RIGHT - Rotate clockwise around the choosen rotation axis." + NL + "./> - Forward alongside z-axis." + NL + ",/< - Backward alongside z-axis." + NL + "SHIFT - Rotate and browse 10x faster." + NL + "CTRL - Rotate and browse 10x slower." + NL + "CURSOR RIGHT - Rotate clockwise around the choosen rotation axis." + NL + "ENTER - Apply the rotation and render the full stack." + NL + "ESC - Return to the original stack." + NL + "I - Toggle interpolation." + NL + "E - Export the current rotation to the log window." + NL + "T - Define affine transformation matrix"));
            }
        }
    }

    private final double keyModfiedSpeed(int modifiers) {
        if ((modifiers & 0x40) != 0) {
            return 10.0;
        }
        if ((modifiers & 0x80) != 0) {
            return 0.1;
        }
        return 1.0;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.oX += 9 * this.dX;
            this.oY += 9 * this.dY;
        } else if (e.getKeyCode() == 17) {
            this.oX -= 9 * this.dX / 10;
            this.oY -= 9 * this.dY / 10;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta (right button) ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        if ((s = s + "]").equals(" [ ]")) {
            s = " [no modifiers]";
        }
        return s;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.currentSlice = e.getValue();
        this.sliceShift.set(0.0, 0.0, -this.currentSlice);
        this.update();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double v = this.keyModfiedSpeed(e.getModifiersEx());
        int s = e.getWheelRotation();
        this.shift(v * (double)s);
        this.gui.scrollBar.setValue((int)Math.round(this.currentSlice));
        this.update();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double v = 0.17453292519943295 * this.keyModfiedSpeed(e.getModifiersEx());
        this.dX = this.oX - e.getX();
        this.dY = this.oY - e.getY();
        this.rotation.set(this.mouseRotation);
        this.rotate(0, (double)this.dY * v);
        this.rotate(1, (double)this.dX * v);
        this.updateScrollBar();
        this.update();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.oX = e.getX();
        this.oY = e.getY();
        this.mouseRotation.set(this.rotation);
    }

    private final class GUI {
        private final ImageWindow window;
        private final Canvas canvas;
        private final Scrollbar scrollBar;
        private final int scrollBarValue;
        private final int scrollBarVisible;
        private final int scrollBarMin;
        private final int scrollBarMax;
        private final ImageJ ij;
        private KeyListener[] windowKeyListeners;
        private KeyListener[] canvasKeyListeners;
        private KeyListener[] ijKeyListeners;
        private MouseListener[] canvasMouseListeners;
        private MouseMotionListener[] canvasMouseMotionListeners;
        private MouseWheelListener[] windowMouseWheelListeners;
        private AdjustmentListener[] scrollBarAdjustmentListeners;

        GUI(ImagePlus imp) {
            this.window = imp.getWindow();
            this.canvas = imp.getCanvas();
            this.scrollBar = (Scrollbar)((Panel)this.window.getComponent(1)).getComponent(1);
            this.scrollBarValue = this.scrollBar.getValue();
            this.scrollBarVisible = this.scrollBar.getVisibleAmount();
            this.scrollBarMin = this.scrollBar.getMinimum();
            this.scrollBarMax = this.scrollBar.getMaximum();
            this.ij = IJ.getInstance();
        }

        final void takeOverGui() {
            this.canvas.addKeyListener(Stack_Rotate.this);
            this.window.addKeyListener((KeyListener)Stack_Rotate.this);
            this.canvas.addMouseMotionListener(Stack_Rotate.this);
            this.canvas.addMouseListener(Stack_Rotate.this);
            this.ij.addKeyListener((KeyListener)Stack_Rotate.this);
            this.window.addMouseWheelListener((MouseWheelListener)Stack_Rotate.this);
            this.scrollBar.addAdjustmentListener(Stack_Rotate.this);
            Stack_Rotate.this.updateScrollBar();
        }

        final void backupGui() {
            this.canvasKeyListeners = this.canvas.getKeyListeners();
            this.windowKeyListeners = this.window.getKeyListeners();
            this.ijKeyListeners = IJ.getInstance().getKeyListeners();
            this.canvasMouseListeners = this.canvas.getMouseListeners();
            this.canvasMouseMotionListeners = this.canvas.getMouseMotionListeners();
            this.windowMouseWheelListeners = this.window.getMouseWheelListeners();
            this.scrollBarAdjustmentListeners = this.scrollBar.getAdjustmentListeners();
            this.clearGui();
        }

        final void restoreGui() {
            this.clearGui();
            for (KeyListener keyListener : this.canvasKeyListeners) {
                this.canvas.addKeyListener(keyListener);
            }
            for (KeyListener keyListener : this.windowKeyListeners) {
                this.window.addKeyListener(keyListener);
            }
            for (KeyListener keyListener : this.ijKeyListeners) {
                this.ij.addKeyListener(keyListener);
            }
            for (EventListener eventListener : this.canvasMouseListeners) {
                this.canvas.addMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : this.canvasMouseMotionListeners) {
                this.canvas.addMouseMotionListener((MouseMotionListener)eventListener);
            }
            for (EventListener eventListener : this.windowMouseWheelListeners) {
                this.window.addMouseWheelListener((MouseWheelListener)eventListener);
            }
            for (EventListener eventListener : this.scrollBarAdjustmentListeners) {
                this.scrollBar.addAdjustmentListener((AdjustmentListener)eventListener);
            }
            this.scrollBar.setValues(this.scrollBarValue, this.scrollBarVisible, this.scrollBarMin, this.scrollBarMax);
        }

        final void clearGui() {
            for (KeyListener keyListener : this.canvasKeyListeners) {
                this.canvas.removeKeyListener(keyListener);
            }
            for (KeyListener keyListener : this.windowKeyListeners) {
                this.window.removeKeyListener(keyListener);
            }
            for (KeyListener keyListener : this.ijKeyListeners) {
                this.ij.removeKeyListener(keyListener);
            }
            for (EventListener eventListener : this.canvasMouseListeners) {
                this.canvas.removeMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : this.canvasMouseMotionListeners) {
                this.canvas.removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            for (EventListener eventListener : this.windowMouseWheelListeners) {
                this.window.removeMouseWheelListener((MouseWheelListener)eventListener);
            }
            for (EventListener eventListener : this.scrollBarAdjustmentListeners) {
                this.scrollBar.removeAdjustmentListener((AdjustmentListener)eventListener);
            }
            this.canvas.removeKeyListener(Stack_Rotate.this);
            this.window.removeKeyListener((KeyListener)Stack_Rotate.this);
            this.ij.removeKeyListener((KeyListener)Stack_Rotate.this);
            this.canvas.removeMouseListener(Stack_Rotate.this);
            this.canvas.removeMouseMotionListener(Stack_Rotate.this);
            this.window.removeMouseWheelListener((MouseWheelListener)Stack_Rotate.this);
            this.scrollBar.removeAdjustmentListener(Stack_Rotate.this);
        }
    }

    public class MappingThread
    extends Thread {
        protected final ImageStack source;
        protected final ImageProcessor target;
        protected final ImageProcessor temp;
        protected boolean interpolate;
        private boolean pleaseRepaint;

        public MappingThread(ImageStack source, ImageProcessor target, boolean interpolate) {
            this.source = source;
            this.target = target;
            this.temp = target.createProcessor(target.getWidth(), target.getHeight());
            this.temp.snapshot();
            this.interpolate = interpolate;
            this.setName("MappingThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                boolean b;
                MappingThread mappingThread = this;
                synchronized (mappingThread) {
                    b = this.pleaseRepaint;
                    this.pleaseRepaint = false;
                }
                if (b) {
                    this.temp.reset();
                    if (this.interpolate) {
                        Stack_Rotate.this.mapping.mapInterpolated(this.source, this.temp);
                    } else {
                        Stack_Rotate.this.mapping.map(this.source, this.temp);
                    }
                    Object targetPixels = this.target.getPixels();
                    this.target.setPixels(this.temp.getPixels());
                    this.temp.setPixels(targetPixels);
                    Stack_Rotate.this.imp.updateImage();
                    Stack_Rotate.this.imp.draw();
                }
                mappingThread = this;
                synchronized (mappingThread) {
                    block12: {
                        try {
                            if (this.pleaseRepaint) break block12;
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaint() {
            MappingThread mappingThread = this;
            synchronized (mappingThread) {
                this.pleaseRepaint = true;
                this.notify();
            }
        }

        public void toggleInterpolation() {
            this.interpolate = !this.interpolate;
        }
    }
}

