/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.ImageMetadata;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.cell.loaders.AbstractArrayLoader;
import io.scif.util.FormatTools;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.numeric.real.FloatType;

public class FloatArrayLoader
extends AbstractArrayLoader<FloatArray> {
    public FloatArrayLoader(Reader reader, ImageRegion subRegion) {
        super(reader, subRegion);
    }

    @Override
    public void convertBytes(FloatArray data, byte[] bytes, int planesRead) {
        ImageMetadata iMeta = this.reader().getMetadata().get(0);
        if (this.isCompatible()) {
            int bpp = this.getBitsPerElement() / 8;
            int offset = planesRead * (bytes.length / bpp);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(iMeta.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            bb.asFloatBuffer().get(data.getCurrentStorageArray(), offset, bytes.length / bpp);
        } else {
            int pixelType = iMeta.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            int offset = planesRead * (bytes.length / bpp);
            for (int index = 0; index < bytes.length / bpp; ++index) {
                float value = (float)this.utils().decodeWord(bytes, index * bpp, pixelType, iMeta.isLittleEndian());
                data.setValue(offset + index, value);
            }
        }
    }

    @Override
    public FloatArray emptyArray(int entities) {
        return new FloatArray(entities);
    }

    @Override
    public int getBitsPerElement() {
        return 32;
    }

    @Override
    public Class<?> outputClass() {
        return FloatType.class;
    }
}

