/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.cli.CLIUtils;
import fiji.util.gui.GenericDialogPlus;
import javax.swing.JLabel;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;

@Plugin(type=Command.class, label="Configure the path to the Conda executable used in TrackMate...", iconPath="/icons/commands/information.png", menuPath="Edit >  Options > Configure TrackMate Conda path...")
public class CondaPathConfigCommand
implements Command {
    public void run() {
        String findPath;
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        try {
            findPath = CLIUtils.findDefaultCondaPath();
        }
        catch (IllegalArgumentException e) {
            findPath = "/usr/local/opt/micromamba/bin/micromamba";
        }
        String condaPath = prefs.get(CLIUtils.class, "trackmate.conda.path", findPath);
        GenericDialogPlus dialog = new GenericDialogPlus("TrackMate Conda path");
        JLabel lbl = dialog.addImage(GuiUtils.scaleImage(Icons.TRACKMATE_ICON, 64, 64));
        lbl.setText("TrackMate Conda path");
        lbl.setFont(Fonts.BIG_FONT);
        dialog.addMessage("Browse to the conda (or mamba, micromaba, ...) executable \nto use in the TrackMate modules that rely on Conda.");
        dialog.addMessage("Conda executable path:");
        dialog.addFileField("", condaPath, 40);
        dialog.showDialog();
        if (dialog.wasCanceled()) {
            return;
        }
        condaPath = dialog.getNextString();
        prefs.put(CLIUtils.class, "trackmate.conda.path", condaPath);
    }

    public static void main(String[] args) {
        ((CommandService)TMUtils.getContext().getService(CommandService.class)).run(CondaPathConfigCommand.class, false, new Object[0]);
    }
}

