/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.util.cli.CLIConfigurator;
import java.io.File;

public abstract class CommandCLIConfigurator
extends CLIConfigurator {
    protected final ExecutablePath executable = new ExecutablePath();

    protected CommandCLIConfigurator() {
    }

    public ExecutablePath getCommandArg() {
        return this.executable;
    }

    protected String checkExecutable() {
        if (!this.executable.isSet()) {
            return "Executable path is not set.\n";
        }
        String path = (String)this.executable.getValue();
        File file = new File(path);
        if (!file.exists()) {
            return "Executable path " + path + " does not exist.\n";
        }
        if (!file.canExecute()) {
            return "Executable " + path + " cannot be run.\n";
        }
        return null;
    }

    @Override
    public String check() {
        String out = this.checkExecutable();
        if (out != null) {
            return out;
        }
        return super.check();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.executable.toString());
        str.append(super.toString() + "\n");
        return str.toString();
    }

    public static class ExecutablePath
    extends CLIConfigurator.AbstractStringArgument<ExecutablePath> {
        @Override
        public ExecutablePath name(String name) {
            return (ExecutablePath)super.name(name);
        }

        @Override
        public ExecutablePath help(String help) {
            return (ExecutablePath)super.help(help);
        }

        @Override
        public ExecutablePath key(String key) {
            return (ExecutablePath)super.key(key);
        }

        @Override
        public void accept(CLIConfigurator.ArgumentVisitor visitor) {
            visitor.visit(this);
        }
    }
}

