/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.util.TMUtils;
import ij.IJ;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.scijava.prefs.PrefService;

public class CLIUtils {
    public static final String CONDA_PATH_PREF_KEY = "trackmate.conda.path";

    public static Map<String, String> getEnvMap() {
        HashMap<String, String> envMap = new HashMap<String, String>();
        try {
            String line;
            ProcessBuilder pb = IJ.isWindows() ? new ProcessBuilder(Arrays.asList("cmd.exe", "/c", "conda", "env", "list")) : new ProcessBuilder(Arrays.asList(CLIUtils.getCondaPath(), "env", "list"));
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("Name") || (parts = line.split("\\s+")).length < 2) continue;
                String envName = parts[0];
                String envPath = parts[1] + "/bin/python";
                envMap.put(envName, envPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return envMap;
    }

    public static List<String> getEnvList() {
        ArrayList<String> l = new ArrayList<String>(CLIUtils.getEnvMap().keySet());
        l.sort(null);
        return l;
    }

    public static String getCondaPath() {
        String findPath;
        if (IJ.isWindows()) {
            return "conda";
        }
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        try {
            findPath = CLIUtils.findDefaultCondaPath();
        }
        catch (IllegalArgumentException e) {
            findPath = "/usr/local/opt/micromamba/bin/micromamba";
        }
        return prefs.get(CLIUtils.class, CONDA_PATH_PREF_KEY, findPath);
    }

    public static String findDefaultCondaPath() throws IllegalArgumentException {
        String[] toTest;
        String username = System.getProperty("user.name");
        String prefix = IJ.isMacOSX() ? "/Users/" : "/home/";
        String anaconda1 = prefix + username + "/anaconda3/bin/conda";
        String anaconda2 = "/opt/anaconda3/bin/conda";
        String miniconda1 = prefix + username + "/miniconda3/bin/conda";
        String miniconda2 = "/opt/miniconda3/bin/conda";
        String mamba1 = prefix + username + "/mamba/bin/mamba";
        String mamba2 = "/opt/mamba/bin/mamba";
        String micromamba1 = prefix + username + (IJ.isMacOSX() ? "/Library/micromamba/bin/micromamba" : "/.local/share/micromamba/bin/micromamba");
        String micromamba2 = "/usr/local/micromamba/bin/micromamba";
        String micromamba3 = "/usr/local/opt/micromamba/bin/micromamba";
        String micromamba4 = "/opt/micromamba/bin/micromamba";
        for (String str : toTest = new String[]{anaconda1, "/opt/anaconda3/bin/conda", miniconda1, "/opt/miniconda3/bin/conda", mamba1, "/opt/mamba/bin/mamba", micromamba1, "/usr/local/micromamba/bin/micromamba", "/usr/local/opt/micromamba/bin/micromamba", "/opt/micromamba/bin/micromamba"}) {
            Path path = Paths.get(str, new String[0]);
            if (!Files.isExecutable(path)) continue;
            return str;
        }
        throw new IllegalArgumentException("Could not find a conda executable I know of, within: " + Arrays.asList(toTest));
    }

    public static void recursiveDeleteOnShutdownHook(final Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                            if (e == null) {
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                            throw e;
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete " + path, e);
                }
            }
        }));
    }

    public static void main(String[] args) {
        System.out.println("Conda path: " + CLIUtils.findDefaultCondaPath());
        System.out.println("Known environments: " + CLIUtils.getEnvList());
        System.out.println("Paths:");
        CLIUtils.getEnvMap().forEach((k, v) -> System.out.println(k + " -> " + v));
    }

    public static class LoggerTailerListener
    extends TailerListenerAdapter {
        private final Logger logger;
        public Color COLOR = Logger.BLUE_COLOR.darker();
        private static final Pattern PERCENTAGE_PATTERN = Pattern.compile(".+\\D(\\d+(?:\\.\\d+)?)%.+");
        private static final Pattern INFO_PATTERN = Pattern.compile("(.+\\[INFO\\]\\s+(.+)|^INFO:.*$)");

        public LoggerTailerListener(Logger logger) {
            this.logger = logger;
        }

        public void handle(String line) {
            Matcher matcher = PERCENTAGE_PATTERN.matcher(line);
            if (matcher.matches()) {
                String percent = matcher.group(1);
                this.logger.setProgress(Double.valueOf(percent) / 100.0);
            } else {
                Matcher matcher2 = INFO_PATTERN.matcher(line);
                if (matcher2.matches()) {
                    String str = matcher2.group(1).trim();
                    if (str.length() > 2) {
                        this.logger.setStatus(str.replaceAll("\\[INFO\\]", "").replaceAll("INFO:", "").replaceAll("INFO", ""));
                    }
                } else if (!line.trim().isEmpty()) {
                    this.logger.log(" - " + line + '\n', this.COLOR);
                }
            }
        }
    }
}

