/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.components.LogHistogramDataset;
import fiji.plugin.trackmate.gui.components.XYTextSimpleAnnotation;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import fiji.util.NumberParser;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleConsumer;
import javax.swing.JPanel;
import net.imglib2.util.Util;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYDataset;

public class QualityHistogramChart
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color ANNOTATION_COLOR = new Color(252, 117, 0);
    private static final String DATA_SERIES_NAME = "Data";
    private final JFreeChart chart;
    private final XYPlot plot;
    private final XYTextSimpleAnnotation annotation;
    private final IntervalMarker intervalMarker;
    private final ChartPanel chartPanel;
    private double threshold;
    private double autoThreshold = Double.NaN;
    private final DoubleConsumer thresholdSetter;

    public QualityHistogramChart(DoubleConsumer thresholdSetter, String axisLabel) {
        MouseListener[] mls;
        this.thresholdSetter = thresholdSetter;
        this.chart = ChartFactory.createHistogram(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.plot = this.chart.getXYPlot();
        this.threshold = 0.0;
        XYBarRenderer renderer = (XYBarRenderer)this.plot.getRenderer();
        renderer.setShadowVisible(false);
        renderer.setMargin(0.0);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setSeriesOutlinePaint(0, (Paint)Color.BLACK);
        renderer.setSeriesPaint(0, (Paint)new Color(1, 1, 1, 0));
        this.plot.setBackgroundPaint(null);
        this.plot.setOutlineVisible(false);
        this.plot.setDomainCrosshairVisible(false);
        this.plot.setDomainGridlinesVisible(false);
        this.plot.setRangeCrosshairVisible(false);
        this.plot.setRangeGridlinesVisible(false);
        this.plot.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        this.plot.getRangeAxis().setVisible(true);
        this.plot.getRangeAxis().setTickMarksVisible(false);
        this.plot.getRangeAxis().setTickLabelsVisible(false);
        this.plot.getRangeAxis().setLabelPaint((Paint)Logger.NORMAL_COLOR);
        this.plot.getRangeAxis().setLabelFont(Fonts.SMALL_FONT);
        this.plot.getRangeAxis().setLabel(axisLabel == null ? "Quality histogram" : axisLabel);
        this.plot.getRangeAxis().setLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        this.plot.getRangeAxis().setTickLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        this.plot.getRangeAxis().setAxisLineVisible(false);
        this.plot.getDomainAxis().setVisible(true);
        this.plot.getDomainAxis().setTickLabelsVisible(true);
        this.plot.getDomainAxis().setTickLabelPaint((Paint)Logger.NORMAL_COLOR);
        this.plot.getDomainAxis().setTickLabelFont(Fonts.SMALL_FONT);
        ((NumberAxis)this.plot.getDomainAxis()).setNumberFormatOverride((NumberFormat)new DecimalFormat("#.###"));
        this.chart.setBorderVisible(false);
        this.chart.setBackgroundPaint(null);
        this.chartPanel = new ChartPanel(this.chart);
        this.intervalMarker = new IntervalMarker(Double.NEGATIVE_INFINITY, 0.0, (Paint)this.chartPanel.getBackground(), (Stroke)new BasicStroke(), (Paint)this.chartPanel.getForeground(), (Stroke)new BasicStroke(), 0.8f);
        this.annotation = new XYTextSimpleAnnotation(this.chartPanel, true);
        this.annotation.setFont(Fonts.SMALL_FONT);
        this.annotation.setColor(ANNOTATION_COLOR.darker());
        this.plot.setDataset(null);
        this.chartPanel.setVisible(false);
        this.chartPanel.setMinimumDrawHeight(80);
        this.chartPanel.setMinimumDrawWidth(80);
        for (MouseListener ml : mls = this.chartPanel.getMouseListeners()) {
            this.chartPanel.removeMouseListener(ml);
        }
        this.chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QualityHistogramChart.this.chartPanel.requestFocusInWindow();
                if (e.getButton() == 3 && !Double.isNaN(QualityHistogramChart.this.autoThreshold)) {
                    QualityHistogramChart.this.threshold = QualityHistogramChart.this.autoThreshold;
                } else {
                    QualityHistogramChart.this.threshold = QualityHistogramChart.this.getXFromChartEvent(e, QualityHistogramChart.this.chartPanel);
                }
                QualityHistogramChart.this.redrawThresholdMarker();
            }
        });
        this.chartPanel.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                QualityHistogramChart.this.threshold = QualityHistogramChart.this.getXFromChartEvent(e, QualityHistogramChart.this.chartPanel);
                QualityHistogramChart.this.redrawThresholdMarker();
            }
        });
        this.chartPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                QualityHistogramChart.this.moveThreshold(e.getWheelRotation());
            }
        });
        this.chartPanel.setFocusable(true);
        this.chartPanel.addKeyListener((KeyListener)new MyKeyListener());
        this.setLayout(new BorderLayout());
        this.add((Component)this.chartPanel, "Center");
    }

    public void displayHistogram(double[] values) {
        this.displayHistogram(values, Double.NaN);
    }

    public void displayHistogram(double[] values, double threshold) {
        int nBins;
        this.threshold = threshold;
        this.autoThreshold = TMUtils.otsuThreshold(values);
        if (values.length > 0 && (nBins = QualityHistogramChart.getNBins(values, 8, 100)) > 1) {
            LogHistogramDataset dataset = new LogHistogramDataset();
            dataset.addSeries((Comparable)((Object)DATA_SERIES_NAME), values, nBins);
            this.plot.setDataset((XYDataset)dataset);
            this.plot.removeDomainMarker((Marker)this.intervalMarker);
            this.plot.removeAnnotation((XYAnnotation)this.annotation);
            if (!Double.isNaN(threshold)) {
                this.redrawThresholdMarker();
                this.plot.addDomainMarker((Marker)this.intervalMarker);
                this.plot.addAnnotation((XYAnnotation)this.annotation);
            }
            this.chartPanel.setVisible(true);
            return;
        }
        this.chartPanel.setVisible(false);
        this.plot.setDataset(null);
    }

    private double getXFromChartEvent(MouseEvent mouseEvent, ChartPanel chartPanel) {
        Rectangle2D plotArea = chartPanel.getScreenDataArea();
        return this.plot.getDomainAxis().java2DToValue((double)mouseEvent.getX(), plotArea, this.plot.getDomainAxisEdge());
    }

    private void moveThreshold(int amount) {
        if (Double.isNaN(this.threshold)) {
            return;
        }
        this.threshold += (double)amount / 100.0 * this.plot.getDomainAxis().getRange().getLength();
        this.redrawThresholdMarker();
    }

    private void redrawThresholdMarker() {
        if (Double.isNaN(this.threshold)) {
            return;
        }
        this.intervalMarker.setEndValue(this.threshold);
        float x = this.threshold > 0.85 * this.plot.getDomainAxis().getUpperBound() ? (float)(this.threshold - 0.15 * this.plot.getDomainAxis().getRange().getLength()) : (float)(this.threshold + 0.05 * this.plot.getDomainAxis().getRange().getLength());
        float y = (float)(0.85 * this.plot.getRangeAxis().getUpperBound());
        this.annotation.setText(String.format("%.1f", this.threshold));
        this.annotation.setLocation(x, y);
        this.thresholdChanged();
    }

    private void thresholdChanged() {
        if (this.thresholdSetter != null) {
            this.thresholdSetter.accept(this.threshold);
        }
    }

    private static final int getNBins(double[] values, int minBinNumber, int maxBinNumber) {
        double min;
        int size = values.length;
        double q1 = Util.percentile((double[])values, (double)0.25);
        double q3 = Util.percentile((double[])values, (double)0.75);
        double iqr = q3 - q1;
        double binWidth = 2.0 * iqr * Math.pow(size, -0.33);
        double max = Util.max((double[])values);
        double range = max - (min = Util.min((double[])values));
        int nBin = (int)(range / binWidth + 1.0);
        if (nBin > maxBinNumber) {
            nBin = maxBinNumber;
        } else if (nBin < minBinNumber) {
            nBin = minBinNumber;
        }
        return nBin;
    }

    private final class MyKeyListener
    implements KeyListener {
        private static final long WAIT_DELAY = 1L;
        private static final double INCREASE_FACTOR = 0.1;
        private static final double SLOW_INCREASE_FACTOR = 0.005;
        private String strNumber = "";
        private ScheduledExecutorService ex;
        private ScheduledFuture<?> future;
        private boolean dotAdded = false;
        private final Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    double typedThreshold = NumberParser.parseDouble(MyKeyListener.this.strNumber);
                    QualityHistogramChart.this.threshold = typedThreshold;
                    QualityHistogramChart.this.redrawThresholdMarker();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                MyKeyListener.this.ex = null;
                MyKeyListener.this.strNumber = "";
                MyKeyListener.this.dotAdded = false;
            }
        };

        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                QualityHistogramChart.this.threshold = QualityHistogramChart.this.threshold - (e.isControlDown() ? 0.005 : 0.1) * QualityHistogramChart.this.plot.getDomainAxis().getRange().getLength();
                QualityHistogramChart.this.redrawThresholdMarker();
                return;
            }
            if (e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                QualityHistogramChart.this.threshold = QualityHistogramChart.this.threshold + (e.isControlDown() ? 0.005 : 0.1) * QualityHistogramChart.this.plot.getDomainAxis().getRange().getLength();
                QualityHistogramChart.this.redrawThresholdMarker();
                return;
            }
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                QualityHistogramChart.this.threshold = QualityHistogramChart.this.plot.getDomainAxis().getRange().getUpperBound();
                QualityHistogramChart.this.redrawThresholdMarker();
                return;
            }
            if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                QualityHistogramChart.this.threshold = QualityHistogramChart.this.plot.getDomainAxis().getRange().getLowerBound();
                QualityHistogramChart.this.redrawThresholdMarker();
                return;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() < '0' || e.getKeyChar() > '9') {
                if (!this.dotAdded && e.getKeyChar() == '.') {
                    this.dotAdded = true;
                } else {
                    return;
                }
            }
            if (this.ex == null) {
                this.ex = Threads.newSingleThreadScheduledExecutor();
                this.future = this.ex.schedule(this.command, 1L, TimeUnit.SECONDS);
            } else {
                this.future.cancel(false);
                this.future = this.ex.schedule(this.command, 1L, TimeUnit.SECONDS);
            }
            this.strNumber = this.strNumber + e.getKeyChar();
        }
    }
}

