/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryBase;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.DetectionPreviewPanel;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleConsumer;
import java.util.function.Supplier;
import javax.swing.JFormattedTextField;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;

public class DetectionPreview {
    private final DetectionPreviewPanel panel;

    protected DetectionPreview(Model model, Settings settings, SpotDetectorFactoryBase<?> detectorFactory, Supplier<Map<String, Object>> detectionSettingsSupplier, Supplier<Integer> currentFrameSupplier, DoubleConsumer thresholdUpdater, String axisLabel, String thresholdKey) {
        this.panel = new DetectionPreviewPanel(thresholdUpdater, axisLabel);
        this.panel.btnPreview.addActionListener(l -> this.preview(model, settings, detectorFactory, (Map)detectionSettingsSupplier.get(), (Integer)currentFrameSupplier.get(), thresholdKey));
    }

    public DetectionPreviewPanel getPanel() {
        return this.panel;
    }

    public Logger getLogger() {
        return this.panel.logger;
    }

    protected void preview(Model model, Settings settings, SpotDetectorFactoryBase<?> detectorFactory, Map<String, Object> detectorSettings, int frame, String thresholdKey) {
        this.panel.btnPreview.setEnabled(false);
        Threads.run("TrackMate preview detection thread", () -> {
            try {
                Pair<Model, Double> out = this.runPreviewDetection(settings, frame, detectorFactory, detectorSettings, thresholdKey);
                if (out == null) {
                    return;
                }
                Model sourceModel = (Model)out.getA();
                Double threshold = (Double)out.getB();
                this.panel.logger.log("Found " + sourceModel.getSpots().getNSpots(true) + " spots.");
                this.updateModelAndHistogram(model, sourceModel, frame, threshold);
            }
            catch (Exception e) {
                this.panel.logger.error(e.getMessage());
                e.printStackTrace();
            }
            finally {
                this.panel.btnPreview.setEnabled(true);
            }
        });
    }

    protected Pair<Model, Double> runPreviewDetection(Settings settings, int frame, SpotDetectorFactoryBase<?> detectorFactory, Map<String, Object> detectorSettings, String thresholdKey) {
        double threshold;
        boolean hasThreshold;
        Settings lSettings = new Settings(settings.imp);
        lSettings.tstart = frame;
        lSettings.tend = frame;
        settings.setRoi(settings.imp.getRoi());
        lSettings.detectorFactory = detectorFactory;
        lSettings.detectorSettings = new HashMap<String, Object>(detectorSettings);
        boolean bl = hasThreshold = thresholdKey != null && detectorSettings.containsKey(thresholdKey);
        if (hasThreshold) {
            threshold = (Double)detectorSettings.get(thresholdKey);
            lSettings.detectorSettings.put(thresholdKey, Double.NEGATIVE_INFINITY);
        } else {
            threshold = Double.NaN;
        }
        TrackMate trackmate = new TrackMate(lSettings);
        trackmate.getModel().setLogger(this.panel.logger);
        boolean detectionOk = trackmate.execDetection();
        if (!detectionOk) {
            this.panel.logger.error(trackmate.getErrorMessage());
            return null;
        }
        if (hasThreshold) {
            trackmate.getModel().getSpots().filter(new FeatureFilter("QUALITY", threshold, true));
        } else {
            trackmate.getModel().getSpots().setVisible(true);
        }
        return new ValuePair((Object)trackmate.getModel(), (Object)threshold);
    }

    protected void updateModelAndHistogram(Model targetModel, Model sourceModel, int frame, double threshold) {
        int nSpots = sourceModel.getSpots().getNSpots(frame, true);
        ArrayList<Spot> spotsToCopy = new ArrayList<Spot>(nSpots);
        Iterable<Spot> it = sourceModel.getSpots().iterable(frame, true);
        for (Spot spot : it) {
            spotsToCopy.add(spot);
        }
        if (targetModel != null) {
            targetModel.getSpots().put(frame, spotsToCopy);
            for (Spot spot : spotsToCopy) {
                spot.putFeature("VISIBILITY", SpotCollection.ONE);
            }
            targetModel.setSpots(targetModel.getSpots(), true);
        }
        if (this.panel.chart != null) {
            double[] values = FeatureUtils.collectFeatureValues("QUALITY", DisplaySettings.TrackMateObject.SPOTS, sourceModel, false);
            this.panel.chart.displayHistogram(values, threshold);
        }
    }

    public static Builder create() {
        return new Builder();
    }

    public static final class Builder {
        private Model model = null;
        private Settings settings = null;
        private SpotDetectorFactoryBase<?> detectorFactory = null;
        private Supplier<Map<String, Object>> detectionSettingsSupplier = null;
        private Supplier<Integer> frameSupplier = () -> this.settings.imp.getFrame() - 1;
        private DoubleConsumer thresholdUpdater = null;
        private String axisLabel = "Quality histogram";
        private String thresholdKey = "THRESHOLD";

        private Builder() {
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder detectorFactory(SpotDetectorFactoryBase<?> detectorFactory) {
            this.detectorFactory = detectorFactory;
            return this;
        }

        public Builder frameSupplier(Supplier<Integer> frameSupplier) {
            this.frameSupplier = frameSupplier;
            return this;
        }

        public Builder detectionSettingsSupplier(Supplier<Map<String, Object>> detectionSettingsSupplier) {
            this.detectionSettingsSupplier = detectionSettingsSupplier;
            return this;
        }

        public Builder thresholdUpdater(DoubleConsumer thresholdUpdater) {
            this.thresholdUpdater = thresholdUpdater;
            return this;
        }

        public Builder thresholdTextField(JFormattedTextField ftf) {
            if (ftf == null) {
                throw new IllegalArgumentException("The formatted field cannot be null.");
            }
            this.thresholdUpdater = threshold -> ftf.setValue(threshold);
            return this;
        }

        public Builder axisLabel(String axisLabel) {
            this.axisLabel = axisLabel;
            return this;
        }

        public Builder thresholdKey(String thresholdKey) {
            this.thresholdKey = thresholdKey;
            return this;
        }

        public DetectionPreview get() {
            if (this.settings == null) {
                throw new IllegalArgumentException("The 'settings' cannot be null.");
            }
            if (this.settings.imp == null) {
                throw new IllegalArgumentException("The image field in the 'settings' cannot be null.");
            }
            if (this.detectorFactory == null) {
                throw new IllegalArgumentException("The detector factory cannot be null.");
            }
            if (this.detectionSettingsSupplier == null) {
                throw new IllegalArgumentException("The detection settings supplier cannot be null.");
            }
            if (this.frameSupplier == null) {
                throw new IllegalArgumentException("The detection frame supplier cannot be null.");
            }
            return new DetectionPreview(this.model, this.settings, this.detectorFactory, this.detectionSettingsSupplier, this.frameSupplier, this.thresholdUpdater, this.axisLabel, this.thresholdKey);
        }
    }
}

