/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.kdtree;

import fiji.plugin.trackmate.tracking.kdtree.FlagNode;
import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.neighborsearch.NearestNeighborSearch;

public class NearestNeighborFlagSearchOnKDTree<T>
implements NearestNeighborSearch<FlagNode<T>> {
    protected KDTree<FlagNode<T>> tree;
    protected final int n;
    protected final double[] pos;
    protected KDTreeNode<FlagNode<T>> bestPoint;
    protected double bestSquDistance;

    public NearestNeighborFlagSearchOnKDTree(KDTree<FlagNode<T>> tree) {
        this.n = tree.numDimensions();
        this.pos = new double[this.n];
        this.tree = tree;
    }

    public int numDimensions() {
        return this.n;
    }

    public void search(RealLocalizable p) {
        p.localize(this.pos);
        this.bestSquDistance = Double.MAX_VALUE;
        this.searchNode(this.tree.getRoot());
    }

    protected void searchNode(KDTreeNode<FlagNode<T>> current) {
        KDTreeNode awayChild;
        double distance = current.squDistanceTo(this.pos);
        boolean visited = ((FlagNode)current.get()).isVisited();
        if (distance < this.bestSquDistance && !visited) {
            this.bestSquDistance = distance;
            this.bestPoint = current;
        }
        double axisDiff = this.pos[current.getSplitDimension()] - current.getSplitCoordinate();
        double axisSquDistance = axisDiff * axisDiff;
        boolean leftIsNearBranch = axisDiff < 0.0;
        KDTreeNode nearChild = leftIsNearBranch ? current.left : current.right;
        KDTreeNode kDTreeNode = awayChild = leftIsNearBranch ? current.right : current.left;
        if (nearChild != null) {
            this.searchNode(nearChild);
        }
        if (axisSquDistance <= this.bestSquDistance && awayChild != null) {
            this.searchNode(awayChild);
        }
    }

    public Sampler<FlagNode<T>> getSampler() {
        return this.bestPoint;
    }

    public RealLocalizable getPosition() {
        return this.bestPoint;
    }

    public double getSquareDistance() {
        return this.bestSquDistance;
    }

    public double getDistance() {
        return Math.sqrt(this.bestSquDistance);
    }

    public NearestNeighborFlagSearchOnKDTree<T> copy() {
        NearestNeighborFlagSearchOnKDTree<T> copy = new NearestNeighborFlagSearchOnKDTree<T>(this.tree);
        System.arraycopy(this.pos, 0, copy.pos, 0, this.pos.length);
        copy.bestPoint = this.bestPoint;
        copy.bestSquDistance = this.bestSquDistance;
        return copy;
    }
}

