/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman.costmatrix;

import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.CostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.SparseCostMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.imglib2.util.Util;

public class DefaultCostMatrixCreator<K extends Comparable<K>, J extends Comparable<J>>
implements CostMatrixCreator<K, J> {
    private static final String BASE_ERROR_MESSAGE = "[DefaultCostMatrixCreator] ";
    private SparseCostMatrix scm;
    private ArrayList<K> uniqueRows;
    private ArrayList<J> uniqueCols;
    private long processingTime;
    private String errorMessage;
    private double alternativeCost;
    private final List<K> rows;
    private final List<J> cols;
    private final double[] costs;
    private final double alternativeCostFactor;
    private final double percentile;

    public DefaultCostMatrixCreator(List<K> rows, List<J> cols, double[] costs, double alternativeCostFactor, double percentile) {
        this.rows = rows;
        this.cols = cols;
        this.costs = costs;
        this.alternativeCostFactor = alternativeCostFactor;
        this.percentile = percentile;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public SparseCostMatrix getResult() {
        return this.scm;
    }

    public boolean checkInput() {
        if (this.rows == null || this.rows.isEmpty()) {
            this.errorMessage = "[DefaultCostMatrixCreator] The row list is null or empty.";
            return false;
        }
        if (this.rows.size() != this.cols.size()) {
            this.errorMessage = "[DefaultCostMatrixCreator] Row and column lists do not have the same number of elements. Found " + this.rows.size() + " and " + this.cols.size() + ".";
            return false;
        }
        if (this.rows.size() != this.costs.length) {
            this.errorMessage = "[DefaultCostMatrixCreator] Row list and cost array do not have the same number of elements. Found " + this.rows.size() + " and " + this.costs.length + ".";
            return false;
        }
        if (this.alternativeCostFactor <= 0.0) {
            this.errorMessage = "[DefaultCostMatrixCreator] The alternative cost factor must be greater than 0. Was: " + this.alternativeCostFactor + ".";
            return false;
        }
        if (this.percentile < 0.0 || this.percentile > 1.0) {
            this.errorMessage = "[DefaultCostMatrixCreator] The percentile must no be smaller than 0 or greater than 1. Was: " + this.percentile;
            return false;
        }
        return true;
    }

    public boolean process() {
        this.uniqueRows = new ArrayList<K>(new HashSet<K>(this.rows));
        Collections.sort(this.uniqueRows);
        this.uniqueCols = new ArrayList<J>(new HashSet<J>(this.cols));
        Collections.sort(this.uniqueCols);
        ArrayList<Assignment> assignments = new ArrayList<Assignment>(this.costs.length);
        for (int i = 0; i < this.costs.length; ++i) {
            Comparable rowObj = (Comparable)this.rows.get(i);
            Comparable colObj = (Comparable)this.cols.get(i);
            int r = Collections.binarySearch(this.uniqueRows, rowObj);
            int c = Collections.binarySearch(this.uniqueCols, colObj);
            assignments.add(new Assignment(r, c, this.costs[i]));
        }
        Collections.sort(assignments);
        Assignment previousAssgn = (Assignment)assignments.get(0);
        for (int i = 1; i < assignments.size(); ++i) {
            Assignment assgn = (Assignment)assignments.get(i);
            if (assgn.equals(previousAssgn)) {
                this.errorMessage = "[DefaultCostMatrixCreator] Found duplicate assignment at index: " + assgn + ".";
                return false;
            }
            previousAssgn = assgn;
        }
        int nRows = this.uniqueRows.size();
        int nCols = this.uniqueCols.size();
        int[] kk = new int[this.costs.length];
        int[] number = new int[nRows];
        double[] cc = new double[this.costs.length];
        Assignment a = (Assignment)assignments.get(0);
        kk[0] = a.c;
        cc[0] = a.cost;
        int currentRow = a.r;
        int nOfEl = 0;
        for (int i = 1; i < assignments.size(); ++i) {
            a = (Assignment)assignments.get(i);
            kk[i] = a.c;
            cc[i] = a.cost;
            ++nOfEl;
            if (a.r == currentRow) continue;
            number[currentRow] = nOfEl;
            nOfEl = 0;
            currentRow = a.r;
        }
        number[currentRow] = nOfEl + 1;
        this.scm = new SparseCostMatrix(cc, kk, number, nCols);
        this.alternativeCost = this.computeAlternativeCosts();
        return true;
    }

    protected double computeAlternativeCosts() {
        if (this.percentile == 1.0) {
            return this.alternativeCostFactor * Util.max((double[])this.costs);
        }
        return this.alternativeCostFactor * Util.percentile((double[])this.costs, (double)this.percentile);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public List<K> getSourceList() {
        return this.uniqueRows;
    }

    @Override
    public List<J> getTargetList() {
        return this.uniqueCols;
    }

    @Override
    public double getAlternativeCostForSource(K source) {
        return this.alternativeCost;
    }

    @Override
    public double getAlternativeCostForTarget(J target) {
        return this.alternativeCost;
    }

    public static final class Assignment
    implements Comparable<Assignment> {
        private final int r;
        private final int c;
        private final double cost;

        public Assignment(int r, int c, double cost) {
            this.r = r;
            this.c = c;
            this.cost = cost;
        }

        @Override
        public int compareTo(Assignment o) {
            if (this.r == o.r) {
                return this.c - o.c;
            }
            return this.r - o.r;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Assignment) {
                Assignment o = (Assignment)obj;
                return this.r == o.r && this.c == o.c;
            }
            return false;
        }

        public int hashCode() {
            int hash = 23;
            hash = hash * 31 + this.r;
            hash = hash * 31 + this.c;
            return hash;
        }

        public String toString() {
            return "Assignment r = " + this.r + ", c = " + this.c + ", cost = " + this.cost;
        }

        public int getC() {
            return this.c;
        }

        public int getR() {
            return this.r;
        }

        public double getCost() {
            return this.cost;
        }
    }
}

